/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.openLayers;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.ReadyStateChangeListener;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.util.EventDispatch;
import org.lobobrowser.util.GenericEventListener;
import org.lobobrowser.util.Urls;
import org.lobobrowser.util.io.IORoutines;
import org.openstreetmap.josm.plugins.openLayers.HttpResponse;
import org.w3c.dom.Document;

public class CacheableHttpRequest
implements HttpRequest {
    private static final Logger logger = Logger.getLogger(CacheableHttpRequest.class.getName());
    protected final UserAgentContext context;
    protected final Proxy proxy;
    protected boolean isAsync;
    protected String requestMethod;
    protected String requestUserName;
    protected String requestPassword;
    protected URL requestURL;
    protected HttpResponse response;
    protected int readyState;
    protected URLConnection connection;
    private final EventDispatch readyEvent = new EventDispatch();

    public CacheableHttpRequest(UserAgentContext context, Proxy proxy) {
        this.context = context;
        this.proxy = proxy;
    }

    public synchronized int getReadyState() {
        return this.readyState;
    }

    public synchronized String getResponseText() {
        if (this.response == null) {
            return null;
        }
        byte[] bytes = this.response.responseBytes;
        String encoding = this.response.encoding;
        try {
            return bytes == null ? null : new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException uee) {
            logger.log(Level.WARNING, "getResponseText(): Charset '" + encoding + "' did not work. Retrying with ISO-8859-1.", uee);
            try {
                return new String(bytes, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee2) {
                return null;
            }
        }
    }

    public synchronized Document getResponseXML() {
        if (this.response == null) {
            return null;
        }
        byte[] bytes = this.response.responseBytes;
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        }
        catch (Exception err) {
            logger.log(Level.WARNING, "Unable to parse response as XML.", err);
            return null;
        }
    }

    public synchronized byte[] getResponseBytes() {
        if (this.response == null) {
            return null;
        }
        return this.response.responseBytes;
    }

    public synchronized Image getResponseImage() {
        if (this.response == null) {
            return null;
        }
        byte[] bytes = this.response.responseBytes;
        if (bytes == null) {
            return null;
        }
        return Toolkit.getDefaultToolkit().createImage(bytes);
    }

    public synchronized int getStatus() {
        if (this.response == null) {
            return 0;
        }
        return this.response.status;
    }

    public synchronized String getStatusText() {
        if (this.response == null) {
            return null;
        }
        return this.response.statusText;
    }

    public synchronized String getAllResponseHeaders() {
        if (this.response == null) {
            return null;
        }
        return this.response.responseHeaders;
    }

    public synchronized String getResponseHeader(String headerName) {
        if (this.response == null) {
            return null;
        }
        Map<String, List<String>> headers = this.response.responseHeadersMap;
        return headers == null ? null : (String)((Object)headers.get(headerName));
    }

    public void open(String method, String url) throws IOException {
        this.open(method, url, true);
    }

    public void open(String method, URL url) throws IOException {
        this.open(method, url, true, null, null);
    }

    public void open(String method, URL url, boolean asyncFlag) throws IOException {
        this.open(method, url, asyncFlag, null, null);
    }

    public void open(String method, String url, boolean asyncFlag) throws IOException {
        URL urlObj = Urls.createURL(null, url);
        this.open(method, urlObj, asyncFlag, null);
    }

    public void open(String method, URL url, boolean asyncFlag, String userName) throws IOException {
        this.open(method, url, asyncFlag, userName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        URLConnection c;
        CacheableHttpRequest cacheableHttpRequest = this;
        synchronized (cacheableHttpRequest) {
            c = this.connection;
            this.response = null;
        }
        if (c instanceof HttpURLConnection) {
            ((HttpURLConnection)c).disconnect();
        } else if (c != null) {
            try {
                c.getInputStream().close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String method, URL url, boolean asyncFlag, String userName, String password) throws IOException {
        this.abort();
        HttpResponse response = HttpResponse.lookup(url);
        URLConnection c = null;
        if (response == null) {
            c = this.proxy == null || this.proxy == Proxy.NO_PROXY ? url.openConnection() : url.openConnection(this.proxy);
            response = new HttpResponse();
        }
        CacheableHttpRequest cacheableHttpRequest = this;
        synchronized (cacheableHttpRequest) {
            this.connection = c;
            this.isAsync = asyncFlag;
            this.requestMethod = method;
            this.requestUserName = userName;
            this.requestPassword = password;
            this.requestURL = url;
            this.response = response;
            if (response.loaded) {
                this.changeState(1);
            } else {
                this.changeState(1, 0, null, null);
            }
        }
    }

    public void send(final String content) throws IOException {
        final URL url = this.requestURL;
        if (url == null) {
            throw new IOException("No URL has been provided.");
        }
        if (this.isAsync) {
            new Thread("SimpleHttpRequest-" + url.getHost()){

                public void run() {
                    try {
                        CacheableHttpRequest.this.sendSync(content);
                    }
                    catch (Throwable thrown) {
                        logger.log(Level.WARNING, "send(): Error in asynchronous request on " + url, thrown);
                    }
                }
            }.start();
        } else {
            this.sendSync(content);
        }
    }

    protected String getPostCharset() {
        return "UTF-8";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendSync(String content) throws IOException {
        if (this.response.loaded) {
            this.changeState(2);
            this.changeState(3);
            this.changeState(4);
            return;
        }
        try {
            URLConnection c;
            CacheableHttpRequest cacheableHttpRequest = this;
            synchronized (cacheableHttpRequest) {
                c = this.connection;
            }
            c.setRequestProperty("User-Agent", this.context.getUserAgent());
            int istatus = 0;
            String istatusText = "";
            InputStream err = null;
            if (c instanceof HttpURLConnection) {
                HttpURLConnection hc = (HttpURLConnection)c;
                String method = this.requestMethod.toUpperCase();
                hc.setRequestMethod(method);
                if ("POST".equals(method) && content != null) {
                    hc.setDoOutput(true);
                    byte[] contentBytes = content.getBytes(this.getPostCharset());
                    hc.setFixedLengthStreamingMode(contentBytes.length);
                    OutputStream out = hc.getOutputStream();
                    try {
                        out.write(contentBytes);
                    }
                    finally {
                        out.flush();
                    }
                }
                istatus = hc.getResponseCode();
                istatusText = hc.getResponseMessage();
                err = hc.getErrorStream();
            }
            this.response.setConnectionInfo(c);
            this.changeState(2, istatus, istatusText, null);
            InputStream in = err == null ? c.getInputStream() : err;
            int contentLength = c.getContentLength();
            this.changeState(3, istatus, istatusText, null);
            byte[] bytes = IORoutines.load(in, contentLength == -1 ? 4096 : contentLength);
            this.changeState(4, istatus, istatusText, bytes);
            this.response.store(this.requestURL);
        }
        finally {
            CacheableHttpRequest cacheableHttpRequest = this;
            synchronized (cacheableHttpRequest) {
                this.connection = null;
            }
        }
    }

    public void addReadyStateChangeListener(final ReadyStateChangeListener listener) {
        this.readyEvent.addListener(new GenericEventListener(){

            public void processEvent(EventObject event) {
                listener.readyStateChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeState(int readyState, int status, String statusMessage, byte[] bytes) {
        CacheableHttpRequest cacheableHttpRequest = this;
        synchronized (cacheableHttpRequest) {
            this.readyState = readyState;
            this.response.changeState(status, statusMessage, bytes);
        }
        this.readyEvent.fireEvent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeState(int readyState) {
        CacheableHttpRequest cacheableHttpRequest = this;
        synchronized (cacheableHttpRequest) {
            this.readyState = readyState;
        }
        this.readyEvent.fireEvent(null);
    }
}

