/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import org.lobobrowser.html.renderer.FloatingBounds;

class ShiftedFloatingBounds
implements FloatingBounds {
    private final FloatingBounds prevBounds;
    private final int shiftLeft;
    private final int shiftRight;
    private final int shiftY;

    public ShiftedFloatingBounds(FloatingBounds prevBounds, int shiftLeft, int shiftRight, int shiftY) {
        this.prevBounds = prevBounds;
        this.shiftLeft = shiftLeft;
        this.shiftRight = shiftRight;
        this.shiftY = shiftY;
    }

    public int getClearY(int y) {
        return this.prevBounds.getClearY(y - this.shiftY) + this.shiftY;
    }

    public int getFirstClearY(int y) {
        return this.prevBounds.getFirstClearY(y - this.shiftY) + this.shiftY;
    }

    public int getLeft(int y) {
        return this.prevBounds.getLeft(y - this.shiftY) + this.shiftLeft;
    }

    public int getLeftClearY(int y) {
        return this.prevBounds.getLeftClearY(y - this.shiftY) + this.shiftY;
    }

    public int getRight(int y) {
        return this.prevBounds.getRight(y - this.shiftY) + this.shiftRight;
    }

    public int getRightClearY(int y) {
        return this.prevBounds.getRightClearY(y - this.shiftY) + this.shiftY;
    }

    public int getMaxY() {
        return this.prevBounds.getMaxY() + this.shiftY;
    }
}

