/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Insets;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.renderer.BaseRListElement;
import org.lobobrowser.html.renderer.FloatingBounds;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.style.ListStyle;
import org.lobobrowser.html.style.RenderState;

class RList
extends BaseRListElement {
    private int counterStart;

    public RList(NodeImpl modelNode, int listNesting, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RenderableContainer parentContainer, RCollection parent) {
        super(modelNode, listNesting, pcontext, rcontext, frameContext, parentContainer);
        this.defaultMarginInsets = new Insets(5, 0, 5, 0);
    }

    protected void applyStyle() {
        ListStyle listStyle;
        super.applyStyle();
        this.counterStart = 1;
        ModelNode rootNode = this.modelNode;
        if (!(rootNode instanceof HTMLElementImpl)) {
            return;
        }
        HTMLElementImpl rootElement = (HTMLElementImpl)rootNode;
        String startText = rootElement.getAttribute("start");
        if (startText != null) {
            try {
                this.counterStart = Integer.parseInt(startText);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((listStyle = this.listStyle) == null || listStyle.type == 0) {
            int listNesting;
            if (listStyle == null) {
                this.listStyle = listStyle = new ListStyle();
            }
            listStyle.type = "ul".equalsIgnoreCase(rootElement.getTagName()) ? ((listNesting = this.listNesting) == 0 ? 1 : (listNesting == 1 ? 2 : 3)) : 4;
        }
    }

    public void doLayout(int availWidth, int availHeight, FloatingBounds floatBounds, int tentativeY, int defaultOverflow) {
        RenderState renderState = this.modelNode.getRenderState();
        renderState.resetCount("$cobra.counter", this.listNesting, this.counterStart);
        super.doLayout(availWidth, availHeight, floatBounds, tentativeY, defaultOverflow);
    }
}

