/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.BrowserFrame;
import org.lobobrowser.html.HtmlObject;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLIFrameElementImpl;
import org.lobobrowser.html.domimpl.HTMLImageElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.renderer.BaseBoundableRenderable;
import org.lobobrowser.html.renderer.BaseElementRenderable;
import org.lobobrowser.html.renderer.BaseInputControl;
import org.lobobrowser.html.renderer.BaseRCollection;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.BrowserFrameUIControl;
import org.lobobrowser.html.renderer.CombinedFloatingBounds;
import org.lobobrowser.html.renderer.DelayedPair;
import org.lobobrowser.html.renderer.ExportedRenderable;
import org.lobobrowser.html.renderer.FloatingBounds;
import org.lobobrowser.html.renderer.FloatingBoundsSource;
import org.lobobrowser.html.renderer.FloatingViewportBounds;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.HrControl;
import org.lobobrowser.html.renderer.ImgControl;
import org.lobobrowser.html.renderer.InputButtonControl;
import org.lobobrowser.html.renderer.InputCheckboxControl;
import org.lobobrowser.html.renderer.InputFileControl;
import org.lobobrowser.html.renderer.InputImageControl;
import org.lobobrowser.html.renderer.InputPasswordControl;
import org.lobobrowser.html.renderer.InputRadioControl;
import org.lobobrowser.html.renderer.InputSelectControl;
import org.lobobrowser.html.renderer.InputTextAreaControl;
import org.lobobrowser.html.renderer.InputTextControl;
import org.lobobrowser.html.renderer.LineBreak;
import org.lobobrowser.html.renderer.MarkupLayout;
import org.lobobrowser.html.renderer.MarkupUtilities;
import org.lobobrowser.html.renderer.OverflowException;
import org.lobobrowser.html.renderer.PositionedRenderable;
import org.lobobrowser.html.renderer.RBlank;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RFloatInfo;
import org.lobobrowser.html.renderer.RImgControl;
import org.lobobrowser.html.renderer.RLine;
import org.lobobrowser.html.renderer.RList;
import org.lobobrowser.html.renderer.RListItem;
import org.lobobrowser.html.renderer.RRelative;
import org.lobobrowser.html.renderer.RSpacing;
import org.lobobrowser.html.renderer.RStyleChanger;
import org.lobobrowser.html.renderer.RTable;
import org.lobobrowser.html.renderer.RUIControl;
import org.lobobrowser.html.renderer.RWord;
import org.lobobrowser.html.renderer.Range;
import org.lobobrowser.html.renderer.Renderable;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.ShiftedFloatingBounds;
import org.lobobrowser.html.renderer.SizeExceededException;
import org.lobobrowser.html.renderer.UIControl;
import org.lobobrowser.html.renderer.UIControlWrapper;
import org.lobobrowser.html.renderer.ZIndexComparator;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.ArrayUtilities;

public class RBlockViewport
extends BaseRCollection {
    public static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    private static final Logger logger = Logger.getLogger(RBlockViewport.class.getName());
    private final RenderableContainer container;
    private final int listNesting;
    private final UserAgentContext userAgentContext;
    private final HtmlRendererContext rendererContext;
    private final FrameContext frameContext;
    private SortedSet positionedRenderables;
    private ArrayList seqRenderables = null;
    private RLine currentLine;
    private int maxX;
    private int maxY;
    private int desiredWidth;
    private int desiredHeight;
    private int availContentHeight;
    private int availContentWidth;
    private int yLimit;
    private int positionedOrdinal;
    private Insets paddingInsets;
    private boolean overrideNoWrap;
    private FloatingBounds floatBounds = null;
    private boolean skipParagraphBreakBefore;
    private static final Map elementLayout = new HashMap(70);
    private static final MarkupLayout miscLayout = new MiscLayout();
    private static final SizeExceededException SEE;
    private BoundableRenderable armedRenderable;
    private Collection pendingFloats = null;
    private Boolean isFloatLimit = null;

    public RBlockViewport(ModelNode modelNode, RenderableContainer container, int listNesting, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RCollection parent) {
        super(container, modelNode);
        this.parent = parent;
        this.userAgentContext = pcontext;
        this.rendererContext = rcontext;
        this.frameContext = frameContext;
        this.container = container;
        this.listNesting = listNesting;
        this.layoutUpTreeCanBeInvalidated = true;
    }

    public void invalidateLayoutLocal() {
        this.layoutUpTreeCanBeInvalidated = true;
    }

    public int getAvailContentWidth() {
        return this.availContentWidth;
    }

    public void layout(int desiredWidth, int desiredHeight, Insets paddingInsets, int yLimit, FloatingBounds floatBounds) {
        int maxY;
        int lastTopY;
        int availh;
        if (!EventQueue.isDispatchThread() && logger.isLoggable(Level.INFO)) {
            logger.warning("layout(): Invoked outside GUI dispatch thread.");
        }
        RenderableContainer container = this.container;
        this.paddingInsets = paddingInsets;
        this.yLimit = yLimit;
        this.desiredHeight = desiredHeight;
        this.desiredWidth = desiredWidth;
        this.floatBounds = floatBounds;
        this.isFloatLimit = null;
        this.pendingFloats = null;
        this.maxX = paddingInsets.left;
        this.maxY = paddingInsets.top;
        int availw = desiredWidth - paddingInsets.left - paddingInsets.right;
        if (availw < 0) {
            availw = 0;
        }
        if ((availh = desiredHeight - paddingInsets.top - paddingInsets.bottom) == 0) {
            availh = 0;
        }
        this.availContentHeight = availh;
        this.availContentWidth = availw;
        this.layoutPass((NodeImpl)this.modelNode);
        Collection delayedPairs = container.getDelayedPairs();
        if (delayedPairs != null && delayedPairs.size() > 0) {
            Iterator i = delayedPairs.iterator();
            while (i.hasNext()) {
                DelayedPair pair = (DelayedPair)i.next();
                if (pair.targetParent != container) continue;
                this.importDelayedPair(pair);
            }
        }
        RLine lastLine = this.currentLine;
        Rectangle lastBounds = lastLine.getBounds();
        int lastTopX = lastBounds.x + lastBounds.width;
        if (lastTopX > this.maxX) {
            this.maxX = lastTopX;
        }
        if ((lastTopY = lastBounds.y + lastBounds.height) > (maxY = this.maxY)) {
            this.maxY = maxY = lastTopY;
        }
        this.width = paddingInsets.right + this.maxX;
        this.height = paddingInsets.bottom + maxY;
    }

    private void layoutPass(NodeImpl rootNode) {
        RenderableContainer container = this.container;
        container.clearDelayedPairs();
        this.positionedOrdinal = 0;
        this.seqRenderables = null;
        this.positionedRenderables = null;
        this.currentLine = this.addLine(rootNode, null, this.paddingInsets.top);
        this.skipParagraphBreakBefore = true;
        this.layoutChildren(rootNode);
        this.lineDone(this.currentLine);
    }

    public void alignX(int alignXPercent, int canvasWidth, Insets paddingInsets) {
        ArrayList renderables;
        int prevMaxY = this.maxY;
        if (alignXPercent > 0 && (renderables = this.seqRenderables) != null) {
            Insets insets = this.paddingInsets;
            FloatingBounds floatBounds = this.floatBounds;
            int numRenderables = renderables.size();
            int yoffset = 0;
            for (int i = 0; i < numRenderables; ++i) {
                int rightOffset;
                boolean isVisibleBlock;
                int leftOffset;
                int actualAvailWidth;
                int difference;
                int newY;
                Object r = renderables.get(i);
                if (!(r instanceof BoundableRenderable)) continue;
                BoundableRenderable seqRenderable = (BoundableRenderable)r;
                int y = seqRenderable.getY();
                if (yoffset > 0) {
                    newY = y + yoffset;
                    seqRenderable.setY(newY);
                    if (newY + seqRenderable.getHeight() > this.maxY) {
                        this.maxY = newY + seqRenderable.getHeight();
                    }
                } else {
                    newY = y;
                }
                if ((difference = (actualAvailWidth = canvasWidth - (leftOffset = (isVisibleBlock = seqRenderable instanceof RBlock && ((RBlock)seqRenderable).isOverflowVisible()) ? insets.left : this.fetchLeftOffset(y)) - (rightOffset = isVisibleBlock ? insets.right : this.fetchRightOffset(y))) - seqRenderable.getWidth()) <= 0) continue;
                int shift = difference * alignXPercent / 100;
                int newX = leftOffset + shift;
                seqRenderable.setX(newX);
                if (floatBounds == null || !isVisibleBlock) continue;
                RBlock block = (RBlock)seqRenderable;
                yoffset += this.readjustBlock(block, newX, newY, floatBounds);
            }
        }
        if (prevMaxY != this.maxY) {
            this.height += this.maxY - prevMaxY;
        }
    }

    public void alignY(int alignYPercent, int canvasHeight, Insets paddingInsets) {
        int usedHeight;
        int availContentHeight;
        int difference;
        int prevMaxY = this.maxY;
        if (alignYPercent > 0 && (difference = (availContentHeight = canvasHeight - paddingInsets.top - paddingInsets.bottom) - (usedHeight = this.maxY - paddingInsets.top)) > 0) {
            SortedSet others;
            int shift = difference * alignYPercent / 100;
            ArrayList rlist = this.seqRenderables;
            if (rlist != null) {
                Iterator renderables = rlist.iterator();
                while (renderables.hasNext()) {
                    Object r = renderables.next();
                    if (!(r instanceof BoundableRenderable)) continue;
                    BoundableRenderable line = (BoundableRenderable)r;
                    int newY = line.getY() + shift;
                    line.setY(newY);
                    if (newY + line.getHeight() <= this.maxY) continue;
                    this.maxY = newY + line.getHeight();
                }
            }
            if ((others = this.positionedRenderables) != null) {
                Iterator i2 = others.iterator();
                while (i2.hasNext()) {
                    PositionedRenderable pr = (PositionedRenderable)i2.next();
                    if (!pr.verticalAlignable) continue;
                    BoundableRenderable br = pr.renderable;
                    int newY = br.getY() + shift;
                    br.setY(newY);
                    if (newY + br.getHeight() <= this.maxY) continue;
                    this.maxY = newY + br.getHeight();
                }
            }
        }
        if (prevMaxY != this.maxY) {
            this.height += this.maxY - prevMaxY;
        }
    }

    private int readjustBlock(RBlock block, final int newX, final int newY, final FloatingBounds floatBounds) {
        int rightInsets = this.paddingInsets.right;
        final int expectedWidth = this.desiredWidth - rightInsets - newX;
        final int blockShiftRight = rightInsets;
        int prevHeight = block.height;
        FloatingBoundsSource floatBoundsSource = new FloatingBoundsSource(){

            public FloatingBounds getChildBlockFloatingBounds(int apparentBlockWidth) {
                int actualRightShift = blockShiftRight + (expectedWidth - apparentBlockWidth);
                return new ShiftedFloatingBounds(floatBounds, -newX, -actualRightShift, -newY);
            }
        };
        block.adjust(expectedWidth, this.availContentHeight, true, false, floatBoundsSource);
        return block.height - prevHeight;
    }

    private RLine addLine(ModelNode startNode, RLine prevLine, int newLineY) {
        int leftOffset;
        this.lineDone(prevLine);
        this.checkY(newLineY);
        int newX = leftOffset = this.fetchLeftOffset(newLineY);
        int newMaxWidth = this.desiredWidth - this.fetchRightOffset(newLineY) - leftOffset;
        if (prevLine == null) {
            int textIndent;
            RenderState rs = this.modelNode.getRenderState();
            int n = textIndent = rs == null ? 0 : rs.getTextIndent(this.availContentWidth);
            if (textIndent != 0) {
                newMaxWidth += leftOffset - (newX += textIndent);
            }
        } else if (prevLine.x + prevLine.width > this.maxX) {
            this.maxX = prevLine.x + prevLine.width;
        }
        RLine rline = new RLine(startNode, this.container, newX, newLineY, newMaxWidth, 0);
        rline.setParent(this);
        ArrayList<RLine> sr = this.seqRenderables;
        if (sr == null) {
            this.seqRenderables = sr = new ArrayList<RLine>(1);
        }
        sr.add(rline);
        this.currentLine = rline;
        return rline;
    }

    private void layoutMarkup(NodeImpl node) {
        RLine line;
        RenderState rs = node.getRenderState();
        Insets marginInsets = null;
        Insets paddingInsets = null;
        if (rs != null) {
            marginInsets = rs.getMarginInsets();
            paddingInsets = rs.getPaddingInsets();
        }
        int leftSpacing = 0;
        int rightSpacing = 0;
        if (marginInsets != null) {
            leftSpacing += marginInsets.left;
            rightSpacing += marginInsets.right;
        }
        if (paddingInsets != null) {
            leftSpacing += paddingInsets.left;
            rightSpacing += paddingInsets.right;
        }
        if (leftSpacing > 0) {
            line = this.currentLine;
            line.addSpacing(new RSpacing(node, this.container, leftSpacing, line.height));
        }
        this.layoutChildren(node);
        if (rightSpacing > 0) {
            line = this.currentLine;
            line.addSpacing(new RSpacing(node, this.container, rightSpacing, line.height));
        }
    }

    private void layoutChildren(NodeImpl node) {
        NodeImpl[] childrenArray = node.getChildrenArray();
        if (childrenArray != null) {
            int length = childrenArray.length;
            for (int i = 0; i < length; ++i) {
                NodeImpl child = childrenArray[i];
                short nodeType = child.getNodeType();
                if (nodeType == 3) {
                    this.layoutText(child);
                    continue;
                }
                if (nodeType == 1) {
                    this.currentLine.addStyleChanger(new RStyleChanger(child));
                    String nodeName = child.getNodeName().toUpperCase();
                    MarkupLayout ml = (MarkupLayout)elementLayout.get(nodeName);
                    if (ml == null) {
                        ml = miscLayout;
                    }
                    ml.layoutMarkup(this, (HTMLElementImpl)child);
                    this.currentLine.addStyleChanger(new RStyleChanger(node));
                    continue;
                }
                if (nodeType == 8 || nodeType == 7) continue;
                throw new IllegalStateException("Unknown node: " + child);
            }
        }
    }

    private final void positionRBlock(HTMLElementImpl markupElement, RBlock renderable) {
        this.positionRElement(markupElement, renderable, false, renderable.isOverflowVisible());
    }

    private final void positionRElement(HTMLElementImpl markupElement, RElement renderable, boolean usesAlignAttribute, boolean obeysFloats) {
        if (!this.addElsewhereIfPositioned(renderable, markupElement, usesAlignAttribute, true, false)) {
            int availContentWidth = this.availContentWidth;
            int availContentHeight = this.availContentHeight;
            RLine line = this.currentLine;
            this.lineDone(line);
            if (obeysFloats) {
                int newLineY = line == null ? this.paddingInsets.top : line.y + line.height;
                int leftOffset = this.fetchLeftOffset(newLineY);
                int rightOffset = this.fetchRightOffset(newLineY);
                availContentWidth = this.desiredWidth - leftOffset - rightOffset;
            }
            renderable.layout(availContentWidth, availContentHeight);
            this.addAsSeqBlock(renderable, obeysFloats, false);
        }
    }

    private final void layoutRBlock(HTMLElementImpl markupElement, Insets defaultMarginInsets) {
        RBlock renderable = (RBlock)markupElement.getUINode();
        if (renderable == null) {
            renderable = new RBlock(markupElement, this.listNesting, this.userAgentContext, this.rendererContext, this.frameContext, this.container, 0);
            markupElement.setUINode(renderable);
        }
        renderable.setOriginalParent(this);
        renderable.setDefaultMarginInsets(defaultMarginInsets);
        this.positionRBlock(markupElement, renderable);
    }

    private final void layoutRTable(HTMLElementImpl markupElement) {
        RElement renderable = (RElement)markupElement.getUINode();
        if (renderable == null) {
            renderable = new RTable(markupElement, this.userAgentContext, this.rendererContext, this.frameContext, this.container);
            markupElement.setUINode(renderable);
        }
        renderable.setOriginalParent(this);
        this.positionRElement(markupElement, renderable, markupElement instanceof HTMLTableElementImpl, true);
    }

    private final void layoutListItem(HTMLElementImpl markupElement) {
        RListItem renderable = (RListItem)markupElement.getUINode();
        if (renderable == null) {
            renderable = new RListItem((NodeImpl)markupElement, this.listNesting, this.userAgentContext, this.rendererContext, this.frameContext, this.container, null);
            markupElement.setUINode(renderable);
        }
        renderable.setOriginalParent(this);
        this.positionRBlock(markupElement, renderable);
    }

    private final void layoutList(HTMLElementImpl markupElement) {
        RList renderable = (RList)markupElement.getUINode();
        if (renderable == null) {
            renderable = new RList((NodeImpl)markupElement, this.listNesting, this.userAgentContext, this.rendererContext, this.frameContext, this.container, null);
            markupElement.setUINode(renderable);
        }
        renderable.setOriginalParent(this);
        this.positionRBlock(markupElement, renderable);
    }

    private void addParagraphBreak(ModelNode startNode) {
        this.addLineBreak(startNode, 0);
        this.addLineBreak(startNode, 0);
    }

    private void addLineBreak(ModelNode startNode, int breakType) {
        int newLineY;
        RLine line = this.currentLine;
        if (line == null) {
            Insets insets = this.paddingInsets;
            this.addLine(startNode, null, insets.top);
            line = this.currentLine;
        }
        if (line.getHeight() == 0) {
            RenderState rs = startNode.getRenderState();
            int fontHeight = rs.getFontMetrics().getHeight();
            line.setHeight(fontHeight);
        }
        line.setLineBreak(new LineBreak(breakType, startNode));
        FloatingBounds fb = this.floatBounds;
        if (breakType == 0 || fb == null) {
            newLineY = line == null ? this.paddingInsets.top : line.y + line.height;
        } else {
            int prevY = line == null ? this.paddingInsets.top : line.y + line.height;
            switch (breakType) {
                case 1: {
                    newLineY = fb.getLeftClearY(prevY);
                    break;
                }
                case 2: {
                    newLineY = fb.getRightClearY(prevY);
                    break;
                }
                default: {
                    newLineY = fb.getClearY(prevY);
                }
            }
        }
        this.currentLine = this.addLine(startNode, line, newLineY);
    }

    private boolean addElsewhereIfFloat(BoundableRenderable renderable, HTMLElementImpl element, boolean usesAlignAttribute, AbstractCSS2Properties style, boolean layout, boolean adjust) {
        String align = null;
        if (style != null && (align = style.getFloat()) != null && align.length() == 0) {
            align = null;
        }
        if (align == null && usesAlignAttribute) {
            align = element.getAttribute("align");
        }
        if (align != null) {
            if ("left".equalsIgnoreCase(align)) {
                this.layoutFloat(renderable, layout, adjust, true);
                return true;
            }
            if ("right".equalsIgnoreCase(align)) {
                this.layoutFloat(renderable, layout, adjust, false);
                return true;
            }
        }
        return false;
    }

    final RBlockViewport getParentViewport(ExportedRenderable er) {
        if (er.alignment == 0) {
            return this.getParentViewport();
        }
        return this.getParentViewportForAlign();
    }

    final RBlockViewport getParentViewport() {
        RCollection parent;
        for (parent = this.getOriginalOrCurrentParent(); parent != null && !(parent instanceof RBlockViewport); parent = parent.getOriginalOrCurrentParent()) {
        }
        return (RBlockViewport)parent;
    }

    final RBlockViewport getParentViewportForAlign() {
        RBlock block;
        RCollection parent = this.getOriginalOrCurrentParent();
        if (parent instanceof RBlock && !(block = (RBlock)parent).couldBeScrollable() && (parent = ((BaseElementRenderable)parent).getOriginalOrCurrentParent()) instanceof RBlockViewport) {
            return (RBlockViewport)parent;
        }
        return null;
    }

    private static int getPosition(HTMLElementImpl element) {
        RenderState rs = element.getRenderState();
        return rs == null ? 0 : rs.getPosition();
    }

    private boolean addElsewhereIfPositioned(RElement renderable, HTMLElementImpl element, boolean usesAlignAttribute, boolean layout, boolean obeysFloats) {
        boolean relative;
        AbstractCSS2Properties style = element.getCurrentStyle();
        int position = RBlockViewport.getPosition(element);
        boolean absolute = position == 1;
        boolean bl = relative = position == 2;
        if (absolute || relative) {
            int newLeft;
            int lineBottomY;
            if (layout) {
                renderable.layout(this.availContentWidth, this.availContentHeight);
                if (absolute && renderable instanceof RBlock) {
                    ((RBlock)renderable).adjust();
                }
            }
            RenderState rs = element.getRenderState();
            String leftText = style.getLeft();
            RLine line = this.currentLine;
            int n = lineBottomY = line == null ? 0 : line.getY() + line.getHeight();
            if (leftText != null) {
                newLeft = HtmlValues.getPixelSize(leftText, rs, 0, this.availContentWidth);
            } else {
                String rightText = style.getRight();
                if (rightText != null) {
                    int right = HtmlValues.getPixelSize(rightText, rs, 0, this.availContentWidth);
                    newLeft = this.desiredWidth - right - renderable.getWidth();
                } else {
                    newLeft = 0;
                }
            }
            int newTop = relative ? 0 : lineBottomY;
            String topText = style.getTop();
            if (topText != null) {
                newTop = HtmlValues.getPixelSize(topText, rs, newTop, this.availContentHeight);
            } else {
                String bottomText = style.getBottom();
                if (bottomText != null) {
                    int bottom = HtmlValues.getPixelSize(bottomText, rs, 0, this.availContentHeight);
                    newTop = this.desiredHeight - bottom - renderable.getHeight();
                    if (!relative && newTop < 0) {
                        newTop = 0;
                    }
                }
            }
            if (relative) {
                RRelative rrel = new RRelative(this.container, element, renderable, newLeft, newTop);
                rrel.adjustSize();
                if (!this.addElsewhereIfFloat(rrel, element, usesAlignAttribute, style, false, true)) {
                    this.addAsSeqBlock(rrel, obeysFloats, true);
                } else {
                    rrel.adjustSize();
                }
            } else {
                this.scheduleAbsDelayedPair(renderable, newLeft, newTop);
                return true;
            }
            int newBottomY = renderable.getY() + renderable.getHeight();
            this.checkY(newBottomY);
            if (newBottomY > this.maxY) {
                this.maxY = newBottomY;
            }
            return true;
        }
        return this.addElsewhereIfFloat(renderable, element, usesAlignAttribute, style, layout, layout);
    }

    private void addRenderableToLineCheckStyle(RElement renderable, HTMLElementImpl element, boolean usesAlignAttribute) {
        if (this.addElsewhereIfPositioned(renderable, element, usesAlignAttribute, false, true)) {
            return;
        }
        this.addRenderableToLine(renderable);
    }

    private void addRenderableToLine(Renderable renderable) {
        RenderState rs = renderable.getModelNode().getRenderState();
        int whiteSpace = this.overrideNoWrap ? 2 : rs.getWhiteSpace();
        boolean allowOverflow = whiteSpace == 2 || whiteSpace == 1;
        RLine line = this.currentLine;
        int liney = line.y;
        boolean emptyLine = line.isEmpty();
        FloatingBounds floatBounds = this.floatBounds;
        int cleary = floatBounds != null ? floatBounds.getFirstClearY(liney) : liney + line.height;
        int overflowType = floatBounds != null && cleary != liney ? 2 : (allowOverflow ? 0 : 1);
        this.skipParagraphBreakBefore = false;
        try {
            line.add(renderable, overflowType);
        }
        catch (OverflowException oe) {
            int nextY = emptyLine ? cleary : liney + line.height;
            this.addLine(renderable.getModelNode(), line, nextY);
            Collection renderables = oe.getRenderables();
            Iterator i = renderables.iterator();
            while (i.hasNext()) {
                Renderable r = (Renderable)i.next();
                this.addRenderableToLine(r);
            }
        }
        if (renderable instanceof RUIControl) {
            this.container.addComponent(((RUIControl)renderable).widget.getComponent());
        }
    }

    private void addWordToLine(RWord renderable, boolean allowOverflow) {
        this.skipParagraphBreakBefore = false;
        RLine line = this.currentLine;
        int liney = line.y;
        boolean emptyLine = line.isEmpty();
        FloatingBounds floatBounds = this.floatBounds;
        int cleary = floatBounds != null ? floatBounds.getFirstClearY(liney) : liney + line.height;
        int overflowType = floatBounds != null && cleary != liney ? 2 : (allowOverflow ? 0 : 1);
        try {
            line.addWord(renderable, overflowType);
        }
        catch (OverflowException oe) {
            int nextY = emptyLine ? cleary : liney + line.height;
            this.addLine(renderable.getModelNode(), line, nextY);
            Collection renderables = oe.getRenderables();
            Iterator i = renderables.iterator();
            while (i.hasNext()) {
                Renderable r = (Renderable)i.next();
                this.addRenderableToLine(r);
            }
        }
    }

    private void addAsSeqBlockCheckStyle(RElement block, HTMLElementImpl element, boolean usesAlignAttribute) {
        if (this.addElsewhereIfPositioned(block, element, usesAlignAttribute, false, true)) {
            return;
        }
        this.addAsSeqBlock(block);
    }

    private void addAsSeqBlock(BoundableRenderable block) {
        this.addAsSeqBlock(block, true, true);
    }

    private void addAsSeqBlock(BoundableRenderable block, boolean obeysFloats, boolean informLineDone) {
        int leftOffset;
        int blockX;
        int newLineY;
        RLine prevLine;
        Insets insets = this.paddingInsets;
        int insetsl = insets.left;
        ArrayList<BoundableRenderable> sr = this.seqRenderables;
        if (sr == null) {
            this.seqRenderables = sr = new ArrayList<BoundableRenderable>(1);
        }
        if ((prevLine = this.currentLine) != null) {
            if (informLineDone) {
                this.lineDone(prevLine);
            }
            if (prevLine.x + prevLine.width > this.maxX) {
                this.maxX = prevLine.x + prevLine.width;
            }
        }
        int blockY = newLineY = prevLine == null ? insets.top : prevLine.y + prevLine.height;
        int blockWidth = block.getWidth();
        if (obeysFloats) {
            FloatingBounds floatBounds = this.floatBounds;
            if (floatBounds != null) {
                int blockOffset;
                blockX = blockOffset = this.fetchLeftOffset(newLineY);
                int rightOffset = this.fetchRightOffset(newLineY);
                int actualAvailWidth = this.desiredWidth - rightOffset - blockOffset;
                if (blockWidth > actualAvailWidth) {
                    blockY = floatBounds.getClearY(newLineY);
                }
            } else {
                blockX = insetsl;
            }
        } else {
            blockX = insetsl;
        }
        block.setOrigin(blockX, blockY);
        sr.add(block);
        block.setParent(this);
        if (blockX + blockWidth > this.maxX) {
            this.maxX = blockX + blockWidth;
        }
        newLineY = blockY + block.getHeight();
        this.checkY(newLineY);
        int newX = leftOffset = this.fetchLeftOffset(newLineY);
        int newMaxWidth = this.desiredWidth - this.fetchRightOffset(newLineY) - leftOffset;
        ModelNode lineNode = block.getModelNode().getParentModelNode();
        RLine newLine = new RLine(lineNode, this.container, newX, newLineY, newMaxWidth, 0);
        newLine.setParent(this);
        sr.add(newLine);
        this.currentLine = newLine;
        this.skipParagraphBreakBefore = false;
    }

    private void layoutText(NodeImpl textNode) {
        RenderState renderState = textNode.getRenderState();
        if (renderState == null) {
            throw new IllegalStateException("RenderState is null for node " + textNode + " with parent " + textNode.getParentNode());
        }
        FontMetrics fm = renderState.getFontMetrics();
        int descent = fm.getDescent();
        int ascentPlusLeading = fm.getAscent() + fm.getLeading();
        int wordHeight = fm.getHeight();
        int blankWidth = fm.charWidth(' ');
        int whiteSpace = this.overrideNoWrap ? 2 : renderState.getWhiteSpace();
        String text = textNode.getNodeValue();
        if (whiteSpace != 1) {
            boolean allowOverflow = whiteSpace == 2;
            int length = text.length();
            StringBuffer word = new StringBuffer(12);
            block4: for (int i = 0; i < length; ++i) {
                char ch = text.charAt(i);
                if (Character.isWhitespace(ch)) {
                    int wlen = word.length();
                    if (wlen > 0) {
                        RWord rword = new RWord(textNode, word.toString(), this.container, fm, descent, ascentPlusLeading, wordHeight);
                        this.addWordToLine(rword, allowOverflow);
                        word.delete(0, wlen);
                    }
                    RLine line = this.currentLine;
                    if (line.width > 0) {
                        RBlank rblank = new RBlank(textNode, fm, this.container, ascentPlusLeading, blankWidth, wordHeight);
                        line.addBlank(rblank);
                    }
                    ++i;
                    while (i < length) {
                        ch = text.charAt(i);
                        if (!Character.isWhitespace(ch)) {
                            word.append(ch);
                            continue block4;
                        }
                        ++i;
                    }
                    continue;
                }
                word.append(ch);
            }
            if (word.length() > 0) {
                RWord rword = new RWord(textNode, word.toString(), this.container, fm, descent, ascentPlusLeading, wordHeight);
                this.addWordToLine(rword, allowOverflow);
            }
        } else {
            int length = text.length();
            boolean lastCharSlashR = false;
            StringBuffer line = new StringBuffer();
            block6: for (int i = 0; i < length; ++i) {
                char ch = text.charAt(i);
                switch (ch) {
                    case '\r': {
                        lastCharSlashR = true;
                        continue block6;
                    }
                    case '\n': {
                        int llen = line.length();
                        if (llen > 0) {
                            RWord rword = new RWord(textNode, line.toString(), this.container, fm, descent, ascentPlusLeading, wordHeight);
                            this.addWordToLine(rword, true);
                            line.delete(0, line.length());
                        }
                        RLine prevLine = this.currentLine;
                        prevLine.setLineBreak(new LineBreak(0, textNode));
                        this.addLine(textNode, prevLine, prevLine.y + prevLine.height);
                        continue block6;
                    }
                    default: {
                        if (lastCharSlashR) {
                            line.append('\r');
                            lastCharSlashR = false;
                        }
                        line.append(ch);
                    }
                }
            }
            if (line.length() > 0) {
                RWord rword = new RWord(textNode, line.toString(), this.container, fm, descent, ascentPlusLeading, wordHeight);
                this.addWordToLine(rword, true);
            }
        }
    }

    private void populateZIndexGroups(Collection others, Collection seqRenderables, ArrayList destination) {
        this.populateZIndexGroups(others, seqRenderables == null ? null : seqRenderables.iterator(), destination);
    }

    private void populateZIndexGroups(Collection others, Iterator seqRenderablesIterator, ArrayList destination) {
        Iterator i2;
        Iterator i1 = others.iterator();
        BoundableRenderable pending = null;
        while (i1.hasNext()) {
            PositionedRenderable pr = (PositionedRenderable)i1.next();
            BoundableRenderable r = pr.renderable;
            if (r.getZIndex() >= 0) {
                pending = r;
                break;
            }
            destination.add(r);
        }
        if ((i2 = seqRenderablesIterator) != null) {
            while (i2.hasNext()) {
                destination.add(i2.next());
            }
        }
        if (pending != null) {
            destination.add(pending);
            while (i1.hasNext()) {
                PositionedRenderable pr = (PositionedRenderable)i1.next();
                BoundableRenderable r = pr.renderable;
                destination.add(r);
            }
        }
    }

    public Renderable[] getRenderablesArray() {
        int othersSize;
        SortedSet others = this.positionedRenderables;
        int n = othersSize = others == null ? 0 : others.size();
        if (othersSize == 0) {
            ArrayList sr = this.seqRenderables;
            return sr == null ? Renderable.EMPTY_ARRAY : sr.toArray(Renderable.EMPTY_ARRAY);
        }
        ArrayList allRenderables = new ArrayList();
        this.populateZIndexGroups((Collection)others, this.seqRenderables, allRenderables);
        return allRenderables.toArray(Renderable.EMPTY_ARRAY);
    }

    public Iterator getRenderables() {
        SortedSet others = this.positionedRenderables;
        if (others == null || others.size() == 0) {
            ArrayList sr = this.seqRenderables;
            return sr == null ? null : sr.iterator();
        }
        ArrayList allRenderables = new ArrayList();
        this.populateZIndexGroups((Collection)others, this.seqRenderables, allRenderables);
        return allRenderables.iterator();
    }

    public Iterator getRenderables(Rectangle clipBounds) {
        SortedSet others;
        if (!EventQueue.isDispatchThread() && logger.isLoggable(Level.INFO)) {
            logger.warning("getRenderables(): Invoked outside GUI dispatch thread.");
        }
        ArrayList sr = this.seqRenderables;
        Iterator baseIterator = null;
        if (sr != null) {
            Object[] array = sr.toArray(Renderable.EMPTY_ARRAY);
            Range range = MarkupUtilities.findRenderables((Renderable[])array, clipBounds, true);
            baseIterator = ArrayUtilities.iterator(array, range.offset, range.length);
        }
        if ((others = this.positionedRenderables) == null || others.size() == 0) {
            return baseIterator;
        }
        ArrayList<PositionedRenderable> matches = new ArrayList<PositionedRenderable>();
        Iterator i = others.iterator();
        while (i.hasNext()) {
            BoundableRenderable br;
            Rectangle rbounds;
            PositionedRenderable pr = (PositionedRenderable)i.next();
            BoundableRenderable r = pr.renderable;
            if (!(r instanceof BoundableRenderable) || !clipBounds.intersects(rbounds = (br = r).getBounds())) continue;
            matches.add(pr);
        }
        if (matches.size() == 0) {
            return baseIterator;
        }
        ArrayList destination = new ArrayList();
        this.populateZIndexGroups(matches, baseIterator, destination);
        return destination.iterator();
    }

    public BoundableRenderable getRenderable(int x, int y) {
        Iterator i = this.getRenderables(x, y);
        return i == null ? null : (i.hasNext() ? (BoundableRenderable)i.next() : null);
    }

    public BoundableRenderable getRenderable(Point point) {
        return this.getRenderable(point.x, point.y);
    }

    public Iterator getRenderables(Point point) {
        return this.getRenderables(point.x, point.y);
    }

    public Iterator getRenderables(int pointx, int pointy) {
        Renderable[] array;
        BoundableRenderable found;
        ArrayList sr;
        if (!EventQueue.isDispatchThread() && logger.isLoggable(Level.INFO)) {
            logger.warning("getRenderable(): Invoked outside GUI dispatch thread.");
        }
        LinkedList<BoundableRenderable> result = null;
        SortedSet others = this.positionedRenderables;
        int size = others == null ? 0 : others.size();
        PositionedRenderable[] otherArray = size == 0 ? null : others.toArray(PositionedRenderable.EMPTY_ARRAY);
        int index = 0;
        if (size != 0) {
            int px = pointx;
            int py = pointy;
            index = size;
            while (--index >= 0) {
                BoundableRenderable br;
                Rectangle rbounds;
                PositionedRenderable pr = otherArray[index];
                BoundableRenderable r = pr.renderable;
                if (r.getZIndex() < 0) break;
                if (!(r instanceof BoundableRenderable) || !(rbounds = (br = r).getBounds()).contains(px, py)) continue;
                if (result == null) {
                    result = new LinkedList();
                }
                result.add(br);
            }
        }
        if ((sr = this.seqRenderables) != null && (found = MarkupUtilities.findRenderable(array = sr.toArray(Renderable.EMPTY_ARRAY), pointx, pointy, true)) != null) {
            if (result == null) {
                result = new LinkedList<BoundableRenderable>();
            }
            result.add(found);
        }
        if (size != 0) {
            int px = pointx;
            int py = pointy;
            while (index >= 0) {
                BoundableRenderable br;
                Rectangle rbounds;
                PositionedRenderable pr = otherArray[index];
                BoundableRenderable r = pr.renderable;
                if (r instanceof BoundableRenderable && (rbounds = (br = r).getBounds()).contains(px, py)) {
                    if (result == null) {
                        result = new LinkedList();
                    }
                    result.add(br);
                }
                --index;
            }
        }
        return result == null ? null : result.iterator();
    }

    private RElement setupNewUIControl(RenderableContainer container, HTMLElementImpl element, UIControl control) {
        RUIControl renderable = new RUIControl(element, control, container, this.frameContext, this.userAgentContext);
        element.setUINode(renderable);
        return renderable;
    }

    private final void addAlignableAsBlock(HTMLElementImpl markupElement, RElement renderable) {
        boolean regularAdd = false;
        String align = markupElement.getAttribute("align");
        if (align != null) {
            if ("left".equalsIgnoreCase(align)) {
                this.layoutFloat(renderable, false, false, true);
            } else if ("right".equalsIgnoreCase(align)) {
                this.layoutFloat(renderable, false, false, true);
            } else {
                regularAdd = true;
            }
        } else {
            regularAdd = true;
        }
        if (regularAdd) {
            this.addAsSeqBlock(renderable);
        }
    }

    private final void layoutHr(HTMLElementImpl markupElement) {
        RElement renderable = (RElement)markupElement.getUINode();
        if (renderable == null) {
            renderable = this.setupNewUIControl(this.container, markupElement, new HrControl(markupElement));
        }
        renderable.layout(this.availContentWidth, this.availContentHeight);
        this.addAlignableAsBlock(markupElement, renderable);
    }

    private final BaseInputControl createInputControl(HTMLBaseInputElement markupElement) {
        String type = markupElement.getAttribute("type");
        if (type == null) {
            return new InputTextControl(markupElement);
        }
        if ("text".equals(type = type.toLowerCase()) || type.length() == 0) {
            return new InputTextControl(markupElement);
        }
        if ("hidden".equals(type)) {
            return null;
        }
        if ("submit".equals(type)) {
            return new InputButtonControl(markupElement);
        }
        if ("password".equals(type)) {
            return new InputPasswordControl(markupElement);
        }
        if ("radio".equals(type)) {
            return new InputRadioControl(markupElement);
        }
        if ("checkbox".equals(type)) {
            return new InputCheckboxControl(markupElement);
        }
        if ("image".equals(type)) {
            return new InputImageControl(markupElement);
        }
        if ("reset".equals(type)) {
            return new InputButtonControl(markupElement);
        }
        if ("button".equals(type)) {
            return new InputButtonControl(markupElement);
        }
        if ("file".equals(type)) {
            return new InputFileControl(markupElement);
        }
        return null;
    }

    private final int fetchLeftOffset(int newLineY) {
        Insets paddingInsets = this.paddingInsets;
        FloatingBounds floatBounds = this.floatBounds;
        if (floatBounds == null) {
            return paddingInsets.left;
        }
        int left = floatBounds.getLeft(newLineY);
        if (left < paddingInsets.left) {
            return paddingInsets.left;
        }
        return left;
    }

    private final int fetchRightOffset(int newLineY) {
        Insets paddingInsets = this.paddingInsets;
        FloatingBounds floatBounds = this.floatBounds;
        if (floatBounds == null) {
            return paddingInsets.right;
        }
        int right = floatBounds.getRight(newLineY);
        if (right < paddingInsets.right) {
            return paddingInsets.right;
        }
        return right;
    }

    private final void checkY(int y) {
        if (this.yLimit != -1 && y > this.yLimit) {
            throw SEE;
        }
    }

    private final void layoutFloat(BoundableRenderable renderable, boolean layout, boolean adjust, boolean leftFloat) {
        renderable.setOriginalParent(this);
        if (layout) {
            int availWidth = this.availContentWidth;
            int availHeight = this.availContentHeight;
            if (renderable instanceof RElement) {
                RElement e = (RElement)renderable;
                e.layout(availWidth, availHeight);
            }
        }
        if (adjust && renderable instanceof RBlock) {
            ((RBlock)renderable).adjust();
        }
        RFloatInfo floatInfo = new RFloatInfo(renderable.getModelNode(), renderable, leftFloat, false);
        this.currentLine.simplyAdd(floatInfo);
        this.scheduleFloat(floatInfo);
    }

    private void scheduleAbsDelayedPair(BoundableRenderable renderable, int x, int y) {
        RenderableContainer newContainer;
        HTMLElementImpl element;
        int position;
        ModelNode node;
        RenderableContainer container = this.container;
        while (container instanceof Renderable && (node = ((Renderable)((Object)container)).getModelNode()) instanceof HTMLElementImpl && (position = RBlockViewport.getPosition(element = (HTMLElementImpl)node)) == 0 && (newContainer = container.getParentContainer()) != null) {
            container = newContainer;
        }
        DelayedPair pair = new DelayedPair(container, renderable, x, y);
        this.container.addDelayedPair(pair);
    }

    void importDelayedPair(DelayedPair pair) {
        BoundableRenderable r = pair.child;
        r.setOrigin(pair.x, pair.y);
        this.addPositionedRenderable(r, false);
    }

    private final void addPositionedRenderable(BoundableRenderable renderable, boolean verticalAlignable) {
        TreeSet<PositionedRenderable> others = this.positionedRenderables;
        if (others == null) {
            this.positionedRenderables = others = new TreeSet<PositionedRenderable>(new ZIndexComparator());
        }
        others.add(new PositionedRenderable(renderable, verticalAlignable, this.positionedOrdinal++));
        renderable.setParent(this);
        if (renderable instanceof RUIControl) {
            this.container.addComponent(((RUIControl)renderable).widget.getComponent());
        }
    }

    public int getFirstLineHeight() {
        ArrayList renderables = this.seqRenderables;
        if (renderables != null) {
            int size = renderables.size();
            if (size == 0) {
                return 0;
            }
            for (int i = 0; i < size; ++i) {
                BoundableRenderable br = (BoundableRenderable)renderables.get(0);
                int height = br.getHeight();
                if (height == 0) continue;
                return height;
            }
        }
        return 1;
    }

    public int getFirstBaselineOffset() {
        ArrayList renderables = this.seqRenderables;
        if (renderables != null) {
            Iterator i = renderables.iterator();
            while (i.hasNext()) {
                RBlock block;
                Object r = i.next();
                if (r instanceof RLine) {
                    int blo = ((RLine)r).getBaselineOffset();
                    if (blo == 0) continue;
                    return blo;
                }
                if (!(r instanceof RBlock) || (block = (RBlock)r).getHeight() <= 0) continue;
                Insets insets = block.getInsets(false, false);
                Insets paddingInsets = block.getPaddingInsets(block.getModelNode().getRenderState());
                return block.getFirstBaselineOffset() + insets.top + (paddingInsets == null ? 0 : paddingInsets.top);
            }
        }
        return 0;
    }

    public RenderableSpot getLowestRenderableSpot(int x, int y) {
        BoundableRenderable br = this.getRenderable(new Point(x, y));
        if (br != null) {
            return br.getLowestRenderableSpot(x - br.getX(), y - br.getY());
        }
        return new RenderableSpot(this, x, y);
    }

    public boolean onMouseClick(MouseEvent event, int x, int y) {
        Iterator i = this.getRenderables(new Point(x, y));
        if (i != null) {
            while (i.hasNext()) {
                BoundableRenderable br = (BoundableRenderable)i.next();
                if (br == null) continue;
                Rectangle bounds = br.getBounds();
                if (br.onMouseClick(event, x - bounds.x, y - bounds.y)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean onDoubleClick(MouseEvent event, int x, int y) {
        Iterator i = this.getRenderables(new Point(x, y));
        if (i != null) {
            while (i.hasNext()) {
                BoundableRenderable br = (BoundableRenderable)i.next();
                if (br == null) continue;
                Rectangle bounds = br.getBounds();
                if (br.onDoubleClick(event, x - bounds.x, y - bounds.y)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onMouseDisarmed(MouseEvent event) {
        BoundableRenderable br = this.armedRenderable;
        if (br != null) {
            try {
                boolean bl = br.onMouseDisarmed(event);
                return bl;
            }
            finally {
                this.armedRenderable = null;
            }
        }
        return true;
    }

    public boolean onMousePressed(MouseEvent event, int x, int y) {
        Iterator i = this.getRenderables(new Point(x, y));
        if (i != null) {
            while (i.hasNext()) {
                BoundableRenderable br = (BoundableRenderable)i.next();
                if (br == null) continue;
                Rectangle bounds = br.getBounds();
                if (br.onMousePressed(event, x - bounds.x, y - bounds.y)) continue;
                this.armedRenderable = br;
                return false;
            }
        }
        return true;
    }

    public boolean onMouseReleased(MouseEvent event, int x, int y) {
        BoundableRenderable oldArmedRenderable;
        Iterator i = this.getRenderables(new Point(x, y));
        if (i != null) {
            while (i.hasNext()) {
                BoundableRenderable br = (BoundableRenderable)i.next();
                if (br == null) continue;
                Rectangle bounds = br.getBounds();
                if (br.onMouseReleased(event, x - bounds.x, y - bounds.y)) continue;
                BoundableRenderable oldArmedRenderable2 = this.armedRenderable;
                if (oldArmedRenderable2 != null && br != oldArmedRenderable2) {
                    oldArmedRenderable2.onMouseDisarmed(event);
                    this.armedRenderable = null;
                }
                return false;
            }
        }
        if ((oldArmedRenderable = this.armedRenderable) != null) {
            oldArmedRenderable.onMouseDisarmed(event);
            this.armedRenderable = null;
        }
        return true;
    }

    public void paint(Graphics g) {
        Rectangle clipBounds = g.getClipBounds();
        Iterator i = this.getRenderables(clipBounds);
        if (i != null) {
            int renderableCount = 0;
            while (i.hasNext()) {
                ++renderableCount;
                Object robj = i.next();
                if (robj instanceof BoundableRenderable) {
                    BoundableRenderable renderable = (BoundableRenderable)robj;
                    renderable.paintTranslated(g);
                    continue;
                }
                ((Renderable)robj).paint(g);
            }
        }
    }

    public boolean isContainedByNode() {
        return false;
    }

    public String toString() {
        return "RBlockViewport[node=" + this.modelNode + "]";
    }

    public void adjust(int desiredWidth, int desiredHeight, Insets paddingInsets, FloatingBounds floatBounds) {
        SortedSet posRenderables;
        int availh;
        this.paddingInsets = paddingInsets;
        this.desiredHeight = desiredHeight;
        this.desiredWidth = desiredWidth;
        this.floatBounds = floatBounds;
        int availw = desiredWidth - paddingInsets.left - paddingInsets.right;
        if (availw < 0) {
            availw = 0;
        }
        if ((availh = desiredHeight - paddingInsets.top - paddingInsets.bottom) < 0) {
            availh = 0;
        }
        this.availContentWidth = availw;
        this.availContentHeight = availh;
        this.maxX = paddingInsets.left;
        this.maxY = paddingInsets.top;
        ArrayList oldSeqRenderables = this.seqRenderables;
        this.seqRenderables = null;
        this.currentLine = null;
        if (oldSeqRenderables != null) {
            Iterator i = oldSeqRenderables.iterator();
            while (i.hasNext()) {
                Renderable r = (Renderable)i.next();
                this.reprocessSeqRenderable(r);
            }
        }
        RLine lastLine = this.currentLine;
        this.lineDone(this.currentLine);
        if (lastLine != null) {
            int maxY;
            int lastTopY;
            Rectangle lastBounds = lastLine.getBounds();
            int lastTopX = lastBounds.x + lastBounds.width;
            if (lastTopX > this.maxX) {
                this.maxX = lastTopX;
            }
            if ((lastTopY = lastBounds.y + lastBounds.height) > (maxY = this.maxY)) {
                this.maxY = maxY = lastTopY;
            }
        }
        if ((posRenderables = this.positionedRenderables) != null) {
            Iterator i = posRenderables.iterator();
            while (i.hasNext()) {
                PositionedRenderable pr = (PositionedRenderable)i.next();
                BoundableRenderable br = pr.renderable;
                if (br.getX() + br.getWidth() > this.maxX) {
                    this.maxX = br.getX() + br.getWidth();
                }
                if (br.getY() + br.getHeight() <= this.maxY) continue;
                this.maxY = br.getY() + br.getHeight();
            }
        }
        this.width = paddingInsets.right + this.maxX;
        this.height = paddingInsets.bottom + this.maxY;
    }

    private void reprocessSeqRenderable(Renderable r) {
        if (r instanceof RLine) {
            this.reprocessLine((RLine)r);
        } else if (r instanceof RElement) {
            this.reprocessElement((RElement)r);
        } else if (r instanceof RRelative) {
            this.reprocessRelative((RRelative)r);
        } else {
            throw new IllegalStateException("Unexpected Renderable: " + r);
        }
    }

    private void reprocessLine(RLine line) {
        LineBreak br;
        Iterator renderables = line.getRenderables();
        if (renderables != null) {
            while (renderables.hasNext()) {
                Renderable r = (Renderable)renderables.next();
                if (r instanceof RWord) {
                    boolean allowOverflow;
                    RWord word = (RWord)r;
                    RenderState rs = word.getModelNode().getRenderState();
                    int whiteSpace = rs.getWhiteSpace();
                    boolean bl = allowOverflow = whiteSpace == 2 || whiteSpace == 1;
                    if (this.currentLine == null) {
                        this.currentLine = this.addLine(word.getModelNode(), null, this.paddingInsets.top);
                    }
                    this.addWordToLine(word, allowOverflow);
                    continue;
                }
                if (r instanceof RFloatInfo) {
                    RFloatInfo oldr = (RFloatInfo)r;
                    this.scheduleFloat(new RFloatInfo(oldr.getModelNode(), oldr.getRenderable(), oldr.isLeftFloat(), true));
                    continue;
                }
                if (this.currentLine == null) {
                    this.currentLine = this.addLine(r.getModelNode(), null, this.paddingInsets.top);
                }
                this.addRenderableToLine(r);
            }
        }
        if ((br = line.getLineBreak()) != null) {
            this.addLineBreak(br.getModelNode(), br.getBreakType());
        }
    }

    private void reprocessElement(RElement element) {
        boolean obeysFloats;
        RLine line = this.currentLine;
        this.lineDone(line);
        boolean isRBlock = element instanceof RBlock;
        boolean bl = obeysFloats = !isRBlock || !((RBlock)element).isOverflowVisible();
        if (obeysFloats) {
            if (isRBlock) {
                RBlock block = (RBlock)element;
                int newLineY = line == null ? this.paddingInsets.top : line.y + line.height;
                int leftOffset = this.fetchLeftOffset(newLineY);
                int rightOffset = this.fetchRightOffset(newLineY);
                int availContentWidth = this.desiredWidth - leftOffset - rightOffset;
                block.adjust(availContentWidth, this.availContentHeight, true, false, null);
            }
        } else {
            FloatingBounds prevBounds;
            FloatingBounds newBounds;
            RBlock block = (RBlock)element;
            final FloatingBounds currentFloatBounds = this.floatBounds;
            FloatingBoundsSource blockFloatBoundsSource = null;
            if (currentFloatBounds != null) {
                Insets paddingInsets = this.paddingInsets;
                final int blockShiftX = paddingInsets.left;
                final int blockShiftRight = paddingInsets.right;
                final int blockShiftY = line == null ? paddingInsets.top : line.y + line.height;
                final int expectedBlockWidth = this.availContentWidth;
                blockFloatBoundsSource = new FloatingBoundsSource(){

                    public FloatingBounds getChildBlockFloatingBounds(int apparentBlockWidth) {
                        int actualRightShift = blockShiftRight + (expectedBlockWidth - apparentBlockWidth);
                        return new ShiftedFloatingBounds(currentFloatBounds, -blockShiftX, -actualRightShift, -blockShiftY);
                    }
                };
            }
            block.adjust(this.availContentWidth, this.availContentHeight, true, false, blockFloatBoundsSource);
            FloatingBounds blockBounds = block.getExportableFloatingBounds();
            if (blockBounds != null && (newBounds = (prevBounds = this.floatBounds) == null ? blockBounds : new CombinedFloatingBounds(prevBounds, blockBounds)).getMaxY() > this.maxY && this.isFloatLimit()) {
                this.maxY = newBounds.getMaxY();
            }
        }
        this.addAsSeqBlock(element, obeysFloats, false);
    }

    private void reprocessRelative(RRelative relative) {
        RLine line = this.currentLine;
        this.lineDone(line);
        boolean obeysFloats = false;
        RElement element = relative.getElement();
        if (element instanceof RBlock) {
            FloatingBounds prevBounds;
            FloatingBounds newBounds;
            obeysFloats = false;
            RBlock block = (RBlock)element;
            final FloatingBounds currentFloatBounds = this.floatBounds;
            FloatingBoundsSource blockFloatBoundsSource = null;
            if (currentFloatBounds != null) {
                Insets paddingInsets = this.paddingInsets;
                final int blockShiftX = paddingInsets.left + relative.getXOffset();
                final int blockShiftRight = paddingInsets.right - relative.getXOffset();
                final int blockShiftY = (line == null ? paddingInsets.top : line.y + line.height) + relative.getYOffset();
                final int expectedBlockWidth = this.availContentWidth;
                blockFloatBoundsSource = new FloatingBoundsSource(){

                    public FloatingBounds getChildBlockFloatingBounds(int apparentBlockWidth) {
                        int actualRightShift = blockShiftRight + (expectedBlockWidth - apparentBlockWidth);
                        return new ShiftedFloatingBounds(currentFloatBounds, -blockShiftX, -actualRightShift, -blockShiftY);
                    }
                };
            }
            block.adjust(this.availContentWidth, this.availContentHeight, true, false, blockFloatBoundsSource);
            relative.adjustSize();
            FloatingBounds blockBounds = relative.getExportableFloatingBounds();
            if (blockBounds != null && (newBounds = (prevBounds = this.floatBounds) == null ? blockBounds : new CombinedFloatingBounds(prevBounds, blockBounds)).getMaxY() > this.maxY && this.isFloatLimit()) {
                this.maxY = newBounds.getMaxY();
            }
        } else {
            obeysFloats = true;
        }
        this.addAsSeqBlock(relative, obeysFloats, false);
    }

    private void scheduleFloat(RFloatInfo floatInfo) {
        RLine line = this.currentLine;
        if (line == null) {
            int y = line == null ? this.paddingInsets.top : line.getY();
            this.placeFloat(floatInfo.getRenderable(), y, floatInfo.isLeftFloat(), floatInfo.isRegisterElement());
        } else if (line.getWidth() == 0) {
            int y = line.getY();
            this.placeFloat(floatInfo.getRenderable(), y, floatInfo.isLeftFloat(), floatInfo.isRegisterElement());
            int leftOffset = this.fetchLeftOffset(y);
            int rightOffset = this.fetchRightOffset(y);
            line.changeLimits(leftOffset, this.desiredWidth - leftOffset - rightOffset);
        } else {
            LinkedList<RFloatInfo> c = this.pendingFloats;
            if (c == null) {
                this.pendingFloats = c = new LinkedList<RFloatInfo>();
            }
            c.add(floatInfo);
        }
    }

    private void lineDone(RLine line) {
        int yAfterLine = line == null ? this.paddingInsets.top : line.y + line.height;
        Collection pfs = this.pendingFloats;
        if (pfs != null) {
            this.pendingFloats = null;
            Iterator i = pfs.iterator();
            while (i.hasNext()) {
                RFloatInfo pf = (RFloatInfo)i.next();
                this.placeFloat(pf.getRenderable(), yAfterLine, pf.isLeftFloat(), pf.isRegisterElement());
            }
        }
    }

    private void placeFloat(BoundableRenderable element, int y, boolean leftFloat, boolean registerElement) {
        int boxX;
        Insets insets = this.paddingInsets;
        int boxY = y;
        int boxWidth = element.getWidth();
        int boxHeight = element.getHeight();
        int desiredWidth = this.desiredWidth;
        while (true) {
            int newY;
            int leftOffset = this.fetchLeftOffset(boxY);
            int rightOffset = this.fetchRightOffset(boxY);
            int n = boxX = leftFloat ? leftOffset : desiredWidth - rightOffset - boxWidth;
            if (leftOffset == insets.left && rightOffset == insets.right || leftFloat && boxX + boxWidth <= desiredWidth - rightOffset || !leftFloat && boxX >= leftOffset) break;
            FloatingBounds fb = this.floatBounds;
            int n2 = newY = fb == null ? boxY + boxHeight : fb.getFirstClearY(boxY);
            if (newY == boxY) break;
            boxY = newY;
        }
        element.setOrigin(boxX, boxY);
        int offsetFromBorder = leftFloat ? boxX + boxWidth : desiredWidth - boxX;
        this.floatBounds = new FloatingViewportBounds(this.floatBounds, leftFloat, boxY, offsetFromBorder, boxHeight);
        if (registerElement) {
            this.addPositionedRenderable(element, true);
        }
        if (boxX + boxWidth > this.maxX) {
            this.maxX = boxX + boxWidth;
        }
        if (this.isFloatLimit() && boxY + boxHeight > this.maxY) {
            this.maxY = boxY + boxHeight;
        }
    }

    private boolean isFloatLimit() {
        Boolean fl = this.isFloatLimit;
        if (fl == null) {
            this.isFloatLimit = fl = this.isFloatLimitImpl();
        }
        return fl;
    }

    private Boolean isFloatLimitImpl() {
        int floatValue;
        RCollection parent = this.getOriginalOrCurrentParent();
        if (!(parent instanceof RBlock)) {
            return Boolean.TRUE;
        }
        RBlock blockParent = (RBlock)parent;
        RCollection grandParent = blockParent.getOriginalOrCurrentParent();
        if (!(grandParent instanceof RBlockViewport)) {
            return Boolean.TRUE;
        }
        ModelNode node = this.modelNode;
        if (!(node instanceof HTMLElementImpl)) {
            return Boolean.TRUE;
        }
        HTMLElementImpl element = (HTMLElementImpl)node;
        int position = RBlockViewport.getPosition(element);
        if (position == 1 || position == 3) {
            return Boolean.TRUE;
        }
        AbstractCSS2Properties props = element.getCurrentStyle();
        RenderState rs = element.getRenderState();
        int n = floatValue = rs == null ? 0 : rs.getFloat();
        if (floatValue != 0) {
            return Boolean.TRUE;
        }
        String overflow = props.getOverflow();
        if (overflow != null && !"visible".equalsIgnoreCase(overflow)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public FloatingBounds getExportableFloatingBounds() {
        FloatingBounds floatBounds = this.floatBounds;
        if (floatBounds == null) {
            return null;
        }
        if (this.isFloatLimit()) {
            return null;
        }
        int maxY = floatBounds.getMaxY();
        if (maxY > this.height) {
            return floatBounds;
        }
        return null;
    }

    static {
        Map el = elementLayout;
        EmLayout em = new EmLayout();
        el.put("I", em);
        el.put("EM", em);
        el.put("CITE", em);
        el.put("H1", new HLayout(24));
        el.put("H2", new HLayout(18));
        el.put("H3", new HLayout(15));
        el.put("H4", new HLayout(12));
        el.put("H5", new HLayout(10));
        el.put("H6", new HLayout(8));
        StrongLayout strong = new StrongLayout();
        el.put("B", strong);
        el.put("STRONG", strong);
        el.put("TH", strong);
        el.put("U", new ULayout());
        el.put("STRIKE", new StrikeLayout());
        el.put("BR", new BrLayout());
        el.put("P", new PLayout());
        el.put("NOSCRIPT", new NoScriptLayout());
        NopLayout nop = new NopLayout();
        el.put("SCRIPT", nop);
        el.put("HEAD", nop);
        el.put("TITLE", nop);
        el.put("META", nop);
        el.put("STYLE", nop);
        el.put("LINK", nop);
        el.put("IMG", new ImgLayout());
        el.put("TABLE", new TableLayout());
        ChildrenLayout children = new ChildrenLayout();
        el.put("HTML", children);
        AnchorLayout anchor = new AnchorLayout();
        el.put("A", anchor);
        el.put("ANCHOR", anchor);
        el.put("INPUT", new InputLayout2());
        el.put("TEXTAREA", new TextAreaLayout2());
        el.put("SELECT", new SelectLayout());
        ListItemLayout list = new ListItemLayout();
        el.put("UL", list);
        el.put("OL", list);
        el.put("LI", list);
        CommonBlockLayout cbl = new CommonBlockLayout();
        el.put("PRE", cbl);
        el.put("CENTER", cbl);
        el.put("CAPTION", cbl);
        DivLayout div = new DivLayout();
        el.put("DIV", div);
        el.put("BODY", div);
        el.put("DL", div);
        el.put("DT", div);
        BlockQuoteLayout bq = new BlockQuoteLayout();
        el.put("BLOCKQUOTE", bq);
        el.put("DD", bq);
        el.put("HR", new HrLayout());
        el.put("SPAN", new SpanLayout());
        ObjectLayout ol = new ObjectLayout(false, true);
        el.put("OBJECT", new ObjectLayout(true, true));
        el.put("APPLET", ol);
        el.put("EMBED", ol);
        el.put("IFRAME", new IFrameLayout());
        SEE = new SizeExceededException();
    }

    private static abstract class CommonLayout
    implements MarkupLayout {
        protected static final int DISPLAY_NONE = 0;
        protected static final int DISPLAY_INLINE = 1;
        protected static final int DISPLAY_BLOCK = 2;
        protected static final int DISPLAY_LIST_ITEM = 3;
        protected static final int DISPLAY_TABLE_ROW = 4;
        protected static final int DISPLAY_TABLE_CELL = 5;
        protected static final int DISPLAY_TABLE = 6;
        private final int display;

        public CommonLayout(int defaultDisplay) {
            this.display = defaultDisplay;
        }

        public Insets getDefaultMarginInsets() {
            return null;
        }

        public void layoutMarkup(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            int display;
            RenderState rs = markupElement.getRenderState();
            int n = display = rs == null ? this.display : rs.getDisplay();
            if (display == 1) {
                int position;
                int n2 = position = rs == null ? 0 : rs.getPosition();
                if (position == 1 || position == 3) {
                    display = 2;
                } else {
                    int boxFloat;
                    int n3 = boxFloat = rs == null ? 0 : rs.getFloat();
                    if (boxFloat != 0) {
                        display = 2;
                    }
                }
            }
            switch (display) {
                case 0: {
                    UINode node = markupElement.getUINode();
                    if (!(node instanceof BaseBoundableRenderable)) break;
                    ((BaseBoundableRenderable)((Object)node)).markLayoutValid();
                    break;
                }
                case 2: {
                    bodyLayout.layoutRBlock(markupElement, this.getDefaultMarginInsets());
                    break;
                }
                case 3: {
                    String tagName = markupElement.getTagName();
                    if ("UL".equalsIgnoreCase(tagName) || "OL".equalsIgnoreCase(tagName)) {
                        bodyLayout.layoutList(markupElement);
                        break;
                    }
                    bodyLayout.layoutListItem(markupElement);
                    break;
                }
                case 6: {
                    bodyLayout.layoutRTable(markupElement);
                    break;
                }
                default: {
                    bodyLayout.layoutMarkup(markupElement);
                }
            }
        }
    }

    private static abstract class CommonWidgetLayout
    implements MarkupLayout {
        protected static final int ADD_INLINE = 0;
        protected static final int ADD_AS_BLOCK = 1;
        private final int method;
        private final boolean useAlignAttribute;

        public CommonWidgetLayout(int method, boolean usesAlignAttribute) {
            this.method = method;
            this.useAlignAttribute = usesAlignAttribute;
        }

        public void layoutMarkup(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            String display;
            AbstractCSS2Properties style = markupElement.getCurrentStyle();
            if (style != null && (display = style.getDisplay()) != null && "none".equalsIgnoreCase(display)) {
                return;
            }
            UINode node = markupElement.getUINode();
            RElement renderable = null;
            if (node == null) {
                renderable = this.createRenderable(bodyLayout, markupElement);
                if (renderable == null) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("layoutMarkup(): Don't know how to render " + markupElement + ".");
                    }
                    return;
                }
                markupElement.setUINode(renderable);
            } else {
                renderable = (RElement)node;
            }
            int availWidth = bodyLayout.availContentWidth;
            int heightAvailToRenderable = bodyLayout.availContentHeight;
            renderable.layout(availWidth, heightAvailToRenderable);
            switch (this.method) {
                case 0: {
                    bodyLayout.addRenderableToLineCheckStyle(renderable, markupElement, this.useAlignAttribute);
                    break;
                }
                case 1: {
                    bodyLayout.addAsSeqBlockCheckStyle(renderable, markupElement, this.useAlignAttribute);
                }
            }
        }

        protected abstract RElement createRenderable(RBlockViewport var1, HTMLElementImpl var2);
    }

    private static class IFrameLayout
    extends CommonWidgetLayout {
        public IFrameLayout() {
            super(0, true);
        }

        protected RElement createRenderable(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            BrowserFrame frame = bodyLayout.rendererContext.createBrowserFrame();
            ((HTMLIFrameElementImpl)markupElement).setBrowserFrame(frame);
            BrowserFrameUIControl control = new BrowserFrameUIControl(markupElement, frame);
            return new RUIControl(markupElement, control, bodyLayout.container, bodyLayout.frameContext, bodyLayout.userAgentContext);
        }
    }

    private static class TextAreaLayout2
    extends CommonWidgetLayout {
        public TextAreaLayout2() {
            super(0, true);
        }

        protected RElement createRenderable(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            HTMLBaseInputElement bie = (HTMLBaseInputElement)markupElement;
            InputTextAreaControl control = new InputTextAreaControl(bie);
            bie.setInputContext(control);
            return new RUIControl(markupElement, control, bodyLayout.container, bodyLayout.frameContext, bodyLayout.userAgentContext);
        }
    }

    private static class SelectLayout
    extends CommonWidgetLayout {
        public SelectLayout() {
            super(0, true);
        }

        protected RElement createRenderable(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            HTMLBaseInputElement bie = (HTMLBaseInputElement)markupElement;
            InputSelectControl uiControl = new InputSelectControl(bie);
            bie.setInputContext(uiControl);
            return new RUIControl(markupElement, uiControl, bodyLayout.container, bodyLayout.frameContext, bodyLayout.userAgentContext);
        }
    }

    private static class InputLayout2
    extends CommonWidgetLayout {
        public InputLayout2() {
            super(0, true);
        }

        protected RElement createRenderable(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            HTMLBaseInputElement bie = (HTMLBaseInputElement)markupElement;
            BaseInputControl uiControl = bodyLayout.createInputControl(bie);
            if (uiControl == null) {
                return null;
            }
            bie.setInputContext(uiControl);
            return new RUIControl(markupElement, uiControl, bodyLayout.container, bodyLayout.frameContext, bodyLayout.userAgentContext);
        }
    }

    private static class ImgLayout
    extends CommonWidgetLayout {
        public ImgLayout() {
            super(0, true);
        }

        protected RElement createRenderable(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            ImgControl control = new ImgControl((HTMLImageElementImpl)markupElement);
            return new RImgControl(markupElement, control, bodyLayout.container, bodyLayout.frameContext, bodyLayout.userAgentContext);
        }
    }

    private static class ObjectLayout
    extends CommonWidgetLayout {
        private boolean tryToRenderContent;
        private final ThreadLocal htmlObject = new ThreadLocal();

        public ObjectLayout(boolean tryToRenderContent, boolean usesAlignAttribute) {
            super(0, usesAlignAttribute);
            this.tryToRenderContent = tryToRenderContent;
        }

        public void layoutMarkup(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            HtmlObject ho = bodyLayout.rendererContext.getHtmlObject(markupElement);
            if (ho == null && this.tryToRenderContent) {
                bodyLayout.layoutMarkup(markupElement);
            } else if (ho != null) {
                this.htmlObject.set(ho);
                super.layoutMarkup(bodyLayout, markupElement);
            }
        }

        protected RElement createRenderable(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            HtmlObject ho = (HtmlObject)this.htmlObject.get();
            UIControlWrapper uiControl = new UIControlWrapper(ho);
            RUIControl ruiControl = new RUIControl(markupElement, uiControl, bodyLayout.container, bodyLayout.frameContext, bodyLayout.userAgentContext);
            return ruiControl;
        }
    }

    private static class AnchorLayout
    extends CommonLayout {
        public AnchorLayout() {
            super(1);
        }
    }

    private static class StrongLayout
    extends CommonLayout {
        public StrongLayout() {
            super(1);
        }
    }

    private static class StrikeLayout
    extends CommonLayout {
        public StrikeLayout() {
            super(1);
        }
    }

    private static class ULayout
    extends CommonLayout {
        public ULayout() {
            super(1);
        }

        public void layoutMarkup(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            super.layoutMarkup(bodyLayout, markupElement);
        }
    }

    private static class EmLayout
    extends CommonLayout {
        public EmLayout() {
            super(1);
        }

        public void layoutMarkup(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            super.layoutMarkup(bodyLayout, markupElement);
        }
    }

    private static class SpanLayout
    extends CommonLayout {
        public SpanLayout() {
            super(1);
        }
    }

    private static class BlockQuoteLayout
    extends CommonLayout {
        public Insets getDefaultMarginInsets() {
            return new Insets(0, 36, 0, 0);
        }

        public BlockQuoteLayout() {
            super(2);
        }
    }

    private static class DivLayout
    extends CommonLayout {
        public DivLayout() {
            super(2);
        }
    }

    private static class CommonBlockLayout
    extends CommonLayout {
        public CommonBlockLayout() {
            super(2);
        }
    }

    private static class TableLayout
    extends CommonLayout {
        public TableLayout() {
            super(6);
        }
    }

    private static class HrLayout
    implements MarkupLayout {
        private HrLayout() {
        }

        public void layoutMarkup(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            bodyLayout.layoutHr(markupElement);
        }
    }

    private static class BrLayout
    implements MarkupLayout {
        private BrLayout() {
        }

        public void layoutMarkup(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            String clear = markupElement.getAttribute("clear");
            bodyLayout.addLineBreak(markupElement, LineBreak.getBreakType(clear));
        }
    }

    private static class ListItemLayout
    extends CommonLayout {
        public ListItemLayout() {
            super(3);
        }
    }

    private static class PLayout
    extends CommonLayout {
        public PLayout() {
            super(2);
        }

        public void layoutMarkup(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            if (!bodyLayout.skipParagraphBreakBefore) {
                RLine currentLine = bodyLayout.currentLine;
                if (currentLine.width == 0) {
                    bodyLayout.addLineBreak(markupElement, 0);
                } else {
                    bodyLayout.addParagraphBreak(markupElement);
                }
                bodyLayout.skipParagraphBreakBefore = true;
            }
            super.layoutMarkup(bodyLayout, markupElement);
            if (markupElement.hasChildNodes()) {
                bodyLayout.addLineBreak(markupElement, 0);
                bodyLayout.skipParagraphBreakBefore = true;
            }
        }
    }

    private static class HLayout
    extends CommonLayout {
        public HLayout(int fontSize) {
            super(2);
        }

        public void layoutMarkup(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            if (!bodyLayout.skipParagraphBreakBefore) {
                RLine currentLine = bodyLayout.currentLine;
                if (currentLine.width == 0) {
                    bodyLayout.addLineBreak(markupElement, 0);
                } else {
                    bodyLayout.addParagraphBreak(markupElement);
                }
                bodyLayout.skipParagraphBreakBefore = true;
            }
            super.layoutMarkup(bodyLayout, markupElement);
            if (markupElement.hasChildNodes()) {
                bodyLayout.addLineBreak(markupElement, 0);
                bodyLayout.skipParagraphBreakBefore = true;
            }
        }
    }

    private static class MiscLayout
    extends CommonLayout {
        public MiscLayout() {
            super(1);
        }
    }

    private static class ChildrenLayout
    implements MarkupLayout {
        private ChildrenLayout() {
        }

        public void layoutMarkup(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            bodyLayout.layoutChildren(markupElement);
        }
    }

    private static class NoScriptLayout
    implements MarkupLayout {
        private NoScriptLayout() {
        }

        public void layoutMarkup(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            UserAgentContext ucontext = bodyLayout.userAgentContext;
            if (!ucontext.isScriptingEnabled()) {
                bodyLayout.layoutMarkup(markupElement);
            }
        }
    }

    private static class NopLayout
    implements MarkupLayout {
        private NopLayout() {
        }

        public void layoutMarkup(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
        }
    }
}

