/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.style.BlockRenderState;
import org.lobobrowser.html.style.FontSizeRenderState;
import org.lobobrowser.html.style.RenderState;
import org.w3c.dom.html2.HTMLHeadingElement;

public class HTMLHeadingElementImpl
extends HTMLAbstractUIElement
implements HTMLHeadingElement {
    public HTMLHeadingElementImpl(String name) {
        super(name);
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    private final float getHeadingFontSize() {
        String tagName = this.getTagName();
        try {
            int lastCharValue = tagName.charAt(1) - 48;
            switch (lastCharValue) {
                case 1: {
                    return 24.0f;
                }
                case 2: {
                    return 18.0f;
                }
                case 3: {
                    return 15.0f;
                }
                case 4: {
                    return 12.0f;
                }
                case 5: {
                    return 10.0f;
                }
                case 6: {
                    return 8.0f;
                }
            }
        }
        catch (Exception thrown) {
            this.warn("getHeadingFontSize(): Bad heading tag: " + this.getTagName(), thrown);
        }
        return 14.0f;
    }

    protected RenderState createRenderState(RenderState prevRenderState) {
        float fontSize = this.getHeadingFontSize();
        prevRenderState = new FontSizeRenderState(prevRenderState, fontSize, 1);
        return new BlockRenderState(prevRenderState, this);
    }
}

