/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.LfuPolicy;
import net.sf.ehcache.store.Store;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiskStore
implements Store {
    public static final String AUTO_DISK_PATH_DIRECTORY_PREFIX = "ehcache_auto_created";
    private static final Log LOG = LogFactory.getLog(DiskStore.class.getName());
    private static final int MS_PER_SECOND = 1000;
    private static final int SPOOL_THREAD_INTERVAL = 200;
    private static final int ESTIMATED_MINIMUM_PAYLOAD_SIZE = 512;
    private static final int ONE_MEGABYTE = 0x100000;
    private long expiryThreadInterval;
    private final String name;
    private boolean active;
    private RandomAccessFile randomAccessFile;
    private Map diskElements = Collections.synchronizedMap(new HashMap());
    private List freeSpace = Collections.synchronizedList(new ArrayList());
    private Map spool = new HashMap();
    private Object spoolLock = new Object();
    private Thread spoolAndExpiryThread;
    private Ehcache cache;
    private final boolean persistent;
    private final String diskPath;
    private File dataFile;
    private File indexFile;
    private Status status = Status.STATUS_UNINITIALISED;
    private long totalSize;
    private final long maxElementsOnDisk;
    private boolean eternal;
    private int lastElementSize;
    private int diskSpoolBufferSizeBytes;

    public DiskStore(Ehcache cache, String diskPath) {
        this.cache = cache;
        this.name = cache.getName();
        this.diskPath = diskPath;
        this.expiryThreadInterval = cache.getDiskExpiryThreadIntervalSeconds();
        this.persistent = cache.isDiskPersistent();
        this.maxElementsOnDisk = cache.getMaxElementsOnDisk();
        this.eternal = cache.isEternal();
        this.diskSpoolBufferSizeBytes = cache.getCacheConfiguration().getDiskSpoolBufferSizeMB() * 0x100000;
        try {
            this.initialiseFiles();
            this.active = true;
            this.spoolAndExpiryThread = new SpoolAndExpiryThread();
            this.spoolAndExpiryThread.start();
            this.status = Status.STATUS_ALIVE;
        }
        catch (Exception e) {
            this.dispose();
            LOG.error(this.name + "Cache: Could not create disk store. Initial cause was " + e.getMessage(), e);
        }
    }

    private void initialiseFiles() throws Exception {
        File diskDir = new File(this.diskPath);
        if (diskDir.exists() && !diskDir.isDirectory()) {
            throw new Exception("Store directory \"" + diskDir.getCanonicalPath() + "\" exists and is not a directory.");
        }
        if (!diskDir.exists() && !diskDir.mkdirs()) {
            throw new Exception("Could not create cache directory \"" + diskDir.getCanonicalPath() + "\".");
        }
        this.dataFile = new File(diskDir, this.getDataFileName());
        this.indexFile = new File(diskDir, this.getIndexFileName());
        this.deleteIndexIfNoData();
        if (this.persistent) {
            if (this.diskPath.indexOf(AUTO_DISK_PATH_DIRECTORY_PREFIX) != -1) {
                LOG.warn("Data in persistent disk stores is ignored for stores from automatically created directories (they start with ehcache_auto_created).\nRemove diskPersistent or resolve the conflicting disk paths in cache configuration.\nDeleting data file " + this.getDataFileName());
                this.dataFile.delete();
            } else if (!this.readIndex()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Index file dirty or empty. Deleting data file " + this.getDataFileName());
                }
                this.dataFile.delete();
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleting data file " + this.getDataFileName());
            }
            this.dataFile.delete();
            this.indexFile = null;
        }
        this.randomAccessFile = new RandomAccessFile(this.dataFile, "rw");
    }

    private void deleteIndexIfNoData() {
        boolean dataFileExists = this.dataFile.exists();
        boolean indexFileExists = this.indexFile.exists();
        if (!dataFileExists && indexFileExists) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Matching data file missing for index file. Deleting index file " + this.getIndexFileName());
            }
            this.indexFile.delete();
        }
    }

    private void checkActive() throws CacheException {
        if (!this.active) {
            throw new CacheException(this.name + " Cache: The Disk store is not active.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Element get(Object key) {
        try {
            Element element;
            this.checkActive();
            Object object = this.spoolLock;
            synchronized (object) {
                element = (Element)this.spool.remove(key);
            }
            if (element != null) {
                element.updateAccessStatistics();
                return element;
            }
            DiskElement diskElement = (DiskElement)this.diskElements.get(key);
            if (diskElement == null) {
                return null;
            }
            element = this.loadElementFromDiskElement(diskElement);
            element.updateAccessStatistics();
            return element;
        }
        catch (Exception exception) {
            LOG.error(this.name + "Cache: Could not read disk store element for key " + key + ". Error was " + exception.getMessage(), exception);
            return null;
        }
    }

    public final boolean containsKey(Object key) {
        return this.diskElements.containsKey(key) || this.spool.containsKey(key);
    }

    private Element loadElementFromDiskElement(DiskElement diskElement) throws IOException, ClassNotFoundException {
        this.randomAccessFile.seek(diskElement.position);
        byte[] buffer = new byte[diskElement.payloadSize];
        this.randomAccessFile.readFully(buffer);
        ByteArrayInputStream instr = new ByteArrayInputStream(buffer);
        ObjectInputStream objstr = new ObjectInputStream(instr){

            protected Class resolveClass(ObjectStreamClass clazz) throws ClassNotFoundException, IOException {
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    return Class.forName(clazz.getName(), false, classLoader);
                }
                catch (ClassNotFoundException e) {
                    return super.resolveClass(clazz);
                }
            }
        };
        Element element = (Element)objstr.readObject();
        objstr.close();
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Element getQuiet(Object key) {
        try {
            Element element;
            this.checkActive();
            Object object = this.spoolLock;
            synchronized (object) {
                element = (Element)this.spool.remove(key);
            }
            if (element != null) {
                return element;
            }
            DiskElement diskElement = (DiskElement)this.diskElements.get(key);
            if (diskElement == null) {
                return null;
            }
            element = this.loadElementFromDiskElement(diskElement);
            return element;
        }
        catch (Exception e) {
            LOG.error(this.name + "Cache: Could not read disk store element for key " + key + ". Initial cause was " + e.getMessage(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Object[] getKeyArray() {
        Set spoolKeySet;
        Set elementKeySet;
        Map map = this.diskElements;
        synchronized (map) {
            elementKeySet = this.diskElements.keySet();
        }
        Object object = this.spoolLock;
        synchronized (object) {
            spoolKeySet = this.spool.keySet();
        }
        HashSet allKeysSet = new HashSet(elementKeySet.size() + spoolKeySet.size());
        allKeysSet.addAll(elementKeySet);
        allKeysSet.addAll(spoolKeySet);
        return allKeysSet.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized int getSize() {
        try {
            int diskSize;
            int spoolSize;
            this.checkActive();
            Object object = this.spoolLock;
            synchronized (object) {
                spoolSize = this.spool.size();
            }
            Map map = this.diskElements;
            synchronized (map) {
                diskSize = this.diskElements.size();
            }
            return spoolSize + diskSize;
        }
        catch (Exception e) {
            LOG.error(this.name + "Cache: Could not determine size of disk store.. Initial cause was " + e.getMessage(), e);
            return 0;
        }
    }

    public final Status getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(Element element) {
        block9: {
            try {
                this.checkActive();
                if (this.spoolAndExpiryThread.isAlive()) {
                    Object object = this.spoolLock;
                    synchronized (object) {
                        this.spool.put(element.getObjectKey(), element);
                        break block9;
                    }
                }
                LOG.error(this.name + "Cache: Elements cannot be written to disk store because the" + " spool thread has died.");
                Object object = this.spoolLock;
                synchronized (object) {
                    this.spool.clear();
                }
            }
            catch (Exception e) {
                LOG.error(this.name + "Cache: Could not write disk store element for " + element.getObjectKey() + ". Initial cause was " + e.getMessage(), e);
            }
        }
    }

    public boolean backedUp() {
        boolean backedUp;
        long estimatedSpoolSize = this.spool.size() * this.lastElementSize;
        boolean bl = backedUp = estimatedSpoolSize > (long)this.diskSpoolBufferSizeBytes;
        if (backedUp && LOG.isTraceEnabled()) {
            LOG.trace("A back up on cache puts occurred. Consider increasing diskSpoolBufferSizeMB for cache " + this.name);
        }
        return backedUp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Element remove(Object key) {
        Element element;
        try {
            this.checkActive();
            Object object = this.spoolLock;
            synchronized (object) {
                element = (Element)this.spool.remove(key);
            }
            object = this.diskElements;
            synchronized (object) {
                DiskElement diskElement = (DiskElement)this.diskElements.remove(key);
                if (diskElement != null) {
                    element = this.loadElementFromDiskElement(diskElement);
                    this.freeBlock(diskElement);
                }
            }
        }
        catch (Exception exception) {
            String message = this.name + "Cache: Could not remove disk store entry for key " + key + ". Error was " + exception.getMessage();
            LOG.error(message, exception);
            throw new CacheException(message);
        }
        return element;
    }

    private void freeBlock(DiskElement diskElement) {
        this.totalSize -= (long)diskElement.payloadSize;
        diskElement.payloadSize = 0;
        diskElement.key = null;
        diskElement.hitcount = 0L;
        diskElement.expiryTime = 0L;
        this.freeSpace.add(diskElement);
    }

    public final synchronized void removeAll() {
        try {
            this.checkActive();
            this.spool = Collections.synchronizedMap(new HashMap());
            this.diskElements = Collections.synchronizedMap(new HashMap());
            this.freeSpace = Collections.synchronizedList(new ArrayList());
            this.totalSize = 0L;
            this.randomAccessFile.setLength(0L);
            if (this.persistent) {
                this.indexFile.delete();
                this.indexFile.createNewFile();
            }
        }
        catch (Exception e) {
            LOG.error(this.name + " Cache: Could not rebuild disk store. Initial cause was " + e.getMessage(), e);
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void dispose() {
        if (!this.active) {
            return;
        }
        try {
            this.flush();
            if (this.spoolAndExpiryThread != null) {
                this.spoolAndExpiryThread.interrupt();
            }
            this.spool.clear();
            this.diskElements.clear();
            this.freeSpace.clear();
            if (this.randomAccessFile != null) {
                this.randomAccessFile.close();
            }
            if (!this.persistent) {
                LOG.debug("Deleting file " + this.dataFile.getName());
                this.dataFile.delete();
            }
        }
        catch (Exception e) {
            LOG.error(this.name + "Cache: Could not shut down disk cache. Initial cause was " + e.getMessage(), e);
        }
        finally {
            this.active = false;
            this.randomAccessFile = null;
            this.notifyAll();
            this.cache = null;
        }
    }

    public final void flush() throws IOException {
        if (this.persistent) {
            this.flushSpool();
            this.writeIndex();
        }
    }

    private void spoolAndExpiryThreadMain() {
        long nextExpiryTime = System.currentTimeMillis();
        while (true) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                LOG.debug("Spool Thread interrupted.");
                return;
            }
            if (!this.active) {
                return;
            }
            this.throwableSafeFlushSpoolIfRequired();
            if (!this.active) {
                return;
            }
            nextExpiryTime = this.throwableSafeExpireElementsIfRequired(nextExpiryTime);
        }
    }

    private long throwableSafeExpireElementsIfRequired(long nextExpiryTime) {
        long updatedNextExpiryTime = nextExpiryTime;
        if (!this.eternal && System.currentTimeMillis() > nextExpiryTime) {
            try {
                updatedNextExpiryTime += this.expiryThreadInterval * 1000L;
                this.expireElements();
            }
            catch (Throwable e) {
                LOG.error(this.name + " Cache: Could not expire elements from disk due to " + e.getMessage() + ". Continuing...", e);
            }
        }
        return updatedNextExpiryTime;
    }

    private void throwableSafeFlushSpoolIfRequired() {
        if (this.spool != null && this.spool.size() != 0) {
            try {
                this.flushSpool();
            }
            catch (Throwable e) {
                LOG.error(this.name + " Cache: Could not flush elements to disk due to " + e.getMessage() + ". Continuing...", e);
            }
        }
    }

    private synchronized void flushSpool() throws IOException {
        if (this.spool.size() == 0) {
            return;
        }
        Map copyOfSpool = this.swapSpoolReference();
        Iterator valuesIterator = copyOfSpool.values().iterator();
        while (valuesIterator.hasNext()) {
            this.writeOrReplaceEntry(valuesIterator.next());
            valuesIterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map swapSpoolReference() {
        Map copyOfSpool = null;
        Object object = this.spoolLock;
        synchronized (object) {
            copyOfSpool = this.spool;
            this.spool = Collections.synchronizedMap(new HashMap());
        }
        return copyOfSpool;
    }

    private void writeOrReplaceEntry(Object object) throws IOException {
        Element element = (Element)object;
        if (element == null) {
            return;
        }
        Serializable key = (Serializable)element.getObjectKey();
        this.removeOldEntryIfAny(key);
        if (this.maxElementsOnDisk > 0L && (long)this.diskElements.size() >= this.maxElementsOnDisk) {
            this.evictLfuDiskElement();
        }
        this.writeElement(element, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeElement(Element element, Serializable key) throws IOException {
        try {
            long expirationTime = element.getExpirationTime();
            MemoryEfficientByteArrayOutputStream buffer = null;
            try {
                buffer = this.serializeEntry(element);
                int bufferLength = buffer.size();
                DiskElement diskElement = this.checkForFreeBlock(bufferLength);
                this.randomAccessFile.seek(diskElement.position);
                this.randomAccessFile.write(buffer.toByteArray(), 0, bufferLength);
                buffer = null;
                diskElement.payloadSize = bufferLength;
                diskElement.key = key;
                diskElement.expiryTime = expirationTime;
                diskElement.hitcount = element.getHitCount();
                this.totalSize += (long)bufferLength;
                this.lastElementSize = bufferLength;
                Map map = this.diskElements;
                synchronized (map) {
                    this.diskElements.put(key, diskElement);
                }
            }
            catch (OutOfMemoryError e) {
                LOG.error("OutOfMemoryError on serialize: " + key);
            }
        }
        catch (Exception e) {
            LOG.error(this.name + "Cache: Failed to write element to disk '" + key + "'. Initial cause was " + e.getMessage(), e);
        }
    }

    private MemoryEfficientByteArrayOutputStream serializeEntry(Element element) throws IOException {
        MemoryEfficientByteArrayOutputStream outstr = new MemoryEfficientByteArrayOutputStream(this.estimatedPayloadSize());
        ObjectOutputStream objstr = new ObjectOutputStream(outstr);
        objstr.writeObject(element);
        objstr.close();
        return outstr;
    }

    private int estimatedPayloadSize() {
        int size = 0;
        try {
            size = (int)(this.totalSize / (long)this.diskElements.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (size <= 0) {
            size = 512;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOldEntryIfAny(Serializable key) {
        DiskElement oldBlock;
        Map map = this.diskElements;
        synchronized (map) {
            oldBlock = (DiskElement)this.diskElements.remove(key);
        }
        if (oldBlock != null) {
            this.freeBlock(oldBlock);
        }
    }

    private DiskElement checkForFreeBlock(int bufferLength) throws IOException {
        DiskElement diskElement = this.findFreeBlock(bufferLength);
        if (diskElement == null) {
            diskElement = new DiskElement();
            diskElement.position = this.randomAccessFile.length();
            diskElement.blockSize = bufferLength;
        }
        return diskElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeIndex() throws IOException {
        ObjectOutputStream objectOutputStream = null;
        try {
            FileOutputStream fout = new FileOutputStream(this.indexFile);
            objectOutputStream = new ObjectOutputStream(fout);
            objectOutputStream.writeObject(this.diskElements);
            objectOutputStream.writeObject(this.freeSpace);
        }
        finally {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized boolean readIndex() throws IOException {
        ObjectInputStream objectInputStream = null;
        FileInputStream fin = null;
        boolean success = false;
        if (this.indexFile.exists()) {
            try {
                fin = new FileInputStream(this.indexFile);
                objectInputStream = new ObjectInputStream(fin);
                this.diskElements = (Map)objectInputStream.readObject();
                this.freeSpace = (List)objectInputStream.readObject();
                success = true;
                return success;
            }
            catch (StreamCorruptedException e) {
                LOG.error("Corrupt index file. Creating new index.");
                return success;
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) return success;
                LOG.debug("IOException reading index. Creating new index. ");
                return success;
            }
            catch (ClassNotFoundException e) {
                LOG.error("Class loading problem reading index. Creating new index. Initial cause was " + e.getMessage(), e);
                return success;
            }
            finally {
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    } else if (fin != null) {
                        fin.close();
                    }
                }
                catch (IOException e) {
                    LOG.error("Problem closing the index file.");
                }
                this.createNewIndexFile();
            }
        }
        this.createNewIndexFile();
        return success;
    }

    private void createNewIndexFile() throws IOException {
        if (this.indexFile.exists()) {
            this.indexFile.delete();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Index file " + this.indexFile + " deleted.");
            }
        }
        if (this.indexFile.createNewFile()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Index file " + this.indexFile + " created successfully");
            }
        } else {
            throw new IOException("Index file " + this.indexFile + " could not created.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireElements() {
        long now = System.currentTimeMillis();
        Object object = this.spoolLock;
        synchronized (object) {
            Iterator iterator = this.spool.values().iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                if (!element.isExpired()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.name + "Cache: Removing expired spool element " + element.getObjectKey());
                }
                iterator.remove();
                this.notifyExpiryListeners(element);
            }
        }
        Element element = null;
        RegisteredEventListeners listeners = this.cache.getCacheEventNotificationService();
        Map map = this.diskElements;
        synchronized (map) {
            Iterator iterator = this.diskElements.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                DiskElement diskElement = (DiskElement)entry.getValue();
                if (now < diskElement.expiryTime) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.name + "Cache: Removing expired spool element " + entry.getKey() + " from Disk Store");
                }
                iterator.remove();
                if (listeners.hasCacheEventListeners()) {
                    try {
                        element = this.loadElementFromDiskElement(diskElement);
                        this.notifyExpiryListeners(element);
                    }
                    catch (Exception exception) {
                        LOG.error(this.name + "Cache: Could not remove disk store entry for " + entry.getKey() + ". Error was " + exception.getMessage(), exception);
                    }
                }
                this.freeBlock(diskElement);
            }
        }
    }

    private void notifyExpiryListeners(Element element) {
        this.cache.getCacheEventNotificationService().notifyElementExpiry(element, false);
    }

    private DiskElement findFreeBlock(int length) {
        for (int i = 0; i < this.freeSpace.size(); ++i) {
            DiskElement element = (DiskElement)this.freeSpace.get(i);
            if (element.blockSize < length) continue;
            this.freeSpace.remove(i);
            return element;
        }
        return null;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ dataFile = ").append(this.dataFile.getAbsolutePath()).append(", active=").append(this.active).append(", totalSize=").append(this.totalSize).append(", status=").append(this.status).append(", expiryThreadInterval = ").append(this.expiryThreadInterval).append(" ]");
        return sb.toString();
    }

    public static String generateUniqueDirectory() {
        return "ehcache_auto_created_" + System.currentTimeMillis();
    }

    public final long getTotalFileSize() {
        return this.getDataFileSize() + this.getIndexFileSize();
    }

    public final long getDataFileSize() {
        return this.dataFile.length();
    }

    public final float calculateDataFileSparseness() {
        return 1.0f - (float)this.getUsedDataSize() / (float)this.getDataFileSize();
    }

    public final long getUsedDataSize() {
        return this.totalSize;
    }

    public final long getIndexFileSize() {
        if (this.indexFile == null) {
            return 0L;
        }
        return this.indexFile.length();
    }

    public final String getDataFileName() {
        return this.name + ".data";
    }

    public final String getDataFilePath() {
        return this.diskPath;
    }

    public final String getIndexFileName() {
        return this.name + ".index";
    }

    public final boolean isSpoolThreadAlive() {
        if (this.spoolAndExpiryThread == null) {
            return false;
        }
        return this.spoolAndExpiryThread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictLfuDiskElement() {
        Map map = this.diskElements;
        synchronized (map) {
            DiskElement diskElement = this.findRelativelyUnused();
            this.diskElements.remove(diskElement.key);
            this.notifyEvictionListeners(diskElement);
            this.freeBlock(diskElement);
        }
    }

    private DiskElement findRelativelyUnused() {
        LfuPolicy.Metadata[] elements = this.sampleElements(this.diskElements);
        LfuPolicy.Metadata metadata = LfuPolicy.leastHit(elements, null);
        return (DiskElement)metadata;
    }

    private LfuPolicy.Metadata[] sampleElements(Map map) {
        int[] offsets = LfuPolicy.generateRandomSample(map.size());
        LfuPolicy.Metadata[] elements = new DiskElement[offsets.length];
        Iterator iterator = map.values().iterator();
        for (int i = 0; i < offsets.length; ++i) {
            for (int j = 0; j < offsets[i]; ++j) {
                iterator.next();
            }
            elements[i] = (DiskElement)iterator.next();
        }
        return elements;
    }

    private void notifyEvictionListeners(DiskElement diskElement) {
        RegisteredEventListeners listeners = this.cache.getCacheEventNotificationService();
        if (listeners.hasCacheEventListeners()) {
            Element element = null;
            try {
                element = this.loadElementFromDiskElement(diskElement);
                this.cache.getCacheEventNotificationService().notifyElementEvicted(element, false);
            }
            catch (Exception exception) {
                LOG.error(this.name + "Cache: Could not notify disk store eviction of " + element.getObjectKey() + ". Error was " + exception.getMessage(), exception);
            }
        }
    }

    private final class SpoolAndExpiryThread
    extends Thread {
        public SpoolAndExpiryThread() {
            super("Store " + DiskStore.this.name + " Spool Thread");
            this.setDaemon(true);
            this.setPriority(5);
        }

        public final void run() {
            DiskStore.this.spoolAndExpiryThreadMain();
        }
    }

    private static final class DiskElement
    implements Serializable,
    LfuPolicy.Metadata {
        private static final long serialVersionUID = -717310932566592289L;
        private long position;
        private int payloadSize;
        private int blockSize;
        private Object key;
        private long expiryTime;
        private long hitcount;

        private DiskElement() {
        }

        public Object getObjectKey() {
            return this.key;
        }

        public long getHitCount() {
            return this.hitcount;
        }
    }

    class MemoryEfficientByteArrayOutputStream
    extends ByteArrayOutputStream {
        public MemoryEfficientByteArrayOutputStream(int size) {
            super(size);
        }

        public synchronized byte[] getBytes() {
            return this.buf;
        }
    }
}

