/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.EastNorthBound;
import cadastre_fr.VectorImageModifier;
import cadastre_fr.WMSLayer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.NavigatableComponent;

public class GeorefImage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public EastNorth min;
    public EastNorth max;
    public EastNorth[] orgRaster = new EastNorth[4];
    public EastNorth[] orgCroppedRaster = new EastNorth[4];
    public double angle = 0.0;
    public BufferedImage image;
    private double pixelPerEast;
    private double pixelPerNorth;

    public GeorefImage(BufferedImage img, EastNorth min, EastNorth max) {
        this.image = img;
        this.min = min;
        this.max = max;
        this.orgRaster[0] = min;
        this.orgRaster[1] = new EastNorth(min.east(), max.north());
        this.orgRaster[2] = max;
        this.orgRaster[3] = new EastNorth(max.east(), min.north());
        this.orgCroppedRaster[0] = min;
        this.orgCroppedRaster[1] = new EastNorth(min.east(), max.north());
        this.orgCroppedRaster[2] = max;
        this.orgCroppedRaster[3] = new EastNorth(max.east(), min.north());
        this.updatePixelPer();
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }

    private EastNorthBound getNewBounding(EastNorth oldMin, EastNorth oldMax, EastNorth c, EastNorth d) {
        EastNorth[] pt = new EastNorth[]{oldMin, oldMax, c, d};
        double smallestEast = Double.MAX_VALUE;
        double smallestNorth = Double.MAX_VALUE;
        double highestEast = Double.MIN_VALUE;
        double highestNorth = Double.MIN_VALUE;
        for (int i = 0; i <= 3; ++i) {
            smallestEast = Math.min(pt[i].east(), smallestEast);
            smallestNorth = Math.min(pt[i].north(), smallestNorth);
            highestEast = Math.max(pt[i].east(), highestEast);
            highestNorth = Math.max(pt[i].north(), highestNorth);
        }
        return new EastNorthBound(new EastNorth(smallestEast, smallestNorth), new EastNorth(highestEast, highestNorth));
    }

    public boolean contains(EastNorth en) {
        return this.min.east() <= en.east() && en.east() <= this.max.east() && this.min.north() <= en.north() && en.north() <= this.max.north();
    }

    public void paint(Graphics2D g, NavigatableComponent nc, boolean backgroundTransparent, float transparency, boolean drawBoundaries) {
        if (this.image == null || this.min == null || this.max == null) {
            return;
        }
        Point minPt = nc.getPoint(this.min);
        Point maxPt = nc.getPoint(this.max);
        if (!g.hitClip(minPt.x, maxPt.y, maxPt.x - minPt.x, minPt.y - maxPt.y)) {
            return;
        }
        if (backgroundTransparent && transparency < 1.0f) {
            g.setComposite(AlphaComposite.getInstance(3, transparency));
        }
        if (drawBoundaries) {
            g.setColor(Color.green);
            if (this.orgCroppedRaster == null) {
                g.drawRect(minPt.x, maxPt.y, maxPt.x - minPt.x, minPt.y - maxPt.y);
            } else {
                int i;
                Point[] croppedPoint = new Point[5];
                for (i = 0; i < 4; ++i) {
                    croppedPoint[i] = nc.getPoint(this.orgCroppedRaster[i]);
                }
                croppedPoint[4] = croppedPoint[0];
                for (i = 0; i < 4; ++i) {
                    g.drawLine(croppedPoint[i].x, croppedPoint[i].y, croppedPoint[i + 1].x, croppedPoint[i + 1].y);
                }
            }
        }
        g.drawImage(this.image, minPt.x, maxPt.y, maxPt.x, minPt.y, 0, 0, this.image.getWidth(), this.image.getHeight(), null);
        if (backgroundTransparent && transparency < 1.0f) {
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }

    public boolean overlap(GeorefImage georefImage) {
        if (this.contains(georefImage.min) || this.contains(georefImage.max)) {
            return true;
        }
        return this.contains(new EastNorth(georefImage.min.east(), georefImage.max.north())) || this.contains(new EastNorth(georefImage.max.east(), georefImage.min.north()));
    }

    public void withdraw(GeorefImage georefImage) {
        double maxMaskNorth;
        double minMaskEast = georefImage.min.east() > this.min.east() ? georefImage.min.east() : this.min.east();
        double maxMaskEast = georefImage.max.east() < this.max.east() ? georefImage.max.east() : this.max.east();
        double minMaskNorth = georefImage.min.north() > this.min.north() ? georefImage.min.north() : this.min.north();
        double d = maxMaskNorth = georefImage.max.north() < this.max.north() ? georefImage.max.north() : this.max.north();
        if (maxMaskNorth - minMaskNorth > 0.0 && maxMaskEast - minMaskEast > 0.0) {
            double pixelPerEast = (this.max.east() - this.min.east()) / (double)this.image.getWidth();
            double pixelPerNorth = (this.max.north() - this.min.north()) / (double)this.image.getHeight();
            int minXMaskPixel = (int)((minMaskEast - this.min.east()) / pixelPerEast);
            int minYMaskPixel = (int)((this.max.north() - maxMaskNorth) / pixelPerNorth);
            int widthXMaskPixel = Math.abs((int)((maxMaskEast - minMaskEast) / pixelPerEast));
            int heightYMaskPixel = Math.abs((int)((maxMaskNorth - minMaskNorth) / pixelPerNorth));
            Graphics g = this.image.getGraphics();
            for (int x = minXMaskPixel; x < minXMaskPixel + widthXMaskPixel; ++x) {
                for (int y = minYMaskPixel; y < minYMaskPixel + heightYMaskPixel; ++y) {
                    this.image.setRGB(x, y, VectorImageModifier.cadastreBackgroundTransp);
                }
            }
            g.dispose();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (WMSLayer.currentFormat == 2 || WMSLayer.currentFormat == 3) {
            this.max = new EastNorth(in.readDouble(), in.readDouble());
            this.min = new EastNorth(in.readDouble(), in.readDouble());
        }
        if (WMSLayer.currentFormat == 3) {
            this.orgRaster = new EastNorth[4];
            this.orgCroppedRaster = new EastNorth[4];
            this.angle = in.readDouble();
            this.orgRaster[0] = new EastNorth(in.readDouble(), in.readDouble());
            this.orgRaster[1] = new EastNorth(in.readDouble(), in.readDouble());
            this.orgRaster[2] = new EastNorth(in.readDouble(), in.readDouble());
            this.orgRaster[3] = new EastNorth(in.readDouble(), in.readDouble());
            this.orgCroppedRaster[0] = new EastNorth(in.readDouble(), in.readDouble());
            this.orgCroppedRaster[1] = new EastNorth(in.readDouble(), in.readDouble());
            this.orgCroppedRaster[2] = new EastNorth(in.readDouble(), in.readDouble());
            this.orgCroppedRaster[3] = new EastNorth(in.readDouble(), in.readDouble());
        } else {
            this.orgRaster = null;
            this.orgCroppedRaster = null;
            this.angle = 0.0;
        }
        this.image = ImageIO.read(ImageIO.createImageInputStream(in));
        this.updatePixelPer();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeDouble(this.max.getX());
        out.writeDouble(this.max.getY());
        out.writeDouble(this.min.getX());
        out.writeDouble(this.min.getY());
        if (this.orgRaster == null) {
            this.orgRaster = new EastNorth[4];
            this.orgCroppedRaster = new EastNorth[4];
        }
        out.writeDouble(this.angle);
        out.writeDouble(this.orgRaster[0].getX());
        out.writeDouble(this.orgRaster[0].getY());
        out.writeDouble(this.orgRaster[1].getX());
        out.writeDouble(this.orgRaster[1].getY());
        out.writeDouble(this.orgRaster[2].getX());
        out.writeDouble(this.orgRaster[2].getY());
        out.writeDouble(this.orgRaster[3].getX());
        out.writeDouble(this.orgRaster[3].getY());
        out.writeDouble(this.orgCroppedRaster[0].getX());
        out.writeDouble(this.orgCroppedRaster[0].getY());
        out.writeDouble(this.orgCroppedRaster[1].getX());
        out.writeDouble(this.orgCroppedRaster[1].getY());
        out.writeDouble(this.orgCroppedRaster[2].getX());
        out.writeDouble(this.orgCroppedRaster[2].getY());
        out.writeDouble(this.orgCroppedRaster[3].getX());
        out.writeDouble(this.orgCroppedRaster[3].getY());
        ImageIO.write((RenderedImage)this.image, "png", ImageIO.createImageOutputStream(out));
    }

    private void updatePixelPer() {
        this.pixelPerEast = (double)this.image.getWidth() / (this.max.east() - this.min.east());
        this.pixelPerNorth = (double)this.image.getHeight() / (this.max.north() - this.min.north());
    }

    public double getPixelPerEast() {
        return this.pixelPerEast;
    }

    public double getPixelPerNorth() {
        return this.pixelPerNorth;
    }

    public String toString() {
        return "GeorefImage[min=" + this.min + ", max=" + this.max + ", image" + this.image + "]";
    }

    public void shear(double dx, double dy) {
        this.min = new EastNorth(this.min.east() + dx, this.min.north() + dy);
        this.max = new EastNorth(this.max.east() + dx, this.max.north() + dy);
        for (int i = 0; i < 4; ++i) {
            this.orgRaster[i] = new EastNorth(this.orgRaster[i].east() + dx, this.orgRaster[i].north() + dy);
            this.orgCroppedRaster[i] = new EastNorth(this.orgCroppedRaster[i].east() + dx, this.orgCroppedRaster[i].north() + dy);
        }
    }

    public void scale(EastNorth anchor, double proportion) {
        this.min = anchor.interpolate(this.min, proportion);
        this.max = anchor.interpolate(this.max, proportion);
        for (int i = 0; i < 4; ++i) {
            this.orgRaster[i] = anchor.interpolate(this.orgRaster[i], proportion);
            this.orgCroppedRaster[i] = anchor.interpolate(this.orgCroppedRaster[i], proportion);
        }
        this.updatePixelPer();
    }

    public void rotate(EastNorth anchor, double ang) {
        EastNorth min2 = new EastNorth(this.orgRaster[0].east(), this.orgRaster[2].north());
        EastNorth max2 = new EastNorth(this.orgRaster[2].east(), this.orgRaster[0].north());
        for (int i = 0; i < 4; ++i) {
            this.orgRaster[i] = this.orgRaster[i].rotate(anchor, ang);
            this.orgCroppedRaster[i] = this.orgCroppedRaster[i].rotate(anchor, ang);
        }
        min2 = min2.rotate(anchor, ang);
        max2 = max2.rotate(anchor, ang);
        EastNorthBound enb = this.getNewBounding(this.orgCroppedRaster[0], this.orgCroppedRaster[2], min2, max2);
        this.min = enb.min;
        this.max = enb.max;
        this.angle = ang;
        double sin = Math.abs(Math.sin(ang));
        double cos = Math.abs(Math.cos(ang));
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        int neww = (int)Math.floor((double)w * cos + (double)h * sin);
        int newh = (int)Math.floor((double)h * cos + (double)w * sin);
        GraphicsConfiguration gc = GeorefImage.getDefaultConfiguration();
        BufferedImage result = gc.createCompatibleImage(neww, newh, 3);
        Graphics2D g = result.createGraphics();
        g.translate((neww - w) / 2, (newh - h) / 2);
        g.rotate(ang, w / 2, h / 2);
        g.drawRenderedImage(this.image, null);
        g.dispose();
        this.image = result;
    }
}

