/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.osb.OsbPlugin;
import org.openstreetmap.josm.plugins.osb.gui.OsbListItem;

public class OsbBugListCellRenderer
implements ListCellRenderer {
    private Color background = Color.WHITE;
    private Color altBackground = new Color(250, 250, 220);

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = new JLabel();
        label.setOpaque(true);
        if (isSelected) {
            label.setForeground(UIManager.getColor("List.selectionForeground"));
            label.setBackground(UIManager.getColor("List.selectionBackground"));
        } else {
            label.setForeground(UIManager.getColor("List.foreground"));
            label.setBackground(index % 2 == 0 ? this.background : this.altBackground);
        }
        OsbListItem item = (OsbListItem)value;
        Node n = item.getNode();
        ImageIcon icon = null;
        if ("0".equals(n.get("state"))) {
            icon = OsbPlugin.loadIcon("icon_error16.png");
        } else if ("1".equals(n.get("state"))) {
            icon = OsbPlugin.loadIcon("icon_valid16.png");
        }
        label.setIcon(icon);
        String text = n.get("note");
        if (text.indexOf("<hr />") > 0) {
            text = text.substring(0, text.indexOf("<hr />"));
        }
        label.setText("<html>" + text + "</html>");
        Dimension d = label.getPreferredSize();
        d.height += 10;
        label.setPreferredSize(d);
        return label;
    }
}

