/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.awt.Component;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateNode
extends Test {
    protected static int DUPLICATE_NODE = 1;
    Map<LatLon, Object> potentialDuplicates;

    public DuplicateNode() {
        super(I18n.tr((String)"Duplicated nodes") + ".", I18n.tr((String)"This test checks that there are no nodes at the very same location."));
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.potentialDuplicates = new HashMap<LatLon, Object>();
    }

    @Override
    public void endTest() {
        for (Map.Entry<LatLon, Object> entry : this.potentialDuplicates.entrySet()) {
            Object v = entry.getValue();
            if (v instanceof Node) continue;
            NodesByEqualTagsMap map = (NodesByEqualTagsMap)v;
            this.errors.addAll(map.buildTestErrors(this));
        }
        super.endTest();
        this.potentialDuplicates = null;
    }

    @Override
    public void visit(Node n) {
        if (n.isUsable()) {
            LatLon rounded = n.getCoor().getRoundedToOsmPrecision();
            if (this.potentialDuplicates.get(rounded) == null) {
                this.potentialDuplicates.put(rounded, n);
            } else if (this.potentialDuplicates.get(rounded) instanceof Node) {
                Node n1 = (Node)this.potentialDuplicates.get(rounded);
                NodesByEqualTagsMap map = new NodesByEqualTagsMap();
                map.add(n1);
                map.add(n);
                this.potentialDuplicates.put(rounded, map);
            } else if (this.potentialDuplicates.get(rounded) instanceof NodesByEqualTagsMap) {
                NodesByEqualTagsMap map = (NodesByEqualTagsMap)this.potentialDuplicates.get(rounded);
                map.add(n);
            }
        }
    }

    @Override
    public Command fixError(TestError testError) {
        LinkedList<? extends OsmPrimitive> sel = new LinkedList<OsmPrimitive>(testError.getPrimitives());
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>(OsmPrimitive.getFilteredList(sel, Node.class));
        Node target = MergeNodesAction.selectTargetNode(nodes);
        if (DuplicateNode.checkAndConfirmOutlyingDeletes(nodes)) {
            return MergeNodesAction.mergeNodes((OsmDataLayer)Main.main.getEditLayer(), nodes, (Node)target);
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        return testError.getTester() instanceof DuplicateNode;
    }

    private static boolean checkAndConfirmOutlyingDeletes(LinkedHashSet<Node> del) {
        Area a = Main.main.getCurrentDataSet().getDataSourceArea();
        if (a != null) {
            for (Node osm : del) {
                Node n;
                if (!(osm instanceof Node) || osm.isNew() || a.contains((Point2D)(n = osm).getCoor())) continue;
                return ConditionalOptionPaneUtil.showConfirmationDialog((String)"delete_outside_nodes", (Component)Main.parent, (Object)(I18n.tr((String)"You are about to delete nodes outside of the area you have downloaded.<br>This can cause problems because other objects (that you don't see) might use them.<br>Do you really want to delete?") + "</html>"), (String)I18n.tr((String)"Confirmation"), (int)0, (int)3, (int)0);
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodesByEqualTagsMap {
        private Bag<Map<String, String>, OsmPrimitive> bag = new Bag();

        public void add(Node n) {
            this.bag.add(n.getKeys(), (OsmPrimitive)n);
        }

        public List<TestError> buildTestErrors(Test parentTest) {
            ArrayList<TestError> errors = new ArrayList<TestError>();
            Iterator it = this.bag.keySet().iterator();
            while (it.hasNext()) {
                Map tagSet = (Map)it.next();
                if (this.bag.get(tagSet).size() <= 1) continue;
                errors.add(new TestError(parentTest, Severity.ERROR, I18n.tr((String)"Duplicated nodes"), DUPLICATE_NODE, this.bag.get(tagSet)));
                it.remove();
            }
            if (!this.bag.isEmpty()) {
                ArrayList duplicates = new ArrayList();
                for (List l : this.bag.values()) {
                    duplicates.addAll(l);
                }
                if (duplicates.size() > 1) {
                    errors.add(new TestError(parentTest, Severity.WARNING, I18n.tr((String)"Nodes at same position"), DUPLICATE_NODE, duplicates));
                }
            }
            return errors;
        }
    }
}

