/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.slippymap;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapPreferences;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class SlippyMapPreferenceSetting
implements PreferenceSetting {
    private JComboBox tileSourceCombo;
    private JCheckBox autozoomActive = new JCheckBox(I18n.tr((String)"autozoom"));
    private JCheckBox autoloadTiles = new JCheckBox(I18n.tr((String)"autoload tiles"));
    private JSpinner maxZoomLvl;
    private JSpinner minZoomLvl = new JSpinner();
    private JSlider fadeBackground = new JSlider(0, 100);

    public void addGui(PreferenceTabbedPane gui) {
        this.minZoomLvl = new JSpinner(new SpinnerNumberModel(2, 2, 30, 1));
        this.maxZoomLvl = new JSpinner(new SpinnerNumberModel(20, 2, 30, 1));
        JPanel slippymapTab = gui.createPreferenceTab("slippymap.png", I18n.tr((String)"SlippyMap"), I18n.tr((String)"Settings for the SlippyMap plugin."));
        List<TileSource> allSources = SlippyMapPreferences.getAllMapSources();
        this.tileSourceCombo = new JComboBox<Object>(allSources.toArray());
        this.tileSourceCombo.setSelectedItem(SlippyMapPreferences.getMapSource());
        slippymapTab.add((Component)new JLabel(I18n.tr((String)"Tile Sources")), GBC.std());
        slippymapTab.add(GBC.glue((int)5, (int)0), GBC.std());
        slippymapTab.add((Component)this.tileSourceCombo, GBC.eol().fill(2));
        slippymapTab.add((Component)new JLabel(I18n.tr((String)"Auto zoom: ")), GBC.std());
        slippymapTab.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        slippymapTab.add((Component)this.autozoomActive, GBC.eol().fill(2));
        slippymapTab.add((Component)new JLabel(I18n.tr((String)"Autoload Tiles: ")), GBC.std());
        slippymapTab.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        slippymapTab.add((Component)this.autoloadTiles, GBC.eol().fill(2));
        slippymapTab.add((Component)new JLabel(I18n.tr((String)"Min zoom lvl: ")), GBC.std());
        slippymapTab.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        slippymapTab.add((Component)this.minZoomLvl, GBC.eol().fill(2));
        slippymapTab.add((Component)new JLabel(I18n.tr((String)"Max zoom lvl: ")), GBC.std());
        slippymapTab.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        slippymapTab.add((Component)this.maxZoomLvl, GBC.eol().fill(2));
        slippymapTab.add((Component)new JLabel(I18n.tr((String)"Fade background: ")), GBC.std());
        slippymapTab.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        slippymapTab.add((Component)this.fadeBackground, GBC.eol().fill(2));
        slippymapTab.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        this.tileSourceCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SlippyMapPreferenceSetting.this.updateSpinnerModels();
            }
        });
        this.loadSettings();
        this.updateSpinnerModels();
    }

    void updateSpinnerModel(JSpinner s, int min, int max) {
        int val = (Integer)s.getValue();
        val = Math.min(max, val);
        val = Math.max(min, val);
        SpinnerNumberModel model = new SpinnerNumberModel(val, min, max, 1);
        s.setModel(model);
    }

    void updateSpinnerModels() {
        TileSource ts = (TileSource)this.tileSourceCombo.getSelectedItem();
        int min = ts.getMinZoom();
        int max = ts.getMaxZoom();
        this.updateSpinnerModel(this.minZoomLvl, min, max);
        this.updateSpinnerModel(this.maxZoomLvl, min, max);
    }

    private void loadSettings() {
        this.autozoomActive.setSelected(SlippyMapPreferences.getAutozoom());
        this.autoloadTiles.setSelected(SlippyMapPreferences.getAutoloadTiles());
        this.maxZoomLvl.setValue(SlippyMapPreferences.getMaxZoomLvl());
        this.minZoomLvl.setValue(SlippyMapPreferences.getMinZoomLvl());
        this.fadeBackground.setValue(Math.round(SlippyMapPreferences.getFadeBackground() * 100.0f));
    }

    public boolean ok() {
        SlippyMapPreferences.setMapSource((TileSource)this.tileSourceCombo.getSelectedItem());
        SlippyMapPreferences.setAutozoom(this.autozoomActive.isSelected());
        SlippyMapPreferences.setAutoloadTiles(this.autoloadTiles.isSelected());
        SlippyMapPreferences.setMaxZoomLvl((Integer)this.maxZoomLvl.getValue());
        SlippyMapPreferences.setMinZoomLvl((Integer)this.minZoomLvl.getValue());
        SlippyMapPreferences.setFadeBackground((float)this.fadeBackground.getValue() / 100.0f);
        return false;
    }
}

