/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ValueStringParser {
    private static final Pattern DEC_POINT_PATTERN = Pattern.compile("^(\\-?\\d+)\\.(\\d+)$");
    private static final Pattern KMH_PATTERN = Pattern.compile("^(\\d+)\\s*km/h$");
    private static final Pattern MPH_PATTERN = Pattern.compile("^(\\d+)\\s*mph$");
    private static final float KM_PER_MILE = 1.609344f;
    private static final Pattern INCLINE_PATTERN = Pattern.compile("^(\\-?\\d+(?:\\.\\d+)?)\\s*%$");

    private ValueStringParser() {
    }

    public static final Float parseOsmDecimal(String value, boolean allowNegative) {
        try {
            int weight = Integer.parseInt(value);
            if (weight >= 0 || allowNegative) {
                return Float.valueOf(weight);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        Matcher matcher = DEC_POINT_PATTERN.matcher(value);
        if (matcher.matches()) {
            String stringBeforePoint = matcher.group(1);
            String stringAfterPoint = matcher.group(2);
            if (stringBeforePoint.length() > 0 || stringAfterPoint.length() > 0) {
                try {
                    float beforePoint = Integer.parseInt(stringBeforePoint);
                    float afterPoint = Integer.parseInt(stringAfterPoint);
                    double result = (double)Math.signum(beforePoint) * ((double)Math.abs(beforePoint) + Math.pow(10.0, -stringAfterPoint.length()) * (double)afterPoint);
                    if (result >= 0.0 || allowNegative) {
                        return Float.valueOf((float)result);
                    }
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static final Float parseSpeed(String value) {
        Matcher mphMatcher;
        Float maxspeed = ValueStringParser.parseOsmDecimal(value, false);
        if (maxspeed != null) {
            return maxspeed;
        }
        Matcher kmhMatcher = KMH_PATTERN.matcher(value);
        if (kmhMatcher.matches()) {
            String kmhString = kmhMatcher.group(1);
            try {
                return Float.valueOf(Integer.parseInt(kmhString));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((mphMatcher = MPH_PATTERN.matcher(value)).matches()) {
            String mphString = mphMatcher.group(1);
            try {
                int mph = Integer.parseInt(mphString);
                return Float.valueOf(1.609344f * (float)mph);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return null;
    }

    public static final Float parseIncline(String value) {
        Matcher inclineMatcher = INCLINE_PATTERN.matcher(value);
        if (inclineMatcher.matches()) {
            String inclineString = inclineMatcher.group(1);
            return ValueStringParser.parseOsmDecimal(inclineString, true);
        }
        return null;
    }
}

