/*
 * Decompiled with CFR 0.152.
 */
package terracer;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class ReverseTerraceAction
extends JosmAction {
    public ReverseTerraceAction() {
        super(I18n.tr((String)"Reverse a terrace"), "reverse_terrace", I18n.tr((String)"Reverses house numbers on a terrace."), Shortcut.registerShortcut((String)"tools:ReverseTerrace", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Reverse a Terrace")}), (int)82, (int)3, (int)1), true);
    }

    public void actionPerformed(ActionEvent e) {
        Collection sel = Main.main.getCurrentDataSet().getSelected();
        HashSet<Node> visitedNodes = new HashSet<Node>();
        HashSet<Way> front = new HashSet<Way>();
        for (OsmPrimitive prim : sel) {
            if (!prim.keySet().contains("building") || !(prim instanceof Way)) continue;
            front.add((Way)prim);
        }
        LinkedList<Way> orderedWays = new LinkedList<Way>();
        LinkedList<String> houseNumbers = new LinkedList<String>();
        while (front.size() > 0) {
            Way w = (Way)front.iterator().next();
            for (Node n : w.getNodes()) {
                if (visitedNodes.contains(n)) continue;
                for (OsmPrimitive prim : n.getReferrers()) {
                    if (!prim.keySet().contains("building") || !(prim instanceof Way)) continue;
                    front.add((Way)prim);
                }
                visitedNodes.add(n);
            }
            front.remove(w);
            orderedWays.addLast(w);
            houseNumbers.addFirst(w.get("addr:housenumber"));
        }
        LinkedList<ChangePropertyCommand> commands = new LinkedList<ChangePropertyCommand>();
        for (int i = 0; i < orderedWays.size(); ++i) {
            commands.add(new ChangePropertyCommand((OsmPrimitive)orderedWays.get(i), "addr:housenumber", (String)houseNumbers.get(i)));
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Reverse Terrace"), commands));
        Main.main.getCurrentDataSet().setSelected(orderedWays);
    }
}

