/*
 * Decompiled with CFR 0.152.
 */
package terracer;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.widgets.AutoCompleteComboBox;
import org.openstreetmap.josm.tools.I18n;
import terracer.HouseNumberInputHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HouseNumberInputDialog
extends JDialog {
    protected static final String DEFAULT_MESSAGE = "Enter housenumbers or amount of segments";
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel inputPanel = null;
    private JPanel buttonPanel = null;
    private JLabel loLabel = null;
    JTextField lo = null;
    private JLabel hiLabel = null;
    JTextField hi = null;
    private JLabel streetLabel = null;
    AutoCompleteComboBox street;
    private JLabel segmentsLabel = null;
    JTextField segments = null;
    JTextArea messageLabel = null;
    JButton okButton = null;
    JButton cancelButton = null;
    private JLabel interpolationLabel = null;
    Choice interpolation = null;

    public HouseNumberInputDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setTitle("Terrace a house");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.messageLabel = new JTextArea();
            this.messageLabel.setText(DEFAULT_MESSAGE);
            this.messageLabel.setAutoscrolls(true);
            this.messageLabel.setLineWrap(true);
            this.messageLabel.setRows(2);
            this.messageLabel.setBackground(new Color(238, 238, 238));
            this.messageLabel.setEditable(false);
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getInputPanel(), null);
            this.jContentPane.add((Component)this.messageLabel, null);
            this.jContentPane.add((Component)this.getButtonPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getInputPanel() {
        if (this.inputPanel == null) {
            this.interpolationLabel = new JLabel();
            this.interpolationLabel.setText("Interpolation");
            this.segmentsLabel = new JLabel();
            this.segmentsLabel.setText("Segments");
            this.streetLabel = new JLabel();
            this.streetLabel.setText("Street");
            this.hiLabel = new JLabel();
            this.hiLabel.setText("Highest Number");
            this.loLabel = new JLabel();
            this.loLabel.setText("Lowest Number");
            this.loLabel.setPreferredSize(new Dimension(111, 16));
            this.loLabel.setToolTipText("Lowest housenumber of the terraced house");
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(5);
            gridLayout.setColumns(2);
            this.inputPanel = new JPanel();
            this.inputPanel.setLayout(gridLayout);
            this.inputPanel.add((Component)this.loLabel, null);
            this.inputPanel.add((Component)this.getLo(), null);
            this.inputPanel.add((Component)this.hiLabel, null);
            this.inputPanel.add((Component)this.getHi(), null);
            this.inputPanel.add((Component)this.interpolationLabel, null);
            this.inputPanel.add((Component)this.getInterpolation(), null);
            this.inputPanel.add((Component)this.segmentsLabel, null);
            this.inputPanel.add((Component)this.getSegments(), null);
            this.inputPanel.add((Component)this.streetLabel, null);
            this.inputPanel.add((Component)this.getStreet(), null);
        }
        return this.inputPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new FlowLayout());
            this.buttonPanel.add((Component)this.getOkButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JTextField getLo() {
        if (this.lo == null) {
            this.lo = new JTextField();
            this.lo.setText("");
        }
        return this.lo;
    }

    private JTextField getHi() {
        if (this.hi == null) {
            this.hi = new JTextField();
            this.hi.setText("");
        }
        return this.hi;
    }

    private AutoCompleteComboBox getStreet() {
        if (this.street == null) {
            TreeSet<String> names = this.createAutoCompletionInfo();
            this.street = new AutoCompleteComboBox();
            this.street.setPossibleItems(names);
            this.street.setEditable(true);
            this.street.setSelectedItem(null);
        }
        return this.street;
    }

    private JTextField getSegments() {
        if (this.segments == null) {
            this.segments = new JTextField();
            this.segments.setText("1");
        }
        return this.segments;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.setName("OK");
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setName("CANCEL");
        }
        return this.cancelButton;
    }

    private Choice getInterpolation() {
        if (this.interpolation == null) {
            this.interpolation = new Choice();
            this.interpolation.add(I18n.tr((String)"All"));
            this.interpolation.add(I18n.tr((String)"Even/Odd"));
        }
        return this.interpolation;
    }

    public void addHandler(HouseNumberInputHandler handler) {
        this.hi.addActionListener(handler);
        this.hi.addFocusListener(handler);
        this.lo.addActionListener(handler);
        this.lo.addFocusListener(handler);
        this.segments.addActionListener(handler);
        this.segments.addFocusListener(handler);
        this.okButton.addActionListener(handler);
        this.cancelButton.addActionListener(handler);
        this.interpolation.addItemListener(handler);
    }

    TreeSet<String> createAutoCompletionInfo() {
        TreeSet<String> names = new TreeSet<String>();
        for (OsmPrimitive osm : Main.main.getCurrentDataSet().allNonDeletedPrimitives()) {
            if (osm.getKeys() == null || !osm.keySet().contains("highway") || !osm.keySet().contains("name")) continue;
            names.add(osm.get("name"));
        }
        return names;
    }
}

