/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.taggingpresettester;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.plugins.taggingpresettester.TaggingCellRenderer;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class TaggingPresetTester
extends JFrame {
    private JComboBox taggingPresets;
    private final String[] args;
    private JPanel taggingPresetPanel = new JPanel(new BorderLayout());
    private JPanel panel = new JPanel(new BorderLayout());

    public void reload() {
        Vector allPresets = new Vector();
        for (String source : this.args) {
            InputStream in = null;
            try {
                in = source.startsWith("http") || source.startsWith("ftp") || source.startsWith("file") ? new URL(source).openStream() : new FileInputStream(source);
                allPresets.addAll(TaggingPreset.readAll((Reader)new BufferedReader(new InputStreamReader(in))));
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, I18n.tr((String)"Could not read tagging preset source: {0}", (Object[])new Object[]{source}));
            }
            catch (SAXException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, I18n.tr((String)"Error parsing {0}: {1}", (Object[])new Object[]{source, e.getMessage()}));
            }
            try {
                if (in == null) continue;
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.taggingPresets.setModel(new DefaultComboBoxModel(allPresets));
    }

    public void reselect() {
        this.taggingPresetPanel.removeAll();
        TaggingPreset preset = (TaggingPreset)this.taggingPresets.getSelectedItem();
        if (preset == null) {
            return;
        }
        Set x = Collections.emptySet();
        TaggingPreset.PresetPanel p = preset.createPanel(x);
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (p != null) {
            this.taggingPresetPanel.add((Component)p, "North");
        }
        this.panel.validate();
        this.panel.repaint();
    }

    public TaggingPresetTester(String[] args) {
        super(I18n.tr((String)"Tagging Preset Tester"));
        this.args = args;
        this.taggingPresets = new JComboBox();
        this.taggingPresets.setRenderer(new TaggingCellRenderer());
        this.reload();
        this.panel.add((Component)this.taggingPresets, "North");
        this.panel.add((Component)this.taggingPresetPanel, "Center");
        this.taggingPresets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TaggingPresetTester.this.reselect();
            }
        });
        this.reselect();
        JButton b = new JButton(I18n.tr((String)"Reload"));
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i = TaggingPresetTester.this.taggingPresets.getSelectedIndex();
                TaggingPresetTester.this.reload();
                TaggingPresetTester.this.taggingPresets.setSelectedIndex(i);
            }
        });
        this.panel.add((Component)b, "South");
        this.setContentPane(this.panel);
        this.setSize(300, 500);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            JFileChooser c = new JFileChooser();
            if (c.showOpenDialog(null) != 0) {
                return;
            }
            args = new String[]{c.getSelectedFile().getPath()};
        }
        TaggingPresetTester f = new TaggingPresetTester(args);
        f.setDefaultCloseOperation(3);
    }
}

