/*
 * Decompiled with CFR 0.152.
 */
package terracer;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import terracer.HouseNumberInputHandler;
import terracer.TerracerRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TerracerAction
extends JosmAction {
    public TerracerAction() {
        super(I18n.tr((String)"Terrace a building"), "terrace", I18n.tr((String)"Creates individual buildings from a long building."), Shortcut.registerShortcut((String)"tools:Terracer", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Terrace a building")}), (int)84, (int)3, (int)1), true);
    }

    public void actionPerformed(ActionEvent e) {
        Collection sel = Main.main.getCurrentDataSet().getSelected();
        boolean badSelect = false;
        if (sel.size() == 1) {
            OsmPrimitive prim = (OsmPrimitive)sel.iterator().next();
            if (prim instanceof Way) {
                Way way = (Way)prim;
                if (way.getNodesCount() >= 5 && way.isClosed()) {
                    String title = I18n.trn((String)"Change {0} object", (String)"Change {0} objects", (long)sel.size(), (Object[])new Object[]{sel.size()});
                    if (sel.size() == 0) {
                        title = I18n.tr((String)"Nothing selected!");
                    }
                    new HouseNumberInputHandler(this, way, title);
                } else {
                    badSelect = true;
                }
            } else {
                badSelect = true;
            }
        } else {
            badSelect = true;
        }
        if (badSelect) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Select a single, closed way of at least four nodes."));
        }
    }

    public void terraceBuilding(Way w, Integer segments, Integer from, Integer to, int step, String streetName) {
        int nb;
        if (to != null && from != null) {
            nb = 1 + (to - from) / step;
        } else if (segments != null) {
            nb = segments;
        } else {
            throw new TerracerRuntimeException("Could not determine segments from parameters, this is a bug. Parameters were: segments " + segments + " from " + from + " to " + to + " step " + step);
        }
        Pair<Way, Way> interp = this.findFrontAndBack(w);
        double frontLength = this.wayLength((Way)interp.a);
        double backLength = this.wayLength((Way)interp.b);
        Node[][] new_nodes = new Node[2][nb + 1];
        LinkedList<AddCommand> commands = new LinkedList<AddCommand>();
        LinkedList<Way> ways = new LinkedList<Way>();
        for (int i = 0; i <= nb; ++i) {
            new_nodes[0][i] = this.interpolateAlong((Way)interp.a, frontLength * (double)i / (double)nb);
            new_nodes[1][i] = this.interpolateAlong((Way)interp.b, backLength * (double)i / (double)nb);
            commands.add(new AddCommand((OsmPrimitive)new_nodes[0][i]));
            commands.add(new AddCommand((OsmPrimitive)new_nodes[1][i]));
        }
        Relation relatedStreet = new Relation();
        relatedStreet.put("type", "relatedStreet");
        if (streetName != null) {
            relatedStreet.put("name", streetName);
        }
        for (int i = 0; i < nb; ++i) {
            Way terr = new Way();
            terr.addNode(new_nodes[0][i]);
            terr.addNode(new_nodes[0][i + 1]);
            terr.addNode(new_nodes[1][i + 1]);
            terr.addNode(new_nodes[1][i]);
            terr.addNode(new_nodes[0][i]);
            if (from != null) {
                terr.put("addr:housenumber", "" + (from + i * step));
            }
            terr.put("building", "yes");
            if (streetName != null) {
                terr.put("addr:street", streetName);
            }
            relatedStreet.addMember(new RelationMember("house", (OsmPrimitive)terr));
            ways.add(terr);
            commands.add(new AddCommand((OsmPrimitive)terr));
        }
        commands.add(new AddCommand((OsmPrimitive)relatedStreet));
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Terrace"), commands));
        Main.main.getCurrentDataSet().setSelected(ways);
    }

    private Node interpolateAlong(Way w, double l) {
        Node n = null;
        for (Pair p : w.getNodePairs(false)) {
            double seg_length = ((Node)p.a).getCoor().greatCircleDistance(((Node)p.b).getCoor());
            if (l <= seg_length) {
                n = this.interpolateNode((Node)p.a, (Node)p.b, l / seg_length);
                break;
            }
            l -= seg_length;
        }
        if (n == null) {
            n = w.getNode(w.getNodesCount() - 1);
        }
        return n;
    }

    private double wayLength(Way w) {
        double length = 0.0;
        for (Pair p : w.getNodePairs(false)) {
            length += ((Node)p.a).getCoor().greatCircleDistance(((Node)p.b).getCoor());
        }
        return length;
    }

    private Pair<Way, Way> findFrontAndBack(Way w) {
        int i;
        int side2;
        double[] sideness = this.calculateSideness(w);
        int[] indexes = this.sortedIndexes(sideness);
        int side1 = indexes[0];
        if (Math.abs(side1 - (side2 = indexes[1])) < 2) {
            side2 = indexes[2];
        }
        if (Math.abs(side1 - side2) < 2) {
            side2 = indexes[3];
        }
        if (this.sideLength(w, side1) > this.sideLength(w, side1 + 1) && Math.abs(sideness[side1] - sideness[side1 + 1]) < 0.001) {
            ++side1;
            side2 = (side2 + 1) % (w.getNodesCount() - 1);
        }
        if (side1 > side2) {
            int tmp = side2;
            side2 = side1;
            side1 = tmp;
        }
        Way front = new Way();
        Way back = new Way();
        for (i = side2 + 1; i < w.getNodesCount() - 1; ++i) {
            front.addNode(w.getNode(i));
        }
        for (i = 0; i <= side1; ++i) {
            front.addNode(w.getNode(i));
        }
        for (i = side2; i > side1; --i) {
            back.addNode(w.getNode(i));
        }
        return new Pair((Object)front, (Object)back);
    }

    private double sideLength(Way w, int i) {
        Node a = w.getNode(i);
        Node b = w.getNode((i + 1) % (w.getNodesCount() - 1));
        return a.getCoor().greatCircleDistance(b.getCoor());
    }

    private int[] sortedIndexes(double[] a) {
        int length = a.length;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SortWithIndex
        implements Comparable<SortWithIndex> {
            public double x;
            public int i;

            public SortWithIndex(double a, int b) {
                this.x = a;
                this.i = b;
            }

            @Override
            public int compareTo(SortWithIndex o) {
                return Double.compare(this.x, o.x);
            }
        }
        ArrayList<SortWithIndex> sortable = new ArrayList<SortWithIndex>(length);
        for (int i = 0; i < length; ++i) {
            sortable.add(new SortWithIndex(a[i], i));
        }
        Collections.sort(sortable);
        int[] indexes = new int[length];
        for (int i = 0; i < length; ++i) {
            indexes[i] = ((SortWithIndex)sortable.get((int)i)).i;
        }
        return indexes;
    }

    private double[] calculateSideness(Way w) {
        int length = w.getNodesCount() - 1;
        double[] sideness = new double[length];
        sideness[0] = this.calculateSideness(w.getNode(length - 1), w.getNode(0), w.getNode(1), w.getNode(2));
        for (int i = 1; i < length - 1; ++i) {
            sideness[i] = this.calculateSideness(w.getNode(i - 1), w.getNode(i), w.getNode(i + 1), w.getNode(i + 2));
        }
        sideness[length - 1] = this.calculateSideness(w.getNode(length - 2), w.getNode(length - 1), w.getNode(length), w.getNode(1));
        return sideness;
    }

    private double calculateSideness(Node a, Node b, Node c, Node d) {
        double ndx = b.getCoor().getX() - a.getCoor().getX();
        double pdx = d.getCoor().getX() - c.getCoor().getX();
        double ndy = b.getCoor().getY() - a.getCoor().getY();
        double pdy = d.getCoor().getY() - c.getCoor().getY();
        return (ndx * pdx + ndy * pdy) / Math.sqrt((ndx * ndx + ndy * ndy) * (pdx * pdx + pdy * pdy));
    }

    private Node interpolateNode(Node a, Node b, double f) {
        Node n = new Node(this.interpolateLatLon(a, b, f));
        return n;
    }

    private LatLon interpolateLatLon(Node a, Node b, double f) {
        return new LatLon(a.getCoor().lat() * (1.0 - f) + b.getCoor().lat() * f, a.getCoor().lon() * (1.0 - f) + b.getCoor().lon() * f);
    }
}

