/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CacheControl;
import cadastre_fr.WMSLayer;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class WMSAdjustAction
extends MapMode
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private ArrayList<WMSLayer> modifiedLayers = new ArrayList();
    WMSLayer selectedLayer;
    private boolean rasterMoved;
    private EastNorth prevEastNorth;
    private Mode mode = null;

    public WMSAdjustAction(MapFrame mapFrame) {
        super(I18n.tr((String)"Adjust WMS"), "adjustxywms", I18n.tr((String)"Adjust the position of the WMS layer (raster images only)"), mapFrame, ImageProvider.getCursor((String)"normal", (String)"move"));
    }

    public void enterMode() {
        if (Main.map != null) {
            this.selectedLayer = null;
            WMSLayer possibleLayer = null;
            int cRasterLayers = 0;
            for (Layer l : Main.map.mapView.getAllLayers()) {
                if (!(l instanceof WMSLayer) || !((WMSLayer)l).isRaster()) continue;
                possibleLayer = (WMSLayer)l;
                ++cRasterLayers;
            }
            Layer activeLayer = Main.map.mapView.getActiveLayer();
            if (activeLayer instanceof WMSLayer && ((WMSLayer)activeLayer).isRaster()) {
                this.selectedLayer = (WMSLayer)activeLayer;
            } else if (cRasterLayers == 1) {
                this.selectedLayer = possibleLayer;
            }
            if (this.selectedLayer != null) {
                super.enterMode();
                Main.map.mapView.addMouseListener((MouseListener)this);
                Main.map.mapView.addMouseMotionListener((MouseMotionListener)this);
                this.rasterMoved = false;
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"This mode works only if active layer is\na cadastre \"plan image\" (raster image)"));
            }
        }
    }

    public void exitMode() {
        int reply;
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this);
        if (this.rasterMoved && CacheControl.cacheEnabled && (reply = JOptionPane.showConfirmDialog(null, "Save the changes in cache ?", "Update cache", 0)) == 0) {
            this.saveModifiedLayers();
        }
        this.modifiedLayers.clear();
        this.selectedLayer = null;
    }

    public void mousePressed(MouseEvent e) {
        boolean shift;
        if (e.getButton() != 1) {
            return;
        }
        boolean ctrl = (e.getModifiers() & 2) != 0;
        boolean bl = shift = (e.getModifiers() & 1) != 0;
        this.mode = shift ? Mode.moveZ : (ctrl ? Mode.rotate : Mode.moveXY);
        this.rasterMoved = true;
        this.prevEastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
        Main.map.mapView.setCursor(Cursor.getPredefinedCursor(13));
    }

    public void mouseDragged(MouseEvent e) {
        EastNorth newEastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
        if (this.mode == Mode.moveXY) {
            this.displace(this.prevEastNorth, newEastNorth);
        } else if (this.mode == Mode.moveZ) {
            this.resize(newEastNorth);
        } else if (this.mode == Mode.rotate) {
            this.rotate(this.prevEastNorth, newEastNorth);
        }
        if (!this.modifiedLayers.contains(this.selectedLayer)) {
            this.modifiedLayers.add(this.selectedLayer);
        }
        Main.map.mapView.repaint();
        this.prevEastNorth = newEastNorth;
    }

    private void displace(EastNorth start, EastNorth end) {
        this.selectedLayer.displace(end.east() - start.east(), end.north() - start.north());
    }

    private void resize(EastNorth newEastNorth) {
        EastNorth center = this.selectedLayer.getRasterCenter();
        double dPrev = this.prevEastNorth.distance(center.east(), center.north());
        double dNew = newEastNorth.distance(center.east(), center.north());
        this.selectedLayer.resize(center, dNew / dPrev);
    }

    private void rotate(EastNorth start, EastNorth end) {
        EastNorth pivot = this.selectedLayer.getRasterCenter();
        double startAngle = Math.atan2(start.east() - pivot.east(), start.north() - pivot.north());
        double endAngle = Math.atan2(end.east() - pivot.east(), end.north() - pivot.north());
        double rotationAngle = endAngle - startAngle;
        this.selectedLayer.rotate(pivot, rotationAngle);
    }

    public void mouseReleased(MouseEvent e) {
        Main.map.mapView.setCursor(Cursor.getDefaultCursor());
        this.prevEastNorth = null;
        this.mode = null;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    private void saveModifiedLayers() {
        for (WMSLayer wmsLayer : this.modifiedLayers) {
            wmsLayer.saveNewCache();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        moveXY,
        moveZ,
        rotate;

    }
}

