/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CacheControl;
import cadastre_fr.CadastreGrabber;
import cadastre_fr.CadastrePlugin;
import cadastre_fr.DuplicateLayerException;
import cadastre_fr.WMSLayer;
import java.io.IOException;
import java.util.concurrent.Future;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.tools.I18n;

public class DownloadWMSPlanImage {
    private Future<Task> task = null;
    private WMSLayer wmsLayer;
    private Bounds bounds;
    private boolean dontGeoreference = false;

    public void download(WMSLayer wmsLayer) {
        MapView mv = Main.map.mapView;
        Bounds bounds = new Bounds(mv.getLatLon(0, mv.getHeight()), mv.getLatLon(mv.getWidth(), 0));
        Task t = new Task(wmsLayer, bounds);
        this.wmsLayer = wmsLayer;
        this.bounds = bounds;
        this.task = Main.worker.submit((Runnable)((Object)t), t);
    }

    public boolean waitFinished() {
        if (this.task != null) {
            try {
                this.task.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.dontGeoreference;
    }

    private class Task
    extends PleaseWaitRunnable {
        private CadastreGrabber grabber;

        public Task(WMSLayer wmsLayer, Bounds bounds) {
            super(I18n.tr((String)"Downloading {0}", (Object[])new Object[]{wmsLayer.getName()}));
            this.grabber = CadastrePlugin.cadastreGrabber;
        }

        public void realRun() throws IOException {
            this.progressMonitor.indeterminateSubTask(I18n.tr((String)"Contacting cadastre WMS ..."));
            try {
                if (this.grabber.getWmsInterface().retrieveInterface(DownloadWMSPlanImage.this.wmsLayer)) {
                    if (!((DownloadWMSPlanImage)DownloadWMSPlanImage.this).wmsLayer.images.isEmpty()) {
                        JOptionPane pane = new JOptionPane(I18n.tr((String)"Image already loaded"), 1);
                        JDialog dialog = pane.createDialog(Main.parent, "");
                        CadastrePlugin.prepareDialog(dialog);
                        dialog.setVisible(true);
                        DownloadWMSPlanImage.this.dontGeoreference = true;
                    } else if (!this.grabber.getWmsInterface().downloadCancelled) {
                        if (CacheControl.cacheEnabled && DownloadWMSPlanImage.this.wmsLayer.getCacheControl().loadCacheIfExist()) {
                            DownloadWMSPlanImage.this.dontGeoreference = true;
                            Main.map.mapView.repaint();
                            return;
                        }
                        if (DownloadWMSPlanImage.this.wmsLayer.isRaster()) {
                            this.grabber.getWmsInterface().retrieveCommuneBBox(DownloadWMSPlanImage.this.wmsLayer);
                            DownloadWMSPlanImage.this.wmsLayer.setRasterBounds(DownloadWMSPlanImage.this.bounds);
                            DownloadWMSPlanImage.this.wmsLayer.grab(this.grabber, DownloadWMSPlanImage.this.bounds);
                            if (this.grabber.getWmsInterface().downloadCancelled) {
                                ((DownloadWMSPlanImage)DownloadWMSPlanImage.this).wmsLayer.images.clear();
                                Main.map.mapView.repaint();
                            } else {
                                DownloadWMSPlanImage.this.wmsLayer.joinRasterImages();
                            }
                        } else {
                            JOptionPane pane = new JOptionPane(I18n.tr((String)"Municipality vectorized !\nUse the normal Cadastre Grab menu."), 1);
                            JDialog dialog = pane.createDialog(Main.parent, "");
                            CadastrePlugin.prepareDialog(dialog);
                            dialog.setVisible(true);
                        }
                    }
                }
            }
            catch (DuplicateLayerException e) {
                System.err.println("removed a duplicated layer");
            }
        }

        protected void cancel() {
            this.grabber.getWmsInterface().cancel();
            DownloadWMSPlanImage.this.dontGeoreference = true;
        }

        protected void finish() {
        }
    }
}

