/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.GeorefImage;
import cadastre_fr.SimplifyWay;
import cadastre_fr.WMSLayer;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Buildings
extends MapMode
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    GeorefImage selectedImage;
    WMSLayer selectedLayer;
    private EastNorth clickedEastNorth;
    private ArrayList<Pixel> listPixels = new ArrayList();
    private static final int cMaxnode = 10000;
    private int[] dirslat;
    private int[] dirslon;
    private int green;

    public Buildings(MapFrame mapFrame) {
        super(I18n.tr((String)"Adjust WMS"), "buildings", I18n.tr((String)"Extract building on click (vector images only)"), mapFrame, ImageProvider.getCursor((String)"normal", (String)"move"));
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        this.dirslat = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[7] = 1;
        this.dirslon = nArray2;
        this.green = Color.GREEN.getRGB();
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)this);
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)this);
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        this.selectedImage = null;
        for (Layer layer : Main.map.mapView.getAllLayers()) {
            if (!layer.isVisible() || !(layer instanceof WMSLayer) || ((WMSLayer)layer).isRaster()) continue;
            this.clickedEastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
            this.selectedLayer = (WMSLayer)layer;
            this.selectedImage = this.selectedLayer.findImage(this.clickedEastNorth);
        }
        if (this.selectedImage != null) {
            int x = (int)((this.clickedEastNorth.east() - this.selectedImage.min.east()) * this.selectedImage.getPixelPerEast());
            int y = this.selectedImage.image.getHeight() - (int)((this.clickedEastNorth.north() - this.selectedImage.min.north()) * this.selectedImage.getPixelPerNorth());
            int rgb = this.selectedImage.image.getRGB(x, y);
            System.out.println("image found, x=" + x + ", y=" + y + ", RGB=" + rgb);
            if (this.isBuildingColor(rgb) && this.traceBuilding(x, y) && this.listPixels.size() > 3) {
                DataSet buildingDataSet = new DataSet();
                Way wayToAdd = new Way();
                Way way2 = new Way();
                double pPE = this.listPixels.get((int)0).image.getPixelPerEast();
                double pPN = this.listPixels.get((int)0).image.getPixelPerNorth();
                int i = 0;
                while (i < this.listPixels.size()) {
                    EastNorth en = new EastNorth(this.listPixels.get((int)i).image.min.east() + ((double)this.listPixels.get((int)i).x + 0.5) / pPE, this.listPixels.get((int)i).image.max.north() - ((double)this.listPixels.get((int)i).y + 0.5) / pPN);
                    Node nodeToAdd = new Node(Main.proj.eastNorth2latlon(en));
                    wayToAdd.addNode(nodeToAdd);
                    buildingDataSet.addPrimitive((OsmPrimitive)nodeToAdd);
                    ++i;
                }
                wayToAdd.addNode(wayToAdd.getNode(0));
                new SimplifyWay().simplifyWay(wayToAdd, buildingDataSet, 0.2);
                i = 1;
                while (i < wayToAdd.getNodesCount()) {
                    way2.addNode(wayToAdd.getNode(i));
                    ++i;
                }
                way2.addNode(way2.getNode(0));
                new SimplifyWay().simplifyWay(way2, buildingDataSet, 0.2);
                buildingDataSet.addPrimitive((OsmPrimitive)way2);
                LinkedList<AddCommand> cmds = new LinkedList<AddCommand>();
                for (Node node : buildingDataSet.getNodes()) {
                    if (node.isDeleted()) continue;
                    cmds.add(new AddCommand((OsmPrimitive)node));
                }
                for (Way way : buildingDataSet.getWays()) {
                    if (way.isDeleted()) continue;
                    cmds.add(new AddCommand((OsmPrimitive)way));
                }
                Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Create building"), cmds));
                Main.map.repaint();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    private boolean isBuildingColor(int rgb) {
        int cBuilingFootColor = -13261;
        int cBuildingRoofColor = -6759;
        return rgb == cBuilingFootColor || rgb == cBuildingRoofColor || rgb == -10661 || rgb == -8060 || rgb == -1558 || rgb == -4159 || rgb == -5459 || rgb == -2858 || rgb == -65536;
    }

    private boolean traceBuilding(int x, int y) {
        int startY = 0;
        int startX = x;
        while (y > 0) {
            int rgb;
            if (this.isBuildingColor(rgb = this.selectedImage.image.getRGB(x, --y))) continue;
            startY = ++y;
            break;
        }
        if (startY == 0) {
            System.out.println("border not found");
            return false;
        }
        System.out.println("start at x=" + startX + ", y=" + startY);
        this.listPixels.clear();
        this.addPixel(this.listPixels, this.selectedImage, x, y, 0);
        int test_x = 0;
        int test_y = 0;
        int new_dir = 0;
        int last_dir = 4;
        int i = 0;
        while (i < 10000) {
            int d = 1;
            while (d <= this.dirslat.length) {
                new_dir = (last_dir + d + 4) % 8;
                test_x = x + this.dirslon[new_dir];
                test_y = y + this.dirslat[new_dir];
                if (test_x < 0 || test_x > this.selectedImage.image.getWidth() || test_y < 0 || test_y > this.selectedImage.image.getHeight()) {
                    System.out.println("Outside image");
                    break;
                }
                try {
                    int test_rgb = this.selectedImage.image.getRGB(test_x, test_y);
                    if (this.isBuildingColor(test_rgb)) {
                        System.out.println("building color at " + x + "," + y + " new_dir=" + new_dir);
                        break;
                    }
                }
                catch (Exception e) {
                    System.out.println("Exception test_x, test_y:" + test_x + "," + test_y);
                }
                if (d == this.dirslat.length - 1) {
                    System.out.println("Got stuck");
                    int e = 0;
                    while (e < this.dirslat.length) {
                        test_x = x + this.dirslon[e];
                        test_y = y + this.dirslat[e];
                        System.out.println("analyse:x=" + test_x + ",y=" + y + ",_e=" + e + "; " + this.selectedImage.image.getRGB(test_x, test_y));
                        ++e;
                    }
                    return false;
                }
                ++d;
            }
            if (last_dir == new_dir) {
                this.listPixels.remove(this.listPixels.size() - 1);
            }
            last_dir = new_dir;
            x = test_x;
            y = test_y;
            if (x == startX && y == startY) {
                System.out.println("loop closed, exit");
                break;
            }
            this.addPixel(this.listPixels, this.selectedImage, x, y, new_dir);
            this.selectedImage.image.setRGB(x, y, this.green);
            ++i;
        }
        System.out.println("list size=" + this.listPixels.size());
        return true;
    }

    private void addPixel(ArrayList<Pixel> listPixels, GeorefImage image, int x, int y, int angle) {
        int s = listPixels.size();
        int delta_angle = 0;
        if (s > 1) {
            delta_angle = Math.abs(angle - listPixels.get((int)(s - 1)).angle);
        }
        if (delta_angle > 4) {
            delta_angle = 8 - delta_angle;
        }
        Pixel px = new Pixel(image, x, y, angle, delta_angle);
        listPixels.add(px);
    }

    class Pixel {
        public int x;
        public int y;
        public int angle;
        public int delta_angle;
        public GeorefImage image;

        Pixel(GeorefImage image, int x, int y, int angle, int delta_angle) {
            this.x = x;
            this.y = y;
            this.angle = angle;
            this.delta_angle = delta_angle;
            this.image = image;
        }
    }
}

