/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CacheControl;
import cadastre_fr.CadastrePlugin;
import cadastre_fr.Scale;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class CadastrePreferenceSetting
implements PreferenceSetting {
    static final int TRANS_MIN = 1;
    static final int TRANS_MAX = 10;
    private JSlider sliderTrans = new JSlider(0, 1, 10, 10);
    private JTextField sourcing = new JTextField(20);
    private JCheckBox alterColors = new JCheckBox(I18n.tr((String)"Replace original background by JOSM background color."));
    private JCheckBox reversGrey = new JCheckBox(I18n.tr((String)"Reverse grey colors (for black backgrounds)."));
    private JCheckBox transparency = new JCheckBox(I18n.tr((String)"Set background transparent."));
    private JCheckBox drawBoundaries = new JCheckBox(I18n.tr((String)"Draw boundaries of downloaded data."));
    private JCheckBox disableImageCropping = new JCheckBox(I18n.tr((String)"Disable image cropping during georeferencing."));
    private JRadioButton grabMultiplier1 = new JRadioButton("", true);
    private JRadioButton grabMultiplier2 = new JRadioButton("", true);
    private JRadioButton grabMultiplier3 = new JRadioButton("", true);
    private JRadioButton grabMultiplier4 = new JRadioButton("", true);
    private JRadioButton crosspiece1 = new JRadioButton("off");
    private JRadioButton crosspiece2 = new JRadioButton("50m");
    private JRadioButton crosspiece3 = new JRadioButton("100m");
    static final int DEFAULT_SQUARE_SIZE = 100;
    private JTextField grabMultiplier4Size = new JTextField(5);
    private JCheckBox enableCache = new JCheckBox(I18n.tr((String)"Enable automatic caching."));
    static final int DEFAULT_CACHE_SIZE = 500;
    JLabel jLabelCacheSize = new JLabel(I18n.tr((String)"Max. cache size (in MB)"));
    private JTextField cacheSize = new JTextField(20);
    static final String DEFAULT_RASTER_DIVIDER = "5";
    private JTextField rasterDivider = new JTextField(10);
    static final int DEFAULT_CROSSPIECES = 0;

    public void addGui(PreferenceDialog gui) {
        String description = I18n.tr((String)"A special handler of the French cadastre wms at www.cadastre.gouv.fr<BR><BR>Please read the Terms and Conditions of Use here (in French): <br><a href=\"http://www.cadastre.gouv.fr/scpc/html/CU_01_ConditionsGenerales_fr.html\"> http://www.cadastre.gouv.fr/scpc/html/CU_01_ConditionsGenerales_fr.html</a> <BR>before any upload of data created by this plugin.");
        JPanel cadastrewms = gui.createPreferenceTab("cadastrewms.gif", I18n.tr((String)"French cadastre WMS"), description);
        this.sourcing.setText(CadastrePlugin.source);
        this.sourcing.setToolTipText(I18n.tr((String)"<html>Value of key \"source\" when autosourcing is enabled</html>"));
        JLabel jLabelSource = new JLabel(I18n.tr((String)"Source"));
        cadastrewms.add((Component)jLabelSource, GBC.eop().insets(0, 0, 0, 0));
        cadastrewms.add((Component)this.sourcing, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.alterColors.setSelected(Main.pref.getBoolean("cadastrewms.alterColors", false));
        this.alterColors.setToolTipText(I18n.tr((String)"Replace the original white background by the backgound color defined in JOSM preferences."));
        cadastrewms.add((Component)this.alterColors, GBC.eop().insets(0, 0, 0, 0));
        this.reversGrey.setSelected(Main.pref.getBoolean("cadastrewms.invertGrey", false));
        this.reversGrey.setToolTipText(I18n.tr((String)"Invert the original black and white colors (and all intermediate greys). Useful for texts on dark backgrounds."));
        cadastrewms.add((Component)this.reversGrey, GBC.eop().insets(0, 0, 0, 0));
        this.transparency.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CadastrePreferenceSetting.this.sliderTrans.setEnabled(CadastrePreferenceSetting.this.transparency.isSelected());
            }
        });
        this.transparency.setSelected(Main.pref.getBoolean("cadastrewms.backgroundTransparent", false));
        this.transparency.setToolTipText(I18n.tr((String)"Allows multiple layers stacking"));
        cadastrewms.add((Component)this.transparency, GBC.eop().insets(0, 0, 0, 0));
        this.sliderTrans.setSnapToTicks(true);
        this.sliderTrans.setToolTipText(I18n.tr((String)"Set WMS layers transparency. Right is opaque, left is transparent."));
        this.sliderTrans.setMajorTickSpacing(10);
        this.sliderTrans.setMinorTickSpacing(1);
        this.sliderTrans.setValue((int)(Float.parseFloat(Main.pref.get("cadastrewms.brightness", "1.0f")) * 10.0f));
        this.sliderTrans.setPaintTicks(true);
        this.sliderTrans.setPaintLabels(false);
        this.sliderTrans.setEnabled(this.transparency.isSelected());
        cadastrewms.add((Component)this.sliderTrans, GBC.eol().fill(2).insets(20, 0, 250, 0));
        this.drawBoundaries.setSelected(Main.pref.getBoolean("cadastrewms.drawBoundaries", false));
        this.drawBoundaries.setToolTipText(I18n.tr((String)"Draw a rectangle around downloaded data from WMS server."));
        cadastrewms.add((Component)this.drawBoundaries, GBC.eop().insets(0, 0, 0, 5));
        cadastrewms.add((Component)new JSeparator(0), GBC.eol().fill(2));
        JLabel jLabelScale = new JLabel(I18n.tr((String)"Vector images grab multiplier:"));
        cadastrewms.add((Component)jLabelScale, GBC.std().insets(0, 5, 10, 0));
        ButtonGroup bgGrabMultiplier = new ButtonGroup();
        ActionListener multiplierActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton button = (AbstractButton)actionEvent.getSource();
                CadastrePreferenceSetting.this.grabMultiplier4Size.setEnabled(button == CadastrePreferenceSetting.this.grabMultiplier4);
            }
        };
        this.grabMultiplier1.setIcon(ImageProvider.get((String)"preferences", (String)"unsel_box_1"));
        this.grabMultiplier1.setSelectedIcon(ImageProvider.get((String)"preferences", (String)"sel_box_1"));
        this.grabMultiplier1.addActionListener(multiplierActionListener);
        this.grabMultiplier2.setIcon(ImageProvider.get((String)"preferences", (String)"unsel_box_2"));
        this.grabMultiplier2.setSelectedIcon(ImageProvider.get((String)"preferences", (String)"sel_box_2"));
        this.grabMultiplier2.addActionListener(multiplierActionListener);
        this.grabMultiplier2.setToolTipText(I18n.tr((String)"Grab smaller images (higher quality but use more memory)"));
        this.grabMultiplier3.setIcon(ImageProvider.get((String)"preferences", (String)"unsel_box_3"));
        this.grabMultiplier3.setSelectedIcon(ImageProvider.get((String)"preferences", (String)"sel_box_3"));
        this.grabMultiplier3.addActionListener(multiplierActionListener);
        this.grabMultiplier3.setToolTipText(I18n.tr((String)"Grab smaller images (higher quality but use more memory)"));
        this.grabMultiplier4.setIcon(ImageProvider.get((String)"preferences", (String)"unsel_box_4"));
        this.grabMultiplier4.setSelectedIcon(ImageProvider.get((String)"preferences", (String)"sel_box_4"));
        this.grabMultiplier4.addActionListener(multiplierActionListener);
        this.grabMultiplier4.setToolTipText(I18n.tr((String)"Fixed size square (default is 100m)"));
        bgGrabMultiplier.add(this.grabMultiplier1);
        bgGrabMultiplier.add(this.grabMultiplier2);
        bgGrabMultiplier.add(this.grabMultiplier3);
        bgGrabMultiplier.add(this.grabMultiplier4);
        String currentScale = Main.pref.get("cadastrewms.scale", "1");
        if (currentScale.equals(Scale.X1.value)) {
            this.grabMultiplier1.setSelected(true);
        }
        if (currentScale.equals(Scale.X2.value)) {
            this.grabMultiplier2.setSelected(true);
        }
        if (currentScale.equals(Scale.X3.value)) {
            this.grabMultiplier3.setSelected(true);
        }
        if (currentScale.equals(Scale.SQUARE_100M.value)) {
            this.grabMultiplier4.setSelected(true);
        }
        cadastrewms.add((Component)this.grabMultiplier1, GBC.std().insets(5, 0, 5, 0));
        cadastrewms.add((Component)this.grabMultiplier2, GBC.std().insets(5, 0, 5, 0));
        cadastrewms.add((Component)this.grabMultiplier3, GBC.std().insets(5, 0, 5, 0));
        cadastrewms.add((Component)this.grabMultiplier4, GBC.std().insets(5, 0, 5, 0));
        int squareSize = this.getNumber("cadastrewms.squareSize", 100);
        this.grabMultiplier4Size.setText(String.valueOf(squareSize));
        this.grabMultiplier4Size.setToolTipText(I18n.tr((String)"Fixed size (from 25 to 1000 meters)"));
        this.grabMultiplier4Size.setEnabled(currentScale.equals(Scale.SQUARE_100M.value));
        cadastrewms.add((Component)this.grabMultiplier4Size, GBC.eol().fill(2).insets(5, 5, 0, 5));
        cadastrewms.add((Component)new JSeparator(0), GBC.eol().fill(2));
        String savedRasterDivider = Main.pref.get("cadastrewms.rasterDivider", DEFAULT_RASTER_DIVIDER);
        JLabel jLabelRasterDivider = new JLabel(I18n.tr((String)"Raster images grab multiplier:"));
        this.rasterDivider.setText(savedRasterDivider);
        this.rasterDivider.setToolTipText("Raster image grab division, from 1 to 12; 12 is very high definition");
        cadastrewms.add((Component)jLabelRasterDivider, GBC.std().insets(0, 5, 10, 0));
        cadastrewms.add((Component)this.rasterDivider, GBC.eol().fill(2).insets(5, 5, 200, 5));
        this.disableImageCropping.setSelected(Main.pref.getBoolean("cadastrewms.noImageCropping", false));
        this.disableImageCropping.setToolTipText(I18n.tr((String)"Disable image cropping during georeferencing."));
        cadastrewms.add((Component)this.disableImageCropping, GBC.eop().insets(0, 0, 0, 0));
        JLabel jLabelCrosspieces = new JLabel(I18n.tr((String)"Display crosspieces:"));
        cadastrewms.add((Component)jLabelCrosspieces, GBC.std().insets(0, 0, 10, 0));
        ButtonGroup bgCrosspieces = new ButtonGroup();
        int crosspieces = this.getNumber("cadastrewms.crosspieces", 0);
        if (crosspieces == 0) {
            this.crosspiece1.setSelected(true);
        }
        if (crosspieces == 1) {
            this.crosspiece2.setSelected(true);
        }
        if (crosspieces == 2) {
            this.crosspiece3.setSelected(true);
        }
        bgCrosspieces.add(this.crosspiece1);
        bgCrosspieces.add(this.crosspiece2);
        bgCrosspieces.add(this.crosspiece3);
        cadastrewms.add((Component)this.crosspiece1, GBC.std().insets(5, 0, 5, 0));
        cadastrewms.add((Component)this.crosspiece2, GBC.std().insets(5, 0, 5, 0));
        cadastrewms.add((Component)this.crosspiece3, GBC.eol().fill(2).insets(5, 5, 0, 5));
        cadastrewms.add((Component)new JSeparator(0), GBC.eol().fill(2));
        this.enableCache.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CadastrePreferenceSetting.this.jLabelCacheSize.setEnabled(CadastrePreferenceSetting.this.enableCache.isSelected());
                CadastrePreferenceSetting.this.cacheSize.setEnabled(CadastrePreferenceSetting.this.enableCache.isSelected());
            }
        });
        this.enableCache.setSelected(Main.pref.getBoolean("cadastrewms.enableCaching", true));
        this.enableCache.setToolTipText(I18n.tr((String)"Replace the original white background by the backgound color defined in JOSM preferences."));
        cadastrewms.add((Component)this.enableCache, GBC.eop().insets(0, 0, 0, 0));
        int size = this.getNumber("cadastrewms.cacheSize", 500);
        this.cacheSize.setText(String.valueOf(size));
        this.cacheSize.setToolTipText(I18n.tr((String)"Oldest files are automatically deleted when this size is exceeded"));
        cadastrewms.add((Component)this.jLabelCacheSize, GBC.std().insets(20, 0, 0, 0));
        cadastrewms.add((Component)this.cacheSize, GBC.eol().fill(2).insets(5, 5, 200, 5));
        cadastrewms.add(Box.createVerticalGlue(), GBC.eol().fill(3));
    }

    public boolean ok() {
        Main.pref.put("cadastrewms.source", this.sourcing.getText());
        CadastrePlugin.source = this.sourcing.getText();
        Main.pref.put("cadastrewms.alterColors", this.alterColors.isSelected());
        Main.pref.put("cadastrewms.invertGrey", this.reversGrey.isSelected());
        Main.pref.put("cadastrewms.backgroundTransparent", this.transparency.isSelected());
        Main.pref.put("cadastrewms.brightness", Float.toString((float)this.sliderTrans.getValue() / 10.0f));
        Main.pref.put("cadastrewms.drawBoundaries", this.drawBoundaries.isSelected());
        if (this.grabMultiplier1.isSelected()) {
            Main.pref.put("cadastrewms.scale", Scale.X1.toString());
        } else if (this.grabMultiplier2.isSelected()) {
            Main.pref.put("cadastrewms.scale", Scale.X2.toString());
        } else if (this.grabMultiplier3.isSelected()) {
            Main.pref.put("cadastrewms.scale", Scale.X3.toString());
        } else {
            Main.pref.put("cadastrewms.scale", Scale.SQUARE_100M.toString());
            try {
                int squareSize = Integer.parseInt(this.grabMultiplier4Size.getText());
                if (squareSize >= 25 && squareSize <= 1000) {
                    Main.pref.put("cadastrewms.squareSize", this.grabMultiplier4Size.getText());
                }
            }
            catch (NumberFormatException squareSize) {
                // empty catch block
            }
        }
        try {
            int i = Integer.parseInt(this.rasterDivider.getText());
            if (i > 0 && i < 13) {
                Main.pref.put("cadastrewms.rasterDivider", String.valueOf(i));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Main.pref.put("cadastrewms.noImageCropping", this.disableImageCropping.isSelected());
        if (this.crosspiece1.isSelected()) {
            Main.pref.put("cadastrewms.crosspieces", "0");
        } else if (this.crosspiece2.isSelected()) {
            Main.pref.put("cadastrewms.crosspieces", "1");
        } else if (this.crosspiece3.isSelected()) {
            Main.pref.put("cadastrewms.crosspieces", "2");
        }
        Main.pref.put("cadastrewms.enableCaching", this.enableCache.isSelected());
        try {
            CacheControl.cacheSize = Integer.parseInt(this.cacheSize.getText());
            Main.pref.put("cadastrewms.cacheSize", String.valueOf(CacheControl.cacheSize));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        CacheControl.cacheEnabled = this.enableCache.isSelected();
        CadastrePlugin.refreshConfiguration();
        CadastrePlugin.refreshMenu();
        return false;
    }

    private int getNumber(String pref_parameter, int def_value) {
        try {
            return Integer.parseInt(Main.pref.get(pref_parameter, String.valueOf(def_value)));
        }
        catch (NumberFormatException e) {
            return def_value;
        }
    }
}

