/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastrePlugin;
import cadastre_fr.DuplicateLayerException;
import cadastre_fr.EastNorthBound;
import cadastre_fr.WMSLayer;
import java.awt.GridBagLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class CadastreInterface {
    public boolean downloadCancelled = false;
    public HttpURLConnection urlConn = null;
    private String cookie;
    private String interfaceRef = null;
    private String lastWMSLayerName = null;
    private URL searchFormURL;
    private Vector<String> listOfCommunes = new Vector();
    private Vector<String> listOfTA = new Vector();
    private Vector<PlanImage> listOfFeuilles = new Vector();
    final String baseURL = "http://www.cadastre.gouv.fr";
    final String cImageFormat = "Cette commune est au format ";
    final String cCommuneListStart = "<select name=\"codeCommune\"";
    final String cCommuneListEnd = "</select>";
    final String c0ptionListStart = "<option value=\"";
    final String cOptionListEnd = "</option>";
    final String cBBoxCommunStart = "new GeoBox(";
    final String cBBoxCommunEnd = ")";
    final String cInterfaceVector = "afficherCarteCommune.do";
    final String cInterfaceRasterTA = "afficherCarteTa.do";
    final String cInterfaceRasterFeuille = "afficherCarteFeuille.do";
    final String cImageLinkStart = "title=\"image\"><a href=\"#\" onClick=\"popup('afficherCarteFeuille.do?f=";
    final String cImageNameStart = ">Feuille ";

    public boolean retrieveInterface(WMSLayer wmsLayer) throws DuplicateLayerException {
        if (wmsLayer.getName().equals("")) {
            return false;
        }
        this.downloadCancelled = false;
        try {
            if (this.cookie == null || !wmsLayer.getName().equals(this.lastWMSLayerName)) {
                this.getCookie();
                this.getInterface(wmsLayer);
                this.lastWMSLayerName = wmsLayer.getName();
            }
            this.openInterface();
        }
        catch (IOException e) {
            JOptionPane pane = new JOptionPane(I18n.tr((String)"Town/city {0} not found or not available\nor action canceled", (Object[])new Object[]{wmsLayer.getLocation()}), 1);
            JDialog dialog = pane.createDialog(Main.parent, I18n.tr((String)"Select commune"));
            CadastrePlugin.prepareDialog(dialog);
            dialog.setVisible(true);
            return false;
        }
        return true;
    }

    private void getCookie() throws IOException {
        try {
            this.searchFormURL = new URL("http://www.cadastre.gouv.fr/scpc/accueil.do");
            this.urlConn = (HttpURLConnection)this.searchFormURL.openConnection();
            this.urlConn.setRequestMethod("GET");
            this.urlConn.connect();
            if (this.urlConn.getResponseCode() != 200) {
                throw new IOException("Cannot get Cadastre cookie.");
            }
            System.out.println("GET " + this.searchFormURL);
            BufferedReader in = new BufferedReader(new InputStreamReader(this.urlConn.getInputStream()));
            while (in.readLine() != null) {
            }
            String headerName = null;
            int i = 1;
            while ((headerName = this.urlConn.getHeaderFieldKey(i)) != null) {
                if (headerName.equals("Set-Cookie")) {
                    this.cookie = this.urlConn.getHeaderField(i);
                    this.cookie = this.cookie.substring(0, this.cookie.indexOf(";"));
                    System.out.println("Cookie=" + this.cookie);
                }
                ++i;
            }
        }
        catch (MalformedURLException e) {
            throw (IOException)new IOException("Illegal url.").initCause(e);
        }
    }

    public void resetCookie() {
        this.lastWMSLayerName = null;
    }

    public void resetCookieIfNewLayer(String newWMSLayerName) {
        if (!newWMSLayerName.equals(this.lastWMSLayerName)) {
            this.resetCookie();
        }
    }

    public void setCookie() {
        this.urlConn.setRequestProperty("Cookie", this.cookie);
    }

    public void setCookie(HttpURLConnection urlConn) {
        urlConn.setRequestProperty("Cookie", this.cookie);
    }

    private void getInterface(WMSLayer wmsLayer) throws IOException, DuplicateLayerException {
        this.interfaceRef = this.postForm(wmsLayer, "");
        if (this.interfaceRef == null) {
            if (!wmsLayer.getCodeCommune().equals("")) {
                this.interfaceRef = this.postForm(wmsLayer, wmsLayer.getCodeCommune());
            } else {
                int res;
                if (this.listOfCommunes.size() > 1) {
                    wmsLayer.setCodeCommune(this.selectCommuneDialog());
                    this.checkLayerDuplicates(wmsLayer);
                    this.interfaceRef = this.postForm(wmsLayer, wmsLayer.getCodeCommune());
                }
                if (this.listOfCommunes.size() == 1 && wmsLayer.isRaster() && (res = this.selectFeuilleDialog()) != -1) {
                    wmsLayer.setCodeCommune(this.listOfFeuilles.elementAt((int)res).name);
                    this.checkLayerDuplicates(wmsLayer);
                    this.interfaceRef = this.buildRasterFeuilleInterfaceRef(wmsLayer.getCodeCommune());
                }
            }
        }
        if (this.interfaceRef == null) {
            throw new IOException("Town/city " + wmsLayer.getLocation() + " not found.");
        }
    }

    private void openInterface() throws IOException {
        try {
            String lines = null;
            String ln = null;
            URL interfaceURL = new URL("http://www.cadastre.gouv.fr/scpc/" + this.interfaceRef);
            this.urlConn = (HttpURLConnection)interfaceURL.openConnection();
            this.urlConn.setRequestMethod("GET");
            this.setCookie();
            this.urlConn.connect();
            if (this.urlConn.getResponseCode() != 200) {
                throw new IOException("Cannot open Cadastre interface. GET response:" + this.urlConn.getResponseCode());
            }
            System.out.println("GET " + interfaceURL);
            BufferedReader in = new BufferedReader(new InputStreamReader(this.urlConn.getInputStream()));
            while ((ln = in.readLine()) != null) {
                lines = String.valueOf(lines) + ln;
            }
        }
        catch (MalformedURLException e) {
            throw (IOException)new IOException("CadastreGrabber: Illegal url.").initCause(e);
        }
    }

    private String postForm(WMSLayer wmsLayer, String codeCommune) throws IOException {
        block12: {
            int j;
            int i;
            String lines;
            block13: {
                String ln = null;
                lines = null;
                this.listOfCommunes.clear();
                this.listOfTA.clear();
                String content = "numerovoie=";
                content = String.valueOf(content) + "&indiceRepetition=";
                content = String.valueOf(content) + "&nomvoie=";
                content = String.valueOf(content) + "&lieuDit=";
                if (codeCommune == "") {
                    content = String.valueOf(content) + "&ville=" + new String(URLEncoder.encode(wmsLayer.getLocation(), "UTF-8"));
                    content = String.valueOf(content) + "&codePostal=";
                } else {
                    content = String.valueOf(content) + "&codeCommune=" + codeCommune;
                }
                content = String.valueOf(content) + "&codeDepartement=";
                content = String.valueOf(content) + "&nbResultatParPage=10";
                content = String.valueOf(content) + "&x=0&y=0";
                this.searchFormURL = new URL("http://www.cadastre.gouv.fr/scpc/rechercherPlan.do");
                this.urlConn = (HttpURLConnection)this.searchFormURL.openConnection();
                this.urlConn.setRequestMethod("POST");
                this.urlConn.setDoOutput(true);
                this.urlConn.setDoInput(true);
                this.setCookie();
                OutputStream wr = this.urlConn.getOutputStream();
                wr.write(content.getBytes());
                System.out.println("POST " + content);
                wr.flush();
                wr.close();
                BufferedReader rd = new BufferedReader(new InputStreamReader(this.urlConn.getInputStream()));
                while ((ln = rd.readLine()) != null) {
                    lines = String.valueOf(lines) + ln;
                }
                rd.close();
                this.urlConn.disconnect();
                if (lines == null) break block12;
                if (lines.indexOf("Cette commune est au format ") != -1) {
                    i = lines.indexOf("Cette commune est au format ");
                    j = lines.indexOf(".", i);
                    wmsLayer.setRaster(lines.substring(i + "Cette commune est au format ".length(), j).equals("image"));
                }
                if (!wmsLayer.isRaster() && lines.indexOf("afficherCarteCommune.do") != -1) {
                    lines = lines.substring(lines.indexOf("afficherCarteCommune.do"), lines.length());
                    lines = lines.substring(0, lines.indexOf("'"));
                    System.out.println("interface ref.:" + lines);
                    return lines;
                }
                if (!wmsLayer.isRaster() || lines.indexOf("afficherCarteTa.do") == -1) break block13;
                lines = this.getFeuillesList();
                if (!this.downloadCancelled) {
                    int res;
                    this.parseFeuillesList(lines);
                    if (this.listOfFeuilles.size() > 0 && (res = this.selectFeuilleDialog()) != -1) {
                        wmsLayer.setCodeCommune(this.listOfFeuilles.elementAt((int)res).name);
                        this.checkLayerDuplicates(wmsLayer);
                        this.interfaceRef = this.buildRasterFeuilleInterfaceRef(wmsLayer.getCodeCommune());
                        wmsLayer.setCodeCommune(this.listOfFeuilles.elementAt((int)res).ref);
                        lines = this.buildRasterFeuilleInterfaceRef(this.listOfFeuilles.elementAt((int)res).ref);
                        System.out.println("interface ref.:" + lines);
                        return lines;
                    }
                }
                return null;
            }
            try {
                if (lines.indexOf("<select name=\"codeCommune\"") != -1 && lines.indexOf("</select>") != -1) {
                    i = lines.indexOf("<select name=\"codeCommune\"");
                    j = lines.indexOf("</select>", i);
                    this.parseCommuneList(lines.substring(i, j));
                }
            }
            catch (MalformedURLException e) {
                throw (IOException)new IOException("Illegal url.").initCause(e);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void parseCommuneList(String input) {
        if (input.indexOf("<option value=\"") != -1) {
            while (input.indexOf("<option value=\"") != -1) {
                int i = input.indexOf("<option value=\"");
                int j = input.indexOf("</option>", i + "<option value=\"".length());
                int k = input.indexOf("\"", i + "<option value=\"".length());
                if (j != -1 && k > i + "<option value=\"".length()) {
                    String lov = new String(input.substring(i + "<option value=\"".length() - 1, j));
                    if (lov.indexOf(">") != -1) {
                        System.out.println("parse " + lov);
                        this.listOfCommunes.add(lov);
                    } else {
                        System.err.println("unable to parse commune string:" + lov);
                    }
                }
                input = input.substring(j + "</option>".length());
            }
        }
    }

    private String getFeuillesList() {
        String ln = null;
        String lines = null;
        HttpURLConnection urlConn2 = null;
        try {
            URL getAllImagesURL = new URL("http://www.cadastre.gouv.fr/scpc/listerFeuillesParcommune.do?keepVolatileSession=&offset=2000");
            urlConn2 = (HttpURLConnection)getAllImagesURL.openConnection();
            this.setCookie(urlConn2);
            urlConn2.connect();
            System.out.println("GET " + getAllImagesURL);
            BufferedReader rd = new BufferedReader(new InputStreamReader(urlConn2.getInputStream()));
            while ((ln = rd.readLine()) != null) {
                lines = String.valueOf(lines) + ln;
            }
            rd.close();
            urlConn2.disconnect();
        }
        catch (IOException e) {
            this.listOfFeuilles.clear();
            e.printStackTrace();
        }
        return lines;
    }

    private void parseFeuillesList(String input) {
        this.listOfFeuilles.clear();
        while (input.indexOf("title=\"image\"><a href=\"#\" onClick=\"popup('afficherCarteFeuille.do?f=") != -1) {
            input = input.substring(input.indexOf("title=\"image\"><a href=\"#\" onClick=\"popup('afficherCarteFeuille.do?f=") + "title=\"image\"><a href=\"#\" onClick=\"popup('afficherCarteFeuille.do?f=".length());
            String refFeuille = input.substring(0, input.indexOf("'"));
            String nameFeuille = input.substring(input.indexOf(">Feuille ") + ">Feuille ".length(), input.indexOf(" -"));
            this.listOfFeuilles.add(new PlanImage(nameFeuille, refFeuille));
        }
    }

    private String selectCommuneDialog() {
        JPanel p = new JPanel(new GridBagLayout());
        String[] communeList = new String[this.listOfCommunes.size() + 1];
        communeList[0] = I18n.tr((String)"Choose from...");
        int i = 0;
        while (i < this.listOfCommunes.size()) {
            communeList[i + 1] = this.listOfCommunes.elementAt(i).substring(this.listOfCommunes.elementAt(i).indexOf(">") + 1);
            ++i;
        }
        JComboBox<String> inputCommuneList = new JComboBox<String>(communeList);
        p.add(inputCommuneList, GBC.eol().fill(2).insets(10, 0, 0, 0));
        JOptionPane pane = new JOptionPane(p, 1, 2, null){
            private static final long serialVersionUID = 1L;
        };
        JDialog dialog = pane.createDialog(Main.parent, I18n.tr((String)"Select commune"));
        CadastrePlugin.prepareDialog(dialog);
        dialog.setVisible(true);
        if (!Integer.valueOf(0).equals(pane.getValue())) {
            return null;
        }
        String result = this.listOfCommunes.elementAt(inputCommuneList.getSelectedIndex() - 1);
        return result.substring(1, result.indexOf(">") - 2);
    }

    private int selectFeuilleDialog() {
        JPanel p = new JPanel(new GridBagLayout());
        Vector<String> ImageNames = new Vector<String>();
        for (PlanImage src : this.listOfFeuilles) {
            ImageNames.add(src.name);
        }
        JComboBox inputFeuilleList = new JComboBox(ImageNames);
        p.add(inputFeuilleList, GBC.eol().fill(2).insets(10, 0, 0, 0));
        JOptionPane pane = new JOptionPane(p, 1, 2, null);
        JDialog dialog = pane.createDialog(Main.parent, I18n.tr((String)"Select Feuille"));
        CadastrePlugin.prepareDialog(dialog);
        dialog.setVisible(true);
        if (!Integer.valueOf(0).equals(pane.getValue())) {
            return -1;
        }
        int result = inputFeuilleList.getSelectedIndex();
        return result;
    }

    private String buildRasterFeuilleInterfaceRef(String codeCommune) {
        return "afficherCarteFeuille.do?f=" + codeCommune;
    }

    public void retrieveCommuneBBox(WMSLayer wmsLayer) throws IOException {
        if (this.interfaceRef == null) {
            return;
        }
        String ln = null;
        String line = null;
        String content = "http://www.cadastre.gouv.fr/scpc/" + this.interfaceRef;
        content = String.valueOf(content) + "&dontSaveLastForward&keepVolatileSession=";
        this.searchFormURL = new URL(content);
        this.urlConn = (HttpURLConnection)this.searchFormURL.openConnection();
        this.urlConn.setRequestMethod("GET");
        this.setCookie();
        this.urlConn.connect();
        if (this.urlConn.getResponseCode() != 200) {
            throw new IOException("Cannot get Cadastre response.");
        }
        System.out.println("GET " + this.searchFormURL);
        BufferedReader in = new BufferedReader(new InputStreamReader(this.urlConn.getInputStream()));
        while ((ln = in.readLine()) != null) {
            line = String.valueOf(line) + ln;
        }
        in.close();
        this.urlConn.disconnect();
        this.parseBBoxCommune(wmsLayer, line);
        if (wmsLayer.isRaster() && !wmsLayer.isAlreadyGeoreferenced()) {
            this.parseGeoreferences(wmsLayer, line);
        }
    }

    private void parseBBoxCommune(WMSLayer wmsLayer, String input) {
        if (input.indexOf("new GeoBox(") != -1) {
            input = input.substring(input.indexOf("new GeoBox("));
            int i = input.indexOf(",");
            double minx = Double.parseDouble(input.substring("new GeoBox(".length(), i));
            int j = input.indexOf(",", i + 1);
            double miny = Double.parseDouble(input.substring(i + 1, j));
            int k = input.indexOf(",", j + 1);
            double maxx = Double.parseDouble(input.substring(j + 1, k));
            int l = input.indexOf(")", k + 1);
            double maxy = Double.parseDouble(input.substring(k + 1, l));
            wmsLayer.setCommuneBBox(new EastNorthBound(new EastNorth(minx, miny), new EastNorth(maxx, maxy)));
        }
    }

    private void parseGeoreferences(WMSLayer wmsLayer, String input) {
        if (input.lastIndexOf("new GeoBox(") != -1) {
            input = input.substring(input.lastIndexOf("new GeoBox("));
            input = input.substring(input.indexOf(")") + ")".length());
            int i = input.indexOf(",");
            int j = input.indexOf(",", i + 1);
            double angle = Double.parseDouble(input.substring(i + 1, j));
            int k = input.indexOf(",", j + 1);
            double scale_origin = Double.parseDouble(input.substring(j + 1, k));
            int l = input.indexOf(",", k + 1);
            double dpi = Double.parseDouble(input.substring(k + 1, l));
            int m = input.indexOf(",", l + 1);
            double fX = Double.parseDouble(input.substring(l + 1, m));
            int n = input.indexOf(",", m + 1);
            double fY = Double.parseDouble(input.substring(m + 1, n));
            int o = input.indexOf(",", n + 1);
            double X0 = Double.parseDouble(input.substring(n + 1, o));
            int p = input.indexOf(",", o + 1);
            double Y0 = Double.parseDouble(input.substring(o + 1, p));
            if (X0 != 0.0 && Y0 != 0.0) {
                wmsLayer.setAlreadyGeoreferenced(true);
                wmsLayer.fX = fX;
                wmsLayer.fY = fY;
                wmsLayer.angle = angle;
                wmsLayer.X0 = X0;
                wmsLayer.Y0 = Y0;
            }
            System.out.println("parse georef:" + angle + "," + scale_origin + "," + dpi + "," + fX + "," + fY + "," + X0 + "," + Y0);
        }
    }

    private void checkLayerDuplicates(WMSLayer wmsLayer) throws DuplicateLayerException {
        if (Main.map != null) {
            for (Layer l : Main.map.mapView.getAllLayers()) {
                if (!(l instanceof WMSLayer) || !l.getName().equals(wmsLayer.getName()) || l == wmsLayer) continue;
                System.out.println("Try to grab into a new layer when " + wmsLayer.getName() + " is already opened.");
                Main.map.mapView.removeLayer((Layer)wmsLayer);
                throw new DuplicateLayerException();
            }
        }
    }

    public void cancel() {
        if (this.urlConn != null) {
            this.urlConn.setConnectTimeout(1);
            this.urlConn.setReadTimeout(1);
        }
        this.downloadCancelled = true;
        this.lastWMSLayerName = null;
    }

    class PlanImage {
        String name;
        String ref;

        PlanImage(String name, String ref) {
            this.name = name;
            this.ref = ref;
        }
    }
}

