/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.addressdatabase;

import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.czechaddress.NotNullList;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ElementWithHouses;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ParentResolver;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Street;
import org.openstreetmap.josm.plugins.czechaddress.proposal.Proposal;
import org.openstreetmap.josm.plugins.czechaddress.proposal.ProposalFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class House
extends AddressElement {
    protected String cp = null;
    protected String co = null;

    public House(String cp, String co) {
        super("");
        if (cp != null) {
            this.cp = cp.toLowerCase();
        }
        if (co != null) {
            this.co = co.toLowerCase();
        }
        assert (co != null || cp != null);
        this.name = House.generateName(this.cp, this.co);
    }

    public String getCP() {
        return this.cp;
    }

    public String getCO() {
        return this.co;
    }

    public void setCP(String cp) {
        this.cp = cp;
        this.name = House.generateName(this.cp, this.co);
    }

    public void setCO(String co) {
        this.co = co;
        this.name = House.generateName(this.cp, this.co);
    }

    public static String generateName(String cp, String co) {
        if (co == null) {
            return cp;
        }
        if (cp == null) {
            return "?/" + co;
        }
        return cp + "/" + co;
    }

    @Override
    public String getName() {
        assert (this.parent != null) : "A house must always have a parent.";
        return this.parent.getName() + " " + this.name;
    }

    @Override
    public void setParent(AddressElement parent) {
        assert (parent instanceof ElementWithHouses);
        super.setParent(parent);
    }

    @Override
    public ElementWithHouses getParent() {
        assert (this.parent instanceof ElementWithHouses);
        return (ElementWithHouses)this.parent;
    }

    @Override
    protected int[] getFieldMatchList(OsmPrimitive prim) {
        int[] result = new int[]{0, 0, 0};
        if (!House.isMatchable(prim)) {
            return result;
        }
        result[0] = House.matchField(this.cp, prim.get("addr:conscriptionnumber"));
        result[2] = House.matchField(this.name, prim.get("addr:housenumber"));
        if (this.parent instanceof Street) {
            result[1] = Math.min(House.matchFieldAbbrev(this.parent.getName(), prim.get("addr:street")), House.matchField(this.co, prim.get("addr:streetnumber")));
        }
        return result;
    }

    @Override
    protected int[] getAdditionalFieldMatchList(OsmPrimitive prim) {
        int[] result = new int[]{0};
        if (!House.isMatchable(prim)) {
            return result;
        }
        ParentResolver resolver = new ParentResolver(this);
        result[0] = House.matchField(resolver.getIsIn(), prim.get("is_in"));
        return result;
    }

    @Override
    public List<Proposal> getDiff(OsmPrimitive prim) {
        AddressElement isInElem;
        NotNullList<Proposal> props = new NotNullList<Proposal>();
        ParentResolver resolver = new ParentResolver(this);
        props.add(ProposalFactory.getStringFieldDiff("addr:housenumber", prim.get("addr:housenumber"), this.name));
        props.add(ProposalFactory.getStringFieldDiff("addr:conscriptionnumber", prim.get("addr:conscriptionnumber"), this.getCP()));
        props.add(ProposalFactory.getStringFieldDiff("addr:streetnumber", prim.get("addr:streetnumber"), this.getCO()));
        props.add(ProposalFactory.getStringFieldDiff("addr:country", prim.get("addr:country"), "CZ"));
        if (resolver.parentStreet != null) {
            props.add(ProposalFactory.getStringFieldDiff("addr:street", prim.get("addr:street"), resolver.parentStreet.getName()));
        }
        if ((isInElem = this.parent) instanceof Street) {
            isInElem = this.parent.parent;
        }
        if (isInElem != null) {
            props.add(ProposalFactory.getStringFieldDiff("is_in", prim.get("is_in"), resolver.getIsIn()));
        }
        if (props.size() > 0) {
            props.add(ProposalFactory.getListFieldDiff("source:addr", prim.get("source:addr"), "mvcr:adresa"));
        }
        return props;
    }

    public static boolean isMatchable(OsmPrimitive prim) {
        for (String key : prim.keySet()) {
            if (!key.startsWith("addr:")) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(AddressElement o) {
        int val = super.compareTo(o);
        if (val != 0) {
            return val;
        }
        if (!(o instanceof House)) {
            return val;
        }
        House house = (House)o;
        if (this.co != null && house.co != null) {
            val = this.co.compareTo(house.co);
        }
        if (val != 0) {
            return val;
        }
        if (this.cp != null && house.cp != null) {
            val = this.cp.compareTo(house.cp);
        }
        return val;
    }
}

