/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import livegps.LiveGpsData;
import livegps.LiveGpsStatus;
import livegps.LiveGpsSuppressor;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.I18n;

public class LiveGpsAcquirer
implements Runnable {
    Socket gpsdSocket;
    BufferedReader gpsdReader;
    boolean connected = false;
    String gpsdHost = Main.pref.get("livegps.gpsd.host", "localhost");
    int gpsdPort = Main.pref.getInteger("livegps.gpsd.port", 2947);
    boolean shutdownFlag = false;
    private final List<PropertyChangeListener> propertyChangeListener = new ArrayList<PropertyChangeListener>();
    private PropertyChangeEvent lastStatusEvent;
    private PropertyChangeEvent lastDataEvent;
    private LiveGpsSuppressor suppressor = null;
    private Thread suppressorThread = null;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.propertyChangeListener.contains(listener)) {
            this.propertyChangeListener.add(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListener.contains(listener)) {
            this.propertyChangeListener.remove(listener);
        }
    }

    public void fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus status, String statusMessage) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "gpsstatus", null, new LiveGpsStatus(status, statusMessage));
        if (!event.equals(this.lastStatusEvent)) {
            this.firePropertyChangeEvent(event);
            this.lastStatusEvent = event;
        }
    }

    public void fireGpsDataChangeEvent(LiveGpsData oldData, LiveGpsData newData) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "gpsdata", oldData, newData);
        if (!event.equals(this.lastDataEvent) && this.checkSuppress()) {
            this.firePropertyChangeEvent(event);
            this.lastDataEvent = event;
        }
    }

    protected void firePropertyChangeEvent(PropertyChangeEvent event) {
        for (PropertyChangeListener listener : this.propertyChangeListener) {
            listener.propertyChange(event);
        }
    }

    public void run() {
        LiveGpsData oldGpsData = null;
        LiveGpsData gpsData = null;
        this.initSuppressor();
        this.shutdownFlag = false;
        while (!this.shutdownFlag) {
            double lat = 0.0;
            double lon = 0.0;
            float speed = 0.0f;
            float course = 0.0f;
            boolean haveFix = false;
            try {
                if (!this.connected) {
                    System.out.println("LiveGps tries to connect to gpsd");
                    this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.CONNECTING, I18n.tr((String)"Connecting"));
                    InetAddress[] addrs = InetAddress.getAllByName(this.gpsdHost);
                    for (int i = 0; i < addrs.length && this.gpsdSocket == null; ++i) {
                        try {
                            this.gpsdSocket = new Socket(addrs[i], this.gpsdPort);
                            break;
                        }
                        catch (Exception e) {
                            System.out.println("LiveGps: Could not open connection to gpsd: " + e);
                            this.gpsdSocket = null;
                            continue;
                        }
                    }
                    if (this.gpsdSocket != null) {
                        this.gpsdReader = new BufferedReader(new InputStreamReader(this.gpsdSocket.getInputStream()));
                        this.gpsdSocket.getOutputStream().write(new byte[]{119, 13, 10});
                        this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.CONNECTING, I18n.tr((String)"Connecting"));
                        this.connected = true;
                        System.out.println("LiveGps: Connected to gpsd");
                    }
                }
                if (this.connected) {
                    String line = this.gpsdReader.readLine();
                    if (line == null) break;
                    String[] words = line.split(",");
                    if (words.length == 0 || !words[0].equals("GPSD")) continue;
                    for (int i = 1; i < words.length; ++i) {
                        if (words[i].length() < 2 || words[i].charAt(1) != '=') continue;
                        char what = words[i].charAt(0);
                        String value = words[i].substring(2);
                        oldGpsData = gpsData;
                        gpsData = new LiveGpsData();
                        switch (what) {
                            case 'O': {
                                String[] status = value.split("\\s+");
                                if (status.length < 5) break;
                                lat = Double.parseDouble(status[3]);
                                lon = Double.parseDouble(status[4]);
                                try {
                                    speed = Float.parseFloat(status[9]);
                                    course = Float.parseFloat(status[8]);
                                }
                                catch (NumberFormatException nex) {
                                    // empty catch block
                                }
                                haveFix = true;
                                break;
                            }
                            case 'P': {
                                String[] pos = value.split("\\s+");
                                if (pos.length < 2) break;
                                lat = Double.parseDouble(pos[0]);
                                lon = Double.parseDouble(pos[1]);
                                speed = Float.NaN;
                                course = Float.NaN;
                                haveFix = true;
                            }
                        }
                        this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.CONNECTED, I18n.tr((String)"Connected"));
                        gpsData.setFix(haveFix);
                        if (!haveFix) continue;
                        gpsData.setLatLon(new LatLon(lat, lon));
                        gpsData.setSpeed(speed);
                        gpsData.setCourse(course);
                        this.fireGpsDataChangeEvent(oldGpsData, gpsData);
                    }
                    continue;
                }
                this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.DISCONNECTED, I18n.tr((String)"Not connected"));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignore) {
                }
            }
            catch (IOException iox) {
                this.connected = false;
                if (gpsData != null) {
                    gpsData.setFix(false);
                    this.fireGpsDataChangeEvent(oldGpsData, gpsData);
                }
                this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.CONNECTION_FAILED, I18n.tr((String)"Connection Failed"));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignore) {}
            }
        }
        this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.DISCONNECTED, I18n.tr((String)"Not connected"));
        if (this.gpsdSocket != null) {
            try {
                this.gpsdSocket.close();
                this.gpsdSocket = null;
                System.out.println("LiveGps: Disconnected from gpsd");
            }
            catch (Exception e) {
                System.out.println("LiveGps: Unable to close socket; reconnection may not be possible");
            }
        }
    }

    private void initSuppressor() {
        this.suppressor = new LiveGpsSuppressor();
        this.suppressorThread = new Thread(this.suppressor);
        this.suppressorThread.start();
    }

    public void shutdown() {
        this.suppressor.shutdown();
        this.suppressor = null;
        this.shutdownFlag = true;
    }

    private boolean checkSuppress() {
        if (this.suppressor != null) {
            return this.suppressor.isAllowUpdate();
        }
        return true;
    }
}

