/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastrePlugin;
import cadastre_fr.DownloadWMSVectorImage;
import cadastre_fr.WMSLayer;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.projection.Lambert;
import org.openstreetmap.josm.data.projection.LambertCC9Zones;
import org.openstreetmap.josm.data.projection.UTM_20N_France_DOM;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuActionNewLocation
extends JosmAction {
    private static final long serialVersionUID = 1L;

    public MenuActionNewLocation() {
        super(I18n.tr((String)"Change location"), "cadastre_small", I18n.tr((String)"Set a new location for the next request"), null, false);
    }

    public void actionPerformed(ActionEvent e) {
        WMSLayer wmsLayer = this.addNewLayer(new ArrayList<WMSLayer>());
        if (wmsLayer != null) {
            DownloadWMSVectorImage.download(wmsLayer);
        }
    }

    public WMSLayer addNewLayer(ArrayList<WMSLayer> existingLayers) {
        String location = "";
        String codeDepartement = "";
        String codeCommune = "";
        boolean resetCookie = false;
        JLabel labelSectionNewLocation = new JLabel(I18n.tr((String)"Add a new layer"));
        JPanel p = new JPanel(new GridBagLayout());
        JLabel labelLocation = new JLabel(I18n.tr((String)"Location"));
        final JTextField inputTown = new JTextField(Main.pref.get("cadastrewms.location"));
        inputTown.setToolTipText(I18n.tr((String)"<html>Enter the town,village or city name.<br>Use the syntax and punctuation known by www.cadastre.gouv.fr .</html>"));
        p.add((Component)labelSectionNewLocation, GBC.eol());
        p.add((Component)labelLocation, GBC.std().insets(10, 0, 0, 0));
        p.add((Component)inputTown, GBC.eol().fill(2).insets(5, 0, 0, 5));
        JOptionPane pane = new JOptionPane(p, 1, 2, null){
            private static final long serialVersionUID = 1L;

            public void selectInitialValue() {
                inputTown.requestFocusInWindow();
                inputTown.selectAll();
            }
        };
        pane.createDialog(Main.parent, I18n.tr((String)"Add new layer")).setVisible(true);
        if (!Integer.valueOf(0).equals(pane.getValue())) {
            return null;
        }
        WMSLayer wmsLayer = null;
        if (!inputTown.getText().equals("")) {
            location = inputTown.getText().toUpperCase();
            resetCookie = true;
            Main.pref.put("cadastrewms.location", location);
            Main.pref.put("cadastrewms.codeCommune", codeCommune);
            if (Main.map != null) {
                for (Layer l : Main.map.mapView.getAllLayers()) {
                    if (!(l instanceof WMSLayer) || !l.getName().equalsIgnoreCase(location + codeDepartement)) continue;
                    return null;
                }
            }
            int zone = -1;
            if (Main.proj instanceof LambertCC9Zones) {
                zone = ((LambertCC9Zones)Main.proj).getLayoutZone();
            } else if (Main.proj instanceof Lambert) {
                zone = ((Lambert)Main.proj).getLayoutZone();
            } else if (Main.proj instanceof UTM_20N_France_DOM) {
                zone = ((UTM_20N_France_DOM)Main.proj).getCurrentGeodesic();
            }
            wmsLayer = new WMSLayer(location, codeCommune, zone);
            Main.main.addLayer((Layer)wmsLayer);
            System.out.println("Add new layer with Location:" + inputTown.getText());
        } else if (existingLayers != null && existingLayers.size() > 0 && Main.map.mapView.getActiveLayer() instanceof WMSLayer) {
            wmsLayer = (WMSLayer)Main.map.mapView.getActiveLayer();
            resetCookie = true;
        }
        if (resetCookie) {
            CadastrePlugin.cadastreGrabber.getWmsInterface().resetCookieIfNewLayer(wmsLayer.getName());
        }
        return wmsLayer;
    }
}

