/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CacheControl;
import cadastre_fr.CadastreGrabber;
import cadastre_fr.CadastrePlugin;
import cadastre_fr.EastNorthBound;
import cadastre_fr.GeorefImage;
import cadastre_fr.MenuActionLoadFromCache;
import cadastre_fr.MenuActionSaveRasterAs;
import cadastre_fr.Scale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class WMSLayer
extends Layer
implements ImageObserver {
    Component[] component = null;
    private int lambertZone = -1;
    protected static final Icon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(CadastrePlugin.class.getResource("/images/cadastre_small.png")));
    protected Vector<GeorefImage> images = new Vector();
    protected final int serializeFormatVersion = 2;
    private ArrayList<EastNorthBound> dividedBbox = new ArrayList();
    private CacheControl cacheControl = null;
    private String location = "";
    private String codeCommune = "";
    public EastNorthBound communeBBox = new EastNorthBound(new EastNorth(0.0, 0.0), new EastNorth(0.0, 0.0));
    private boolean isRaster = false;
    private boolean isAlreadyGeoreferenced = false;
    public double X0;
    public double Y0;
    public double angle;
    public double fX;
    public double fY;
    private EastNorth rasterMin;
    private EastNorth rasterMax;
    private double rasterRatio;
    private JMenuItem saveAsPng;

    public WMSLayer() {
        this(I18n.tr((String)"Blank Layer"), "", -1);
    }

    public WMSLayer(String location, String codeCommune, int lambertZone) {
        super(WMSLayer.buildName(location, codeCommune));
        this.location = location;
        this.codeCommune = codeCommune;
        this.lambertZone = lambertZone;
        CadastrePlugin.pluginUsed = true;
    }

    private static String buildName(String location, String codeCommune) {
        String ret = new String(location.toUpperCase());
        if (codeCommune != null && !codeCommune.equals("")) {
            ret = ret + "(" + codeCommune + ")";
        }
        return ret;
    }

    private String rebuildName() {
        return WMSLayer.buildName(this.location.toUpperCase(), this.codeCommune);
    }

    public void grab(CadastreGrabber grabber, Bounds b) throws IOException {
        this.grab(grabber, b, true);
    }

    public void grab(CadastreGrabber grabber, Bounds b, boolean useFactor) throws IOException {
        if (useFactor) {
            if (this.isRaster) {
                b = new Bounds(Main.proj.eastNorth2latlon(this.rasterMin), Main.proj.eastNorth2latlon(this.rasterMax));
                this.divideBbox(b, Integer.parseInt(Main.pref.get("cadastrewms.rasterDivider", "5")));
            } else {
                this.divideBbox(b, Integer.parseInt(Main.pref.get("cadastrewms.scale", Scale.X1.toString())));
            }
        } else {
            this.divideBbox(b, 1);
        }
        for (EastNorthBound n : this.dividedBbox) {
            GeorefImage newImage;
            try {
                newImage = grabber.grab(this, n.min, n.max);
            }
            catch (IOException e) {
                System.out.println("Download action cancelled by user or server did not respond");
                break;
            }
            catch (OsmTransferException e) {
                System.out.println("OSM transfer failed");
                break;
            }
            if (grabber.getWmsInterface().downloadCancelled) {
                System.out.println("Download action cancelled by user");
                break;
            }
            if (CadastrePlugin.backgroundTransparent) {
                for (GeorefImage img : this.images) {
                    if (img.overlap(newImage)) {
                        img.withdraw(newImage);
                        continue;
                    }
                    newImage.withdraw(img);
                }
            }
            this.images.add(newImage);
            this.saveToCache(newImage);
            Main.map.mapView.repaint();
        }
    }

    private void divideBbox(Bounds b, int factor) {
        EastNorth lambertMin = Main.proj.latlon2eastNorth(b.getMin());
        EastNorth lambertMax = Main.proj.latlon2eastNorth(b.getMax());
        double minEast = lambertMin.east();
        double minNorth = lambertMin.north();
        double dEast = (lambertMax.east() - minEast) / (double)factor;
        double dNorth = (lambertMax.north() - minNorth) / (double)factor;
        this.dividedBbox.clear();
        if (factor < 4 || this.isRaster) {
            for (int xEast = 0; xEast < factor; ++xEast) {
                for (int xNorth = 0; xNorth < factor; ++xNorth) {
                    this.dividedBbox.add(new EastNorthBound(new EastNorth(minEast + (double)xEast * dEast, minNorth + (double)xNorth * dNorth), new EastNorth(minEast + (double)(xEast + 1) * dEast, minNorth + (double)(xNorth + 1) * dNorth)));
                }
            }
        } else {
            int cSquare = Integer.parseInt(Main.pref.get("cadastrewms.squareSize", "100"));
            minEast -= minEast % (double)cSquare;
            minNorth -= minNorth % (double)cSquare;
            int xEast = (int)minEast;
            while ((double)xEast < lambertMax.east()) {
                int xNorth = (int)minNorth;
                while ((double)xNorth < lambertMax.north()) {
                    this.dividedBbox.add(new EastNorthBound(new EastNorth((double)xEast, (double)xNorth), new EastNorth((double)(xEast + cSquare), (double)(xNorth + cSquare))));
                    xNorth += cSquare;
                }
                xEast += cSquare;
            }
        }
    }

    public Icon getIcon() {
        return icon;
    }

    public String getToolTipText() {
        String str = I18n.tr((String)"WMS layer ({0}), {1} tile(s) loaded", (Object[])new Object[]{this.getName(), this.images.size()});
        if (this.isRaster) {
            str = str + "\n" + I18n.tr((String)"Is not vectorized.");
            str = str + "\n" + I18n.tr((String)"Raster size: {0}", (Object[])new Object[]{this.communeBBox});
        } else {
            str = str + "\n" + I18n.tr((String)"Is vectorized.");
        }
        str = str + "\n" + I18n.tr((String)"Commune bbox: {0}", (Object[])new Object[]{this.communeBBox});
        return str;
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        WMSLayer wMSLayer = this;
        synchronized (wMSLayer) {
            for (GeorefImage img : this.images) {
                img.paint(g, (NavigatableComponent)mv, CadastrePlugin.backgroundTransparent, CadastrePlugin.transparency, CadastrePlugin.drawBoundaries);
            }
        }
        if (this.isRaster) {
            this.paintCrosspieces(g, mv);
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
        for (GeorefImage img : this.images) {
            v.visit(img.min);
            v.visit(img.max);
        }
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Component[] getMenuEntries() {
        this.saveAsPng = new JMenuItem((Action)((Object)new MenuActionSaveRasterAs(this)));
        this.saveAsPng.setEnabled(this.isRaster);
        this.component = new Component[]{new JMenuItem((Action)LayerListDialog.getInstance().createShowHideLayerAction((Layer)this)), new JMenuItem((Action)LayerListDialog.getInstance().createDeleteLayerAction((Layer)this)), new JMenuItem((Action)((Object)new MenuActionLoadFromCache())), this.saveAsPng, new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
        return this.component;
    }

    public GeorefImage findImage(EastNorth eastNorth) {
        for (int i = this.images.size() - 1; i >= 0; --i) {
            if (!this.images.get(i).contains(eastNorth)) continue;
            return this.images.get(i);
        }
        return null;
    }

    public boolean isOverlapping(Bounds bounds) {
        GeorefImage georefImage = new GeorefImage(new BufferedImage(1, 1, 1), Main.proj.latlon2eastNorth(bounds.getMin()), Main.proj.latlon2eastNorth(bounds.getMax()));
        for (GeorefImage img : this.images) {
            if (!img.overlap(georefImage)) continue;
            return true;
        }
        return false;
    }

    public void saveToCache(GeorefImage image) {
        if (CacheControl.cacheEnabled && !this.isRaster()) {
            this.getCacheControl().saveCache(image);
        }
    }

    public void saveNewCache() {
        if (CacheControl.cacheEnabled) {
            this.getCacheControl().deleteCacheFile();
            for (GeorefImage image : this.images) {
                this.getCacheControl().saveCache(image);
            }
        }
    }

    public CacheControl getCacheControl() {
        if (this.cacheControl == null) {
            this.cacheControl = new CacheControl(this);
        }
        return this.cacheControl;
    }

    public String eastNorth2raster(EastNorth min, EastNorth max) {
        double minX = (min.east() - this.rasterMin.east()) / this.rasterRatio;
        double minY = (min.north() - this.rasterMin.north()) / this.rasterRatio;
        double maxX = (max.east() - this.rasterMin.east()) / this.rasterRatio;
        double maxY = (max.north() - this.rasterMin.north()) / this.rasterRatio;
        return minX + "," + minY + "," + maxX + "," + maxY;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
        this.setName(this.rebuildName());
    }

    public String getCodeCommune() {
        return this.codeCommune;
    }

    public void setCodeCommune(String codeCommune) {
        this.codeCommune = codeCommune;
        this.setName(this.rebuildName());
    }

    public boolean isRaster() {
        return this.isRaster;
    }

    public void setRaster(boolean isRaster) {
        this.isRaster = isRaster;
        if (this.saveAsPng != null) {
            this.saveAsPng.setEnabled(isRaster);
        }
    }

    public boolean isAlreadyGeoreferenced() {
        return this.isAlreadyGeoreferenced;
    }

    public void setAlreadyGeoreferenced(boolean isAlreadyGeoreferenced) {
        this.isAlreadyGeoreferenced = isAlreadyGeoreferenced;
    }

    public void setRasterBounds(Bounds bounds) {
        EastNorth rasterCenter = Main.proj.latlon2eastNorth(bounds.getCenter());
        EastNorth eaMin = Main.proj.latlon2eastNorth(bounds.getMin());
        EastNorth eaMax = Main.proj.latlon2eastNorth(bounds.getMax());
        double rasterSizeX = this.communeBBox.max.getX() - this.communeBBox.min.getX();
        double rasterSizeY = this.communeBBox.max.getY() - this.communeBBox.min.getY();
        double ratio = rasterSizeY / rasterSizeX;
        this.rasterMin = new EastNorth(eaMin.getX(), rasterCenter.getY() - (eaMax.getX() - eaMin.getX()) * ratio / 2.0);
        this.rasterMax = new EastNorth(eaMax.getX(), rasterCenter.getY() + (eaMax.getX() - eaMin.getX()) * ratio / 2.0);
        this.rasterRatio = (this.rasterMax.getX() - this.rasterMin.getX()) / rasterSizeX;
    }

    public void write(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.serializeFormatVersion);
        oos.writeObject(this.location);
        oos.writeObject(this.codeCommune);
        oos.writeInt(this.lambertZone);
        oos.writeBoolean(this.isRaster);
        if (this.isRaster) {
            oos.writeDouble(this.rasterMin.getX());
            oos.writeDouble(this.rasterMin.getY());
            oos.writeDouble(this.rasterMax.getX());
            oos.writeDouble(this.rasterMax.getY());
            oos.writeDouble(this.rasterRatio);
        }
        oos.writeDouble(this.communeBBox.min.getX());
        oos.writeDouble(this.communeBBox.min.getY());
        oos.writeDouble(this.communeBBox.max.getX());
        oos.writeDouble(this.communeBBox.max.getY());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read(ObjectInputStream ois, int currentLambertZone) throws IOException, ClassNotFoundException {
        int sfv = ois.readInt();
        if (sfv != this.serializeFormatVersion) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Unsupported cache file version; found {0}, expected {1}\nCreate a new one.", (Object[])new Object[]{sfv, this.serializeFormatVersion}), I18n.tr((String)"Cache Format Error"), 0);
            return false;
        }
        this.setLocation((String)ois.readObject());
        this.setCodeCommune((String)ois.readObject());
        this.lambertZone = ois.readInt();
        this.setRaster(ois.readBoolean());
        if (this.isRaster) {
            double X = ois.readDouble();
            double Y = ois.readDouble();
            this.rasterMin = new EastNorth(X, Y);
            X = ois.readDouble();
            Y = ois.readDouble();
            this.rasterMax = new EastNorth(X, Y);
            this.rasterRatio = ois.readDouble();
        }
        double minX = ois.readDouble();
        double minY = ois.readDouble();
        double maxX = ois.readDouble();
        double maxY = ois.readDouble();
        this.communeBBox = new EastNorthBound(new EastNorth(minX, minY), new EastNorth(maxX, maxY));
        if (this.lambertZone != currentLambertZone && currentLambertZone != -1) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Lambert zone {0} in cache incompatible with current Lambert zone {1}", (Object[])new Object[]{this.lambertZone + 1, currentLambertZone}), I18n.tr((String)"Cache Lambert Zone Error"), 0);
            return false;
        }
        WMSLayer wMSLayer = this;
        synchronized (wMSLayer) {
            boolean EOF = false;
            try {
                while (!EOF) {
                    GeorefImage newImage = (GeorefImage)ois.readObject();
                    for (GeorefImage img : this.images) {
                        if (!CadastrePlugin.backgroundTransparent) continue;
                        if (img.overlap(newImage)) {
                            img.withdraw(newImage);
                            continue;
                        }
                        newImage.withdraw(img);
                    }
                    this.images.add(newImage);
                }
            }
            catch (EOFException ex) {
                // empty catch block
            }
        }
        System.out.println("Cache loaded for location " + this.location + " with " + this.images.size() + " images");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinRasterImages() {
        if (this.images.size() > 1) {
            EastNorth min = this.images.get((int)0).min;
            EastNorth max = this.images.get((int)(this.images.size() - 1)).max;
            int oldImgWidth = this.images.get((int)0).image.getWidth();
            int oldImgHeight = this.images.get((int)0).image.getHeight();
            int newWidth = oldImgWidth * (int)Math.sqrt(this.images.size());
            int newHeight = oldImgHeight * (int)Math.sqrt(this.images.size());
            BufferedImage new_img = new BufferedImage(newWidth, newHeight, 2);
            Graphics g = new_img.getGraphics();
            int rasterDivider = (int)Math.sqrt(this.images.size());
            for (int h = 0; h < rasterDivider; ++h) {
                for (int v = 0; v < rasterDivider; ++v) {
                    int newx = h * oldImgWidth;
                    int newy = newHeight - oldImgHeight - v * oldImgHeight;
                    int j = h * rasterDivider + v;
                    g.drawImage(this.images.get((int)j).image, newx, newy, this);
                }
            }
            WMSLayer wMSLayer = this;
            synchronized (wMSLayer) {
                this.images.clear();
                this.images.add(new GeorefImage(new_img, min, max));
            }
        }
    }

    public void cropImage(EastNorth en1, EastNorth en2) {
        EastNorth adj1 = new EastNorth(en1.east() <= en2.east() ? en1.east() : en2.east(), en1.north() <= en2.north() ? en1.north() : en2.north());
        EastNorth adj2 = new EastNorth(en1.east() > en2.east() ? en1.east() : en2.east(), en1.north() > en2.north() ? en1.north() : en2.north());
        int sx1 = (int)((adj1.getX() - this.images.get((int)0).min.getX()) * this.images.get(0).getPixelPerEast());
        int sy1 = (int)((this.images.get((int)0).max.getY() - adj2.getY()) * this.images.get(0).getPixelPerNorth());
        int sx2 = (int)((adj2.getX() - this.images.get((int)0).min.getX()) * this.images.get(0).getPixelPerEast());
        int sy2 = (int)((this.images.get((int)0).max.getY() - adj1.getY()) * this.images.get(0).getPixelPerNorth());
        int newWidth = Math.abs(sx2 - sx1);
        int newHeight = Math.abs(sy2 - sy1);
        BufferedImage new_img = new BufferedImage(newWidth, newHeight, 2);
        Graphics g = new_img.getGraphics();
        g.drawImage(this.images.get((int)0).image, 0, 0, newWidth - 1, newHeight - 1, sx1, sy1, sx2, sy2, this);
        this.images.set(0, new GeorefImage(new_img, adj1, adj2));
        this.rasterMin = adj1;
        this.rasterMax = adj2;
        this.rasterRatio = (this.rasterMax.getX() - this.rasterMin.getX()) / (this.communeBBox.max.getX() - this.communeBBox.min.getX());
        this.setCommuneBBox(new EastNorthBound(new EastNorth(0.0, 0.0), new EastNorth((double)(newWidth - 1), (double)(newHeight - 1))));
    }

    public EastNorthBound getCommuneBBox() {
        return this.communeBBox;
    }

    public void setCommuneBBox(EastNorthBound entireCommune) {
        this.communeBBox = entireCommune;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }

    public int getLambertZone() {
        return this.lambertZone;
    }

    public EastNorth getRasterCenter() {
        return new EastNorth((this.images.get((int)0).max.east() + this.images.get((int)0).min.east()) / 2.0, (this.images.get((int)0).max.north() + this.images.get((int)0).min.north()) / 2.0);
    }

    public void displace(double dx, double dy) {
        this.rasterMin = new EastNorth(this.rasterMin.east() + dx, this.rasterMin.north() + dy);
        this.images.get(0).shear(dx, dy);
    }

    public void resize(EastNorth rasterCenter, double proportion) {
        this.rasterMin = this.rasterMin.interpolate(rasterCenter, proportion);
        this.images.get(0).scale(rasterCenter, proportion);
    }

    public void rotate(EastNorth rasterCenter, double angle) {
        this.rasterMin = this.rasterMin.rotate(rasterCenter, angle);
        this.images.get(0).rotate(rasterCenter, angle);
    }

    private void paintCrosspieces(Graphics g, MapView mv) {
        String crosspieces = Main.pref.get("cadastrewms.crosspieces", "0");
        if (!crosspieces.equals("0")) {
            int modulo = 50;
            if (crosspieces.equals("2")) {
                modulo = 100;
            }
            EastNorthBound currentView = new EastNorthBound(mv.getEastNorth(0, mv.getHeight()), mv.getEastNorth(mv.getWidth(), 0));
            int minX = ((int)currentView.min.east() / modulo + 1) * modulo;
            int minY = ((int)currentView.min.north() / modulo + 1) * modulo;
            int maxX = (int)currentView.max.east() / modulo * modulo;
            int maxY = (int)currentView.max.north() / modulo * modulo;
            int size = (maxX - minX) / modulo;
            if (size < 20) {
                int px = size > 10 ? 2 : Math.abs(12 - size);
                g.setColor(Color.green);
                for (int x = minX; x <= maxX; x += modulo) {
                    for (int y = minY; y <= maxY; y += modulo) {
                        Point p = mv.getPoint(new EastNorth((double)x, (double)y));
                        g.drawLine(p.x - px, p.y, p.x + px, p.y);
                        g.drawLine(p.x, p.y - px, p.x, p.y + px);
                    }
                }
            }
        }
    }
}

