/*
 * Decompiled with CFR 0.152.
 */
package multipoly;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public class MultipolyAction
extends JosmAction {
    public MultipolyAction() {
        super(I18n.tr((String)"Create multipolygon"), "multipoly_create", I18n.tr((String)"Create multipolygon."), Shortcut.registerShortcut((String)"tools:multipoly", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Create multipolygon")}), (int)77, (int)3, (int)1), true);
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        HashSet<OsmPrimitive> relationsInMulti = new HashSet<OsmPrimitive>();
        for (Relation r : Main.main.getCurrentDataSet().getRelations()) {
            if (!r.isUsable() || r.get("type") != "multipolygon") continue;
            for (RelationMember rm : r.getMembers()) {
                OsmPrimitive m = rm.getMember();
                if (!(m instanceof Way)) continue;
                relationsInMulti.add(m);
            }
        }
        ArrayList<Way> selectedWays = new ArrayList<Way>();
        double maxarea = 0.0;
        Way maxWay = null;
        for (OsmPrimitive osm : Main.main.getCurrentDataSet().getSelected()) {
            if (!(osm instanceof Way)) continue;
            Way way = (Way)osm;
            if (relationsInMulti.contains(osm)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"One of the selected ways is already part of another multipolygon."));
                return;
            }
            EastNorth first = null;
            EastNorth last = null;
            double minx = 9999.0;
            double miny = 9999.0;
            double maxx = -9999.0;
            double maxy = -9999.0;
            for (Pair seg : way.getNodePairs(false)) {
                if (first == null) {
                    first = ((Node)seg.a).getEastNorth();
                }
                last = ((Node)seg.b).getEastNorth();
                double x = ((Node)seg.a).getEastNorth().east();
                double y = ((Node)seg.a).getEastNorth().north();
                if (x < minx) {
                    minx = x;
                }
                if (y < miny) {
                    miny = y;
                }
                if (x > maxx) {
                    maxx = x;
                }
                if (!(y > maxy)) continue;
                maxy = y;
            }
            if (!first.equals(last)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Multipolygon must consist only of closed ways."));
                return;
            }
            double area = (maxx - minx) * (maxy - miny);
            selectedWays.add(way);
            if (!(area > maxarea)) continue;
            maxarea = area;
            maxWay = way;
        }
        if (Main.map == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No data loaded."));
            return;
        }
        if (selectedWays.size() < 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"You must select at least two ways."));
            return;
        }
        LinkedList<AddCommand> cmds = new LinkedList<AddCommand>();
        Relation rel = new Relation();
        rel.put("type", "multipolygon");
        for (int i = 0; i < selectedWays.size(); ++i) {
            Way s = (Way)selectedWays.get(i);
            String xrole = "inner";
            if (s == maxWay) {
                xrole = "outer";
            }
            RelationMember rm = new RelationMember(xrole, (OsmPrimitive)s);
            rel.addMember(rm);
        }
        cmds.add(new AddCommand((OsmPrimitive)rel));
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Create multipolygon"), cmds));
        Main.map.repaint();
    }
}

