/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.gui.utils;

import javax.swing.ImageIcon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.House;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Reasoner;
import org.openstreetmap.josm.plugins.czechaddress.proposal.AddKeyValueProposal;
import org.openstreetmap.josm.plugins.czechaddress.proposal.KeyValueChangeProposal;
import org.openstreetmap.josm.plugins.czechaddress.proposal.ProposalContainer;
import org.openstreetmap.josm.plugins.czechaddress.proposal.RemoveKeyProposal;
import org.openstreetmap.josm.tools.ImageProvider;

public abstract class UniversalRenderer {
    private static final ImageIcon iconAdd = ImageProvider.get((String)"actions", (String)"add.png");
    private static final ImageIcon iconEdit = ImageProvider.get((String)"actions", (String)"edit.png");
    private static final ImageIcon iconRemove = ImageProvider.get((String)"actions", (String)"remove.png");
    private static final ImageIcon nodeIcon = ImageProvider.get((String)"data/node.png");
    private static final ImageIcon wayIcon = ImageProvider.get((String)"data/way.png");
    private static final ImageIcon relationIcon = ImageProvider.get((String)"data/relation.png");
    private static final ImageIcon envelopeNormIcon = ImageProvider.get((String)"envelope-closed-small.png");
    private static final ImageIcon envelopeStarIcon = ImageProvider.get((String)"envelope-closed-star-small.png");
    private static final ImageIcon envelopeExclIcon = ImageProvider.get((String)"envelope-closed-exclamation-small.png");

    public static ImageIcon getIcon(Object value) {
        if (value instanceof AddKeyValueProposal) {
            return iconAdd;
        }
        if (value instanceof KeyValueChangeProposal) {
            return iconEdit;
        }
        if (value instanceof RemoveKeyProposal) {
            return iconRemove;
        }
        if (value instanceof House) {
            House house = (House)value;
            if (Reasoner.getInstance().inConflict(house)) {
                return envelopeExclIcon;
            }
            if (Reasoner.getInstance().translate(house) == null) {
                return envelopeStarIcon;
            }
            return envelopeNormIcon;
        }
        if (value instanceof Node) {
            return nodeIcon;
        }
        if (value instanceof Relation) {
            return relationIcon;
        }
        if (value instanceof Way) {
            return wayIcon;
        }
        return null;
    }

    public static String getText(Object value) {
        if (value instanceof ProposalContainer) {
            value = ((ProposalContainer)value).getTarget();
        }
        if (value instanceof AddressElement) {
            return ((AddressElement)value).getName();
        }
        if (value instanceof OsmPrimitive) {
            return AddressElement.getName(value);
        }
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

