/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.slippymap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.gui.jmapviewer.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.Main;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlippyMapPreferences {
    public static final String PREFERENCE_PREFIX = "slippymap";
    public static final String PREFERENCE_TILE_CUSTOM_SOURCE = "slippymap.custom_tile_source_";
    public static final String PREFERENCE_TILE_SOURCE = "slippymap.tile_source";
    public static final String PREFERENCE_AUTOZOOM = "slippymap.autozoom";
    public static final String PREFERENCE_AUTOLOADTILES = "slippymap.autoload_tiles";
    public static final String PREFERENCE_MIN_ZOOM_LVL = "slippymap.min_zoom_lvl";
    public static final String PREFERENCE_MAX_ZOOM_LVL = "slippymap.max_zoom_lvl";
    public static final String PREFERENCE_LAST_ZOOM = "slippymap.last_zoom_lvl";
    public static final String PREFERENCE_FADE_BACKGROUND = "slippymap.fade_background";
    public static final String PREFERENCE_DRAW_DEBUG = "slippymap.draw_debug";
    public static final int MAX_ZOOM = 30;
    public static final int MIN_ZOOM = 2;
    public static final int DEFAULT_MAX_ZOOM = 20;
    public static final int DEFAULT_MIN_ZOOM = 2;
    public static ArrayList<TileSource> sources = null;

    public static TileSource getMapSource() {
        String name = Main.pref.get(PREFERENCE_TILE_SOURCE);
        List<TileSource> sources = SlippyMapPreferences.getAllMapSources();
        TileSource source = sources.get(0);
        if (name == null || "".equals(name)) {
            name = source.getName();
            Main.pref.put(PREFERENCE_TILE_SOURCE, name);
        }
        for (TileSource s : sources) {
            if (!name.equals(s.getName())) continue;
            source = s;
            break;
        }
        return source;
    }

    public static void setMapSource(TileSource source) {
        Main.pref.put(PREFERENCE_TILE_SOURCE, source.getName());
    }

    public static boolean getAutozoom() {
        String autozoom = Main.pref.get(PREFERENCE_AUTOZOOM);
        if (autozoom == null || "".equals(autozoom)) {
            autozoom = "true";
            Main.pref.put(PREFERENCE_AUTOZOOM, autozoom);
        }
        return Boolean.parseBoolean(autozoom);
    }

    public static void setAutozoom(boolean autozoom) {
        Main.pref.put(PREFERENCE_AUTOZOOM, autozoom);
    }

    public static void setDrawDebug(boolean drawDebug) {
        Main.pref.put(PREFERENCE_DRAW_DEBUG, drawDebug);
    }

    public static void setLastZoom(int zoom) {
        Main.pref.put(PREFERENCE_LAST_ZOOM, "" + zoom);
    }

    public static int getLastZoom() {
        int ret = -1;
        String pref = Main.pref.get(PREFERENCE_LAST_ZOOM);
        try {
            ret = Integer.parseInt(pref);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret;
    }

    public static boolean getDrawDebug() {
        String drawDebug = Main.pref.get(PREFERENCE_DRAW_DEBUG);
        if (drawDebug == null || "".equals(drawDebug)) {
            drawDebug = "false";
            Main.pref.put(PREFERENCE_DRAW_DEBUG, drawDebug);
        }
        return Boolean.parseBoolean(drawDebug);
    }

    public static boolean getAutoloadTiles() {
        String autoloadTiles = Main.pref.get(PREFERENCE_AUTOLOADTILES);
        if (autoloadTiles == null || "".equals(autoloadTiles)) {
            autoloadTiles = "true";
            Main.pref.put(PREFERENCE_AUTOLOADTILES, autoloadTiles);
        }
        return Boolean.parseBoolean(autoloadTiles);
    }

    public static void setFadeBackground(float fadeBackground) {
        Main.pref.put(PREFERENCE_FADE_BACKGROUND, fadeBackground + "");
    }

    public static float getFadeBackground() {
        float parsed;
        String fadeBackground = Main.pref.get(PREFERENCE_FADE_BACKGROUND);
        if (fadeBackground == null || "".equals(fadeBackground)) {
            fadeBackground = "0.0";
            Main.pref.put(PREFERENCE_FADE_BACKGROUND, fadeBackground);
        }
        try {
            parsed = Float.parseFloat(fadeBackground);
        }
        catch (Exception ex) {
            SlippyMapPreferences.setFadeBackground(0.1f);
            System.out.println("Error while parsing setting fade background to float! returning 0.1, because of error:");
            ex.printStackTrace(System.out);
            return 0.1f;
        }
        if (parsed < 0.0f) {
            parsed = 0.0f;
        } else if (parsed > 1.0f) {
            parsed = 1.0f;
        }
        return parsed;
    }

    public static void setAutoloadTiles(boolean autoloadTiles) {
        Main.pref.put(PREFERENCE_AUTOLOADTILES, autoloadTiles);
    }

    private static int getIntPref(String prefName, int def) {
        int pref;
        try {
            pref = Main.pref.getInteger(prefName, def);
        }
        catch (Exception ex) {
            String str = Main.pref.get(prefName);
            Main.pref.put(prefName, null);
            throw new RuntimeException("Problem while converting string to int. Converting value of preferences " + prefName + ". Value=\"" + str + "\". Should be an integer. Error: " + ex.getMessage(), ex);
        }
        return pref;
    }

    static int checkMaxZoomLvl(int maxZoomLvl) {
        if (maxZoomLvl > 30) {
            System.err.println("MaxZoomLvl shouldnt be more than 30! Setting to 30.");
            maxZoomLvl = 30;
        }
        if (maxZoomLvl < SlippyMapPreferences.__getMinZoomLvl()) {
            System.err.println("maxZoomLvl shouldnt be more than minZoomLvl! Setting to minZoomLvl.");
            maxZoomLvl = SlippyMapPreferences.__getMinZoomLvl();
        }
        return maxZoomLvl;
    }

    public static int getMaxZoomLvl() {
        int maxZoomLvl = SlippyMapPreferences.getIntPref(PREFERENCE_MAX_ZOOM_LVL, 20);
        return SlippyMapPreferences.checkMaxZoomLvl(maxZoomLvl);
    }

    public static void setMaxZoomLvl(int maxZoomLvl) {
        maxZoomLvl = SlippyMapPreferences.checkMaxZoomLvl(maxZoomLvl);
        Main.pref.put(PREFERENCE_MAX_ZOOM_LVL, "" + maxZoomLvl);
    }

    static int checkMinZoomLvl(int minZoomLvl) {
        if (minZoomLvl < 2) {
            System.err.println("minZoomLvl shouldnt be lees than 2! Setting to that.");
            minZoomLvl = 2;
        }
        if (minZoomLvl > SlippyMapPreferences.getMaxZoomLvl()) {
            System.err.println("minZoomLvl shouldnt be more than maxZoomLvl! Setting to maxZoomLvl.");
            minZoomLvl = SlippyMapPreferences.getMaxZoomLvl();
        }
        return minZoomLvl;
    }

    private static int __getMinZoomLvl() {
        return SlippyMapPreferences.getIntPref(PREFERENCE_MIN_ZOOM_LVL, 2);
    }

    public static int getMinZoomLvl() {
        return SlippyMapPreferences.checkMinZoomLvl(SlippyMapPreferences.__getMinZoomLvl());
    }

    public static void setMinZoomLvl(int minZoomLvl) {
        minZoomLvl = SlippyMapPreferences.checkMinZoomLvl(minZoomLvl);
        Main.pref.put(PREFERENCE_MIN_ZOOM_LVL, "" + minZoomLvl);
    }

    public static List<TileSource> getCustomSources() {
        ArrayList<TileSource> ret = new ArrayList<TileSource>();
        Map customSources = Main.pref.getAllPrefix(PREFERENCE_TILE_CUSTOM_SOURCE);
        for (String key : customSources.keySet()) {
            String short_key = key.replaceFirst(PREFERENCE_TILE_CUSTOM_SOURCE, "");
            if (!short_key.endsWith("name")) continue;
            String url_key = short_key.replaceFirst("name", "url");
            String ext_key = short_key.replaceFirst("name", "ext");
            String name = (String)customSources.get(key);
            String url = (String)customSources.get(PREFERENCE_TILE_CUSTOM_SOURCE + url_key);
            String ext = (String)customSources.get(PREFERENCE_TILE_CUSTOM_SOURCE + ext_key);
            System.out.println("found new tile source: '" + name + "' url:'" + url + "'" + "' ext:'" + ext + "'");
            ret.add((TileSource)new Custom(name, url, ext));
        }
        return ret;
    }

    public static List<TileSource> getAllMapSources() {
        if (sources != null) {
            return sources;
        }
        sources = new ArrayList();
        sources.add((TileSource)new OsmTileSource.Mapnik());
        sources.add((TileSource)new OsmTileSource.CycleMap());
        sources.add((TileSource)new OsmTileSource.TilesAtHome());
        sources.add((TileSource)new Coastline());
        sources.add((TileSource)new FreeMapySkPokus());
        sources.add((TileSource)new FreeMapySk());
        sources.add((TileSource)new NearMap());
        sources.addAll(SlippyMapPreferences.getCustomSources());
        return sources;
    }

    public static TileSource getSourceNamed(String name) {
        for (TileSource s : SlippyMapPreferences.getAllMapSources()) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public static class Custom
    extends OsmTileSource.AbstractOsmTileSource {
        String extension;

        public Custom(String name, String url) {
            super(name, url);
        }

        public Custom(String name, String url, String extension) {
            super(name, url);
            this.extension = extension;
        }

        public String getExtension() {
            if (this.extension == null) {
                return super.getExtension();
            }
            return this.extension;
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }
    }

    public static class NearMap
    extends OsmTileSource.AbstractOsmTileSource {
        public NearMap() {
            super("NearMap Australia", "http://www.nearmap.com/maps/hl=en&nml=Vert&");
        }

        public int getMaxZoom() {
            return 21;
        }

        public String getTilePath(int zoom, int tilex, int tiley) {
            return "z=" + zoom + "&x=" + tilex + "&y=" + tiley;
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }
    }

    public static class FreeMapySkPokus
    extends OsmTileSource.AbstractOsmTileSource {
        public FreeMapySkPokus() {
            super("freemapy.sk pokus 2", "http://www.freemap.sk/layers/tiles/?");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }
    }

    public static class FreeMapySk
    extends OsmTileSource.AbstractOsmTileSource {
        public FreeMapySk() {
            super("freemapy.sk", "http://www.freemap.sk/layers/allinone/?");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }
    }

    public static class Coastline
    extends OsmTileSource.AbstractOsmTileSource {
        public Coastline() {
            super("Coastline", "http://hypercube.telascience.org/tiles/1.0.0/coastline");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }
    }
}

