/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing.gui;

import com.innovant.josm.jrt.osm.OsmWayTypes;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class RoutingPreferenceDialog
implements PreferenceSetting {
    static Logger logger = Logger.getLogger(RoutingPreferenceDialog.class);
    private Map<String, String> orig;
    private DefaultTableModel model;

    public RoutingPreferenceDialog() {
        this.readPreferences();
    }

    public void addGui(final PreferenceDialog gui) {
        JPanel principal = gui.createPreferenceTab("routing", I18n.tr((String)"Routing Plugin Preferences"), I18n.tr((String)"Configure routing preferences."));
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        this.model = new DefaultTableModel(new String[]{I18n.tr((String)"Highway type"), I18n.tr((String)"Speed (Km/h)")}, 0){
            private static final long serialVersionUID = 4253339034781567453L;

            public boolean isCellEditable(int row, int column) {
                return column != 0;
            }
        };
        final JTable list = new JTable(this.model);
        this.loadSpeeds(this.model);
        JScrollPane scroll = new JScrollPane(list);
        p.add((Component)scroll, GBC.eol().fill(1));
        scroll.setPreferredSize(new Dimension(200, 200));
        JButton add = new JButton(I18n.tr((String)"Add"));
        p.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        p.add((Component)add, GBC.std().insets(0, 5, 0, 0));
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPanel p = new JPanel(new GridBagLayout());
                p.add((Component)new JLabel(I18n.tr((String)"Weight")), GBC.std().insets(0, 0, 5, 0));
                JComboBox<String> key = new JComboBox<String>();
                OsmWayTypes[] osmWayTypesArray = OsmWayTypes.values();
                int n = osmWayTypesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    OsmWayTypes pk = osmWayTypesArray[n2];
                    key.addItem(pk.getTag());
                    ++n2;
                }
                JTextField value = new JTextField(10);
                p.add(key, GBC.eop().insets(5, 0, 0, 0).fill(2));
                p.add((Component)new JLabel(I18n.tr((String)"Value")), GBC.std().insets(0, 0, 5, 0));
                p.add((Component)value, GBC.eol().insets(5, 0, 0, 0).fill(2));
                int answer = JOptionPane.showConfirmDialog((Component)gui, p, I18n.tr((String)"Enter weight values"), 2);
                if (answer == 0) {
                    RoutingPreferenceDialog.this.model.addRow(new String[]{key.getSelectedItem().toString(), value.getText()});
                }
            }
        });
        JButton delete = new JButton(I18n.tr((String)"Delete"));
        p.add((Component)delete, GBC.std().insets(0, 5, 0, 0));
        delete.addActionListener(new ActionListener(){

            /*
             * Unable to fully structure code
             */
            public void actionPerformed(ActionEvent e) {
                block1: {
                    if (list.getSelectedRow() != -1) ** GOTO lbl5
                    JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"Please select the row to delete."));
                    break block1;
lbl-1000:
                    // 1 sources

                    {
                        RoutingPreferenceDialog.access$0(RoutingPreferenceDialog.this).removeRow(i);
lbl5:
                        // 2 sources

                        ** while ((i = Integer.valueOf((int)list.getSelectedRow())).intValue() != -1)
                    }
                }
            }
        });
        JButton edit = new JButton(I18n.tr((String)"Edit"));
        p.add((Component)edit, GBC.std().insets(5, 5, 5, 0));
        edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RoutingPreferenceDialog.this.edit(gui, list);
            }
        });
        JTabbedPane Opciones = new JTabbedPane();
        Opciones.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        Opciones.addTab("Profile", null, p, null);
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RoutingPreferenceDialog.this.edit(gui, list);
                }
            }
        });
        principal.add((Component)Opciones, GBC.eol().fill(1));
    }

    public boolean ok() {
        int i = 0;
        while (i < this.model.getRowCount()) {
            String value = this.model.getValueAt(i, 1).toString();
            if (value.length() != 0) {
                String key = this.model.getValueAt(i, 0).toString();
                String origValue = this.orig.get(key);
                if (origValue == null || !origValue.equals(value)) {
                    Main.pref.put(key, value);
                }
                this.orig.remove(key);
            }
            ++i;
        }
        for (Map.Entry<String, String> e : this.orig.entrySet()) {
            Main.pref.put(e.getKey(), null);
        }
        return false;
    }

    private void edit(PreferenceDialog gui, JTable list) {
        if (list.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"Please select the row to edit."));
            return;
        }
        String v = JOptionPane.showInputDialog(I18n.tr((String)"New value for {0}", (Object[])new Object[]{this.model.getValueAt(list.getSelectedRow(), 0)}), this.model.getValueAt(list.getSelectedRow(), 1));
        if (v != null) {
            this.model.setValueAt(v, list.getSelectedRow(), 1);
        }
    }

    private void loadSpeeds(DefaultTableModel model) {
        this.readPreferences();
        for (String tag : this.orig.keySet()) {
            model.addRow(new String[]{tag, this.orig.get(tag)});
        }
    }

    private void readPreferences() {
        this.orig = Main.pref.getAllPrefix("routing.profile.default.speed");
        if (this.orig.size() == 0) {
            logger.debug("Loading Default Preferences.");
            OsmWayTypes[] osmWayTypesArray = OsmWayTypes.values();
            int n = osmWayTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                OsmWayTypes owt = osmWayTypesArray[n2];
                Main.pref.putInteger("routing.profile.default.speed." + owt.getTag(), Integer.valueOf(owt.getSpeed()));
                ++n2;
            }
            this.orig = Main.pref.getAllPrefix("routing.profile.default.speed");
        } else {
            logger.debug("Default preferences already exist.");
        }
    }

    private String getKeyTag(String tag) {
        return tag.split(".", 5)[4];
    }

    private String getTypeTag(String tag) {
        return tag.split(".", 5)[3];
    }

    private String getNameTag(String tag) {
        return tag.split(".", 5)[2];
    }
}

