/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.piclayer.CalibrationFileFilter;
import org.openstreetmap.josm.plugins.piclayer.PicLayerAbstract;

public class LoadPictureCalibrationAction
extends JosmAction {
    PicLayerAbstract m_owner = null;

    public LoadPictureCalibrationAction(PicLayerAbstract owner) {
        super("Load Picture Calibration...", null, "Loads calibration data to a file", null, false);
        this.m_owner = owner;
    }

    public void actionPerformed(ActionEvent arg0) {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new CalibrationFileFilter());
        fc.setSelectedFile(new File(String.valueOf(this.m_owner.getPicLayerName()) + ".cal"));
        int result = fc.showOpenDialog(Main.parent);
        if (result == 0) {
            try {
                Properties props = new Properties();
                props.load(new FileInputStream(fc.getSelectedFile()));
                this.m_owner.loadCalibration(props);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, "Loading file failed: " + e.getMessage());
            }
        }
    }
}

