/*
 * Decompiled with CFR 0.152.
 */
package org.insignificant.josm.plugins.imagewaypoint;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import org.insignificant.josm.plugins.imagewaypoint.IImageChangeListener;
import org.insignificant.josm.plugins.imagewaypoint.ImageEntries;
import org.insignificant.josm.plugins.imagewaypoint.ImageEntry;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public final class ImageWayPointLayer
extends Layer {
    private final MouseListener layerMouseListener;
    private final IImageChangeListener imageChangeListener;

    public ImageWayPointLayer() {
        super(I18n.tr((String)"Imported Images"));
        Main.main.addLayer((Layer)this);
        this.layerMouseListener = new ImageWayPointMouseListener(this);
        Main.map.mapView.addMouseListener(this.layerMouseListener);
        this.imageChangeListener = new ImageChangeListener(this);
        ImageEntries.getInstance().addListener(this.imageChangeListener);
    }

    public final Icon getIcon() {
        return ImageProvider.get((String)"dialogs/imagewaypoint");
    }

    public final Object getInfoComponent() {
        return null;
    }

    public final Component[] getMenuEntries() {
        return new Component[0];
    }

    public final String getToolTipText() {
        return "";
    }

    public final boolean isMergable(Layer other) {
        return false;
    }

    public final void mergeFrom(Layer from) {
    }

    public final void paint(Graphics2D graphics, MapView mapView, Bounds box) {
        ImageEntry[] images = ImageEntries.getInstance().getImages();
        if (images != null) {
            ImageEntry currentImage = ImageEntries.getInstance().getCurrentImageEntry();
            int index = 0;
            while (index < images.length) {
                Rectangle bounds = images[index].getBounds(mapView);
                if (bounds != null) {
                    if (images[index] == currentImage) {
                        ImageEntry.SELECTED_ICON.paintIcon((Component)mapView, graphics, bounds.x, bounds.y);
                    } else {
                        ImageEntry.ICON.paintIcon((Component)mapView, graphics, bounds.x, bounds.y);
                    }
                }
                ++index;
            }
        }
    }

    public final void visitBoundingBox(BoundingXYVisitor visitor) {
        ImageEntry[] images = ImageEntries.getInstance().getImages();
        if (images != null) {
            int index = 0;
            while (index < images.length) {
                ImageEntry imageEntry = images[index];
                if (imageEntry.getWayPoint() != null) {
                    visitor.visit(imageEntry.getWayPoint().getCoor());
                }
                ++index;
            }
        }
    }

    public final void destroy() {
        super.destroy();
        Main.map.mapView.removeMouseListener(this.layerMouseListener);
        ImageEntries.getInstance().removeListener(this.imageChangeListener);
    }

    private static final class ImageChangeListener
    implements IImageChangeListener {
        private final ImageWayPointLayer layer;

        public ImageChangeListener(ImageWayPointLayer layer) {
            this.layer = layer;
        }

        public final void onAvailableImageEntriesChanged(ImageEntries entries) {
            Main.map.repaint();
        }

        public final void onSelectedImageEntryChanged(ImageEntries entries) {
            Main.map.repaint();
        }
    }

    private static final class ImageWayPointMouseListener
    extends MouseAdapter {
        private final ImageWayPointLayer layer;

        public ImageWayPointMouseListener(ImageWayPointLayer layer) {
            this.layer = layer;
        }

        public final void mouseClicked(MouseEvent event) {
            ImageEntry[] images;
            if (1 == event.getButton() && this.layer.isVisible() && (images = ImageEntries.getInstance().getImages()) != null) {
                boolean found = false;
                int index = images.length - 1;
                while (!found && index >= 0) {
                    Rectangle bounds = images[index].getBounds(Main.map.mapView);
                    if (bounds != null && bounds.contains(event.getPoint())) {
                        found = true;
                        ImageEntries.getInstance().setCurrentImageEntry(images[index]);
                    }
                    --index;
                }
            }
        }
    }
}

