/*
 * Decompiled with CFR 0.152.
 */
package org.insignificant.josm.plugins.imagewaypoint;

import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.File;
import javax.swing.Icon;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageEntry
implements Comparable<ImageEntry> {
    public static final Icon ICON = ImageProvider.get((String)"dialogs/imagewaypoint-marker");
    public static final Icon SELECTED_ICON = ImageProvider.get((String)"dialogs/imagewaypoint-marker-selected");
    private static final int ICON_WIDTH = ICON.getIconWidth();
    private static final int ICON_HEIGHT = ICON.getIconHeight();
    private final String filePath;
    private final String fileName;
    private final ImageObserver observer;
    private WayPoint wayPoint;
    private Orientation orientation;
    private IImageReadyListener listener;
    private Image normalImage;
    private Image rotatedImage;

    public ImageEntry(File file) {
        this.filePath = file.getAbsolutePath();
        this.fileName = file.getName();
        this.observer = new Observer(this);
        this.wayPoint = null;
        this.orientation = Orientation.NORMAL;
        this.listener = null;
        this.normalImage = null;
        this.rotatedImage = null;
    }

    @Override
    public final int compareTo(ImageEntry image) {
        return this.fileName.compareTo(image.fileName);
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final WayPoint getWayPoint() {
        return this.wayPoint;
    }

    public final void setWayPoint(WayPoint wayPoint) {
        this.wayPoint = wayPoint;
    }

    public final Orientation getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.normalImage = null;
        this.rotatedImage = null;
    }

    public final Rectangle getBounds(MapView mapView) {
        Rectangle bounds;
        if (this.wayPoint == null) {
            bounds = null;
        } else {
            Point point = mapView.getPoint(this.getWayPoint().getCoor());
            bounds = new Rectangle(point.x - ICON_WIDTH, point.y - ICON_HEIGHT, ICON_WIDTH, ICON_WIDTH);
        }
        return bounds;
    }

    public final void requestImage(IImageReadyListener imageReadyListener) {
        this.listener = imageReadyListener;
        if (this.rotatedImage == null) {
            Image image = Toolkit.getDefaultToolkit().getImage(this.filePath);
            if (Toolkit.getDefaultToolkit().prepareImage(image, -1, -1, this.observer)) {
                this.imageLoaded(image);
            }
        } else if (this.listener != null) {
            this.listener.onImageReady(this, this.rotatedImage);
        }
    }

    public final void flush() {
        if (this.normalImage != null) {
            this.normalImage.flush();
            this.normalImage = null;
        }
        if (this.rotatedImage != null) {
            this.rotatedImage.flush();
            this.rotatedImage = null;
        }
    }

    private final void imageLoaded(Image image) {
        if (Orientation.NORMAL == this.getOrientation()) {
            this.rotatedImage = image;
        } else {
            int[] buffer = new int[image.getWidth(null) * image.getHeight(null)];
            PixelGrabber grabber = new PixelGrabber(image, 0, 0, image.getWidth(null), image.getHeight(null), buffer, 0, image.getWidth(null));
            try {
                int newWidth;
                int newHeight;
                grabber.grabPixels();
                if (Orientation.ROTATE_180 == this.getOrientation()) {
                    newHeight = image.getHeight(null);
                    newWidth = image.getWidth(null);
                } else {
                    newHeight = image.getWidth(null);
                    newWidth = image.getHeight(null);
                }
                int[] destination = new int[image.getWidth(null) * image.getHeight(null)];
                int x = 0;
                while (x < image.getWidth(null)) {
                    int y = 0;
                    while (y < image.getHeight(null)) {
                        int newY;
                        int newX;
                        int pix = buffer[x + y * image.getWidth(null)];
                        if (Orientation.ROTATE_90 == this.getOrientation()) {
                            newX = newWidth - y;
                            newY = x;
                        } else if (Orientation.ROTATE_180 == this.getOrientation()) {
                            newX = newWidth - x;
                            newY = newHeight - y;
                        } else {
                            newX = y;
                            newY = newHeight - x;
                        }
                        int newIndex = newX + newY * newWidth;
                        if (newIndex < destination.length) {
                            destination[newIndex] = pix;
                        }
                        ++y;
                    }
                    ++x;
                }
                this.rotatedImage = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(newWidth, newHeight, destination, 0, newWidth));
            }
            catch (InterruptedException e) {
                this.rotatedImage = null;
            }
        }
        if (this.listener != null) {
            this.listener.onImageReady(this, this.rotatedImage);
        }
    }

    public static interface IImageReadyListener {
        public void onImageReady(ImageEntry var1, Image var2);
    }

    private static final class Observer
    implements ImageObserver {
        private final ImageEntry imageEntry;

        public Observer(ImageEntry imageEntry) {
            this.imageEntry = imageEntry;
        }

        public final boolean imageUpdate(Image image, int infoflags, int x, int y, int width, int height) {
            boolean complete;
            boolean bl = complete = 32 == (infoflags | 0x20);
            if (complete) {
                this.imageEntry.imageLoaded(image);
            }
            return !complete;
        }
    }

    public static final class Orientation {
        private static final Orientation[] orientations = new Orientation[4];
        public static final Orientation NORMAL = new Orientation(I18n.tr((String)"Normal"), 0);
        public static final Orientation ROTATE_90 = new Orientation(I18n.tr((String)"Rotate 90"), 1);
        public static final Orientation ROTATE_180 = new Orientation(I18n.tr((String)"Rotate 180"), 2);
        public static final Orientation ROTATE_270 = new Orientation(I18n.tr((String)"Rotate 270"), 3);
        private final String name;
        private final int index;

        private Orientation(String name, int index) {
            this.name = name;
            this.index = index;
            Orientation.orientations[index] = this;
        }

        public final Orientation rotateRight() {
            if (this.index < orientations.length - 1) {
                return orientations[this.index + 1];
            }
            return orientations[0];
        }

        public final Orientation rotateLeft() {
            if (this.index == 0) {
                return orientations[orientations.length - 1];
            }
            return orientations[this.index - 1];
        }

        public String toString() {
            return "[" + this.name + "]";
        }
    }
}

