/*
 * Decompiled with CFR 0.152.
 */
package org.insignificant.josm.plugins.imagewaypoint;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.insignificant.josm.plugins.imagewaypoint.IImageChangeListener;
import org.insignificant.josm.plugins.imagewaypoint.ImageEntry;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageEntries {
    private static final ImageEntries INSTANCE = new ImageEntries();
    private final List<ImageEntry> images = new ArrayList<ImageEntry>();
    private final List<ImageEntry> locatedImages = new ArrayList<ImageEntry>();
    private final List<IImageChangeListener> listeners = new ArrayList<IImageChangeListener>();
    private final ImageEntry.IImageReadyListener listener = new ImageReadyListener(this);
    private ImageEntry currentImageEntry = null;
    private Image currentImage = null;

    private ImageEntries() {
    }

    public static final ImageEntries getInstance() {
        return INSTANCE;
    }

    public final void addListener(IImageChangeListener listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(IImageChangeListener listener) {
        this.listeners.remove(listener);
    }

    public final void add(File[] imageFiles) {
        if (imageFiles != null) {
            int index = 0;
            while (index < imageFiles.length) {
                this.images.add(new ImageEntry(imageFiles[index]));
                ++index;
            }
            this.associateAllLayers();
        }
    }

    public final void associateAllLayers() {
        int index = 0;
        while (index < this.images.size()) {
            this.images.get(index).setWayPoint(null);
            ++index;
        }
        this.locatedImages.clear();
        if (Main.map != null && Main.map.mapView != null) {
            Collection layerCollection = Main.map.mapView.getAllLayers();
            Layer[] layers = layerCollection.toArray(new Layer[layerCollection.size()]);
            int index2 = 0;
            while (index2 < layers.length) {
                if (layers[index2] instanceof GpxLayer && ((GpxLayer)layers[index2]).data != null && !((GpxLayer)layers[index2]).data.fromServer) {
                    this.doAssociateLayer((GpxLayer)layers[index2]);
                }
                ++index2;
            }
            for (IImageChangeListener listener : this.listeners) {
                listener.onSelectedImageEntryChanged(this);
            }
        }
    }

    private final void doAssociateLayer(GpxLayer gpxLayer) {
        if (gpxLayer != null && gpxLayer.data != null && !gpxLayer.data.fromServer) {
            for (WayPoint wayPoint : gpxLayer.data.waypoints) {
                List<String> texts = this.getTextContentsFromWayPoint(wayPoint);
                for (String text : texts) {
                    ImageEntry image = this.findImageEntryWithFileName(text);
                    if (image == null) continue;
                    image.setWayPoint(wayPoint);
                    this.locatedImages.add(image);
                }
            }
        }
    }

    private final List<String> getTextContentsFromWayPoint(WayPoint wayPoint) {
        ArrayList<String> texts = new ArrayList<String>();
        String[] stringArray = new String[]{"name", "cmt", "desc"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String t = wayPoint.getString(s);
            if (t != null && t.length() > 0) {
                texts.add(t);
            }
            ++n2;
        }
        return texts;
    }

    private final ImageEntry findImageEntryWithFileName(String fileName) {
        ImageEntry foundimage = null;
        int index = 0;
        while (index < this.images.size() && foundimage == null) {
            ImageEntry image = this.images.get(index);
            if (image.getWayPoint() == null && image.getFileName().startsWith(fileName)) {
                foundimage = image;
            }
            ++index;
        }
        return foundimage;
    }

    private final void setCurrentImage(ImageEntry imageEntry, Image image) {
        if (imageEntry == this.currentImageEntry) {
            this.currentImage = image;
        }
        for (IImageChangeListener listener : this.listeners) {
            listener.onSelectedImageEntryChanged(this);
        }
    }

    public final ImageEntry[] getImages() {
        return this.locatedImages.toArray(new ImageEntry[this.locatedImages.size()]);
    }

    public final ImageEntry getCurrentImageEntry() {
        return this.currentImageEntry;
    }

    public final Image getCurrentImage() {
        return this.currentImage;
    }

    public final boolean hasNext() {
        return this.currentImageEntry != null && this.locatedImages.indexOf(this.currentImageEntry) < this.locatedImages.size() - 1;
    }

    public final boolean hasPrevious() {
        return this.currentImageEntry != null && this.locatedImages.indexOf(this.currentImageEntry) > 0;
    }

    public final void next() {
        if (this.currentImageEntry != null && this.locatedImages.indexOf(this.currentImageEntry) < this.locatedImages.size() - 1) {
            this.setCurrentImageEntry(this.locatedImages.get(this.locatedImages.indexOf(this.currentImageEntry) + 1));
        }
    }

    public final void previous() {
        if (this.currentImageEntry != null && this.locatedImages.indexOf(this.currentImageEntry) > 0) {
            this.setCurrentImageEntry(this.locatedImages.get(this.locatedImages.indexOf(this.currentImageEntry) - 1));
        }
    }

    public final void rotateCurrentImageLeft() {
        if (this.currentImageEntry != null) {
            this.currentImageEntry.setOrientation(this.currentImageEntry.getOrientation().rotateLeft());
        }
        this.setCurrentImageEntry(this.currentImageEntry);
    }

    public final void rotateCurrentImageRight() {
        if (this.currentImageEntry != null) {
            this.currentImageEntry.setOrientation(this.currentImageEntry.getOrientation().rotateRight());
        }
        this.setCurrentImageEntry(this.currentImageEntry);
    }

    public final void setCurrentImageEntry(ImageEntry imageEntry) {
        if (imageEntry == null || this.locatedImages.contains(imageEntry)) {
            if (this.currentImageEntry != null) {
                this.currentImageEntry.flush();
            }
            this.currentImageEntry = imageEntry;
            this.currentImage = null;
            for (IImageChangeListener listener : this.listeners) {
                listener.onSelectedImageEntryChanged(this);
            }
            if (imageEntry != null) {
                this.currentImageEntry.requestImage(this.listener);
            }
        }
    }

    private static final class ImageReadyListener
    implements ImageEntry.IImageReadyListener {
        private final ImageEntries imageEntries;

        public ImageReadyListener(ImageEntries imageEntries) {
            this.imageEntries = imageEntries;
        }

        public final void onImageReady(ImageEntry imageEntry, Image image) {
            this.imageEntries.setCurrentImage(imageEntry, image);
        }
    }
}

