/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.ac;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.plugins.tageditor.ac.AutoCompletionList;
import org.openstreetmap.josm.plugins.tageditor.ac.AutoCompletionListRenderer;
import org.openstreetmap.josm.plugins.tageditor.ac.IAutoCompletionListListener;

public class AutoCompletionListViewer
extends JPanel {
    private static Logger logger = Logger.getLogger(AutoCompletionListViewer.class.getName());
    private JTable table = null;
    private AutoCompletionList autoCompletionList = null;
    private ArrayList<IAutoCompletionListListener> listener = null;

    protected void createGUI() {
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.table = new JTable();
        if (this.autoCompletionList == null) {
            this.table.setModel(new DefaultTableModel());
        } else {
            this.table.setModel(this.autoCompletionList);
        }
        this.table.setTableHeader(null);
        this.table.setDefaultRenderer(Object.class, new AutoCompletionListRenderer());
        JScrollPane p = new JScrollPane(this.table);
        p.setBackground(Color.WHITE);
        this.add((Component)p, "Center");
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = AutoCompletionListViewer.this.table.getSelectedRow();
                    String item = AutoCompletionListViewer.this.autoCompletionList.getFilteredItem(row).getValue();
                    AutoCompletionListViewer.this.fireAutoCompletionListItemSelected(item);
                }
            }
        });
    }

    public AutoCompletionListViewer(AutoCompletionList list) {
        this.autoCompletionList = list;
        this.createGUI();
        this.listener = new ArrayList();
    }

    public AutoCompletionListViewer() {
        this.autoCompletionList = null;
        this.createGUI();
        this.listener = new ArrayList();
    }

    public Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize();
        d.width = 100;
        return d;
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getMaximumSize();
        d.width = 150;
        return d;
    }

    public AutoCompletionList getAutoCompletionList() {
        return this.autoCompletionList;
    }

    public void setAutoCompletionList(AutoCompletionList autoCompletionList) {
        this.autoCompletionList = autoCompletionList;
        if (autoCompletionList == null) {
            this.table.setModel(new DefaultTableModel());
        } else {
            this.table.setModel(autoCompletionList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAutoCompletionListListener(IAutoCompletionListListener listener) {
        if (listener != null && !this.listener.contains(listener)) {
            ArrayList<IAutoCompletionListListener> arrayList = this.listener;
            synchronized (arrayList) {
                this.listener.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAutoCompletionListListener(IAutoCompletionListListener listener) {
        if (listener != null && this.listener.contains(listener)) {
            ArrayList<IAutoCompletionListListener> arrayList = this.listener;
            synchronized (arrayList) {
                this.listener.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAutoCompletionListItemSelected(String item) {
        ArrayList<IAutoCompletionListListener> arrayList = this.listener;
        synchronized (arrayList) {
            for (IAutoCompletionListListener target : this.listener) {
                target.autoCompletionItemSelected(item);
            }
        }
    }

    public void installKeyAction(Action a) {
        this.getInputMap(2).put((KeyStroke)a.getValue("AcceleratorKey"), a.getValue("Name"));
        this.getActionMap().put(a.getValue("Name"), a);
    }
}

