/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

public class Coastlines
extends Test {
    protected static int UNORDERED_COASTLINE = 901;
    protected static int REVERSED_COASTLINE = 902;
    protected static int UNCONNECTED_COASTLINE = 903;
    private List<Way> coastlines;
    private Area downloadedArea = null;

    public Coastlines() {
        super(I18n.tr((String)"Coastlines."), I18n.tr((String)"This test checks that coastlines are correct."));
    }

    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        OsmDataLayer layer = Main.map.mapView.getEditLayer();
        if (layer != null) {
            this.downloadedArea = layer.data.getDataSourceArea();
        }
        this.coastlines = new LinkedList<Way>();
    }

    public void endTest() {
        for (Way c1 : this.coastlines) {
            Node tail;
            Node head = c1.firstNode();
            if (head.equals((Object)(tail = c1.lastNode()))) continue;
            int headWays = 0;
            int tailWays = 0;
            boolean headReversed = false;
            boolean tailReversed = false;
            boolean headUnordered = false;
            boolean tailUnordered = false;
            Way next = null;
            Way prev = null;
            for (Way c2 : this.coastlines) {
                if (c1 == c2) continue;
                if (c2.containsNode(head)) {
                    ++headWays;
                    next = c2;
                    if (head.equals((Object)c2.firstNode())) {
                        headReversed = true;
                    } else if (!head.equals((Object)c2.lastNode())) {
                        headUnordered = true;
                    }
                }
                if (!c2.containsNode(tail)) continue;
                ++tailWays;
                prev = c2;
                if (tail.equals((Object)c2.lastNode())) {
                    tailReversed = true;
                    continue;
                }
                if (tail.equals((Object)c2.firstNode())) continue;
                tailUnordered = true;
            }
            ArrayList<Way> primitives = new ArrayList<Way>();
            primitives.add(c1);
            if (headWays == 0 || tailWays == 0) {
                ArrayList<Node> highlight = new ArrayList<Node>();
                System.out.println("Unconnected coastline: " + c1.getId());
                if (headWays == 0 && (this.downloadedArea == null || this.downloadedArea.contains((Point2D)head.getCoor()))) {
                    System.out.println("headways: " + headWays + " node: " + head.toString());
                    highlight.add(head);
                }
                if (tailWays == 0 && (this.downloadedArea == null || this.downloadedArea.contains((Point2D)tail.getCoor()))) {
                    System.out.println("tailways: " + tailWays + " tail: " + tail.toString());
                    highlight.add(tail);
                }
                if (highlight.size() > 0) {
                    this.errors.add(new TestError(this, Severity.ERROR, I18n.tr((String)"Unconnceted coastline"), UNCONNECTED_COASTLINE, primitives, highlight));
                }
            }
            boolean unordered = false;
            boolean reversed = false;
            if (headWays == 1 && headReversed && tailWays == 1 && tailReversed) {
                reversed = true;
            }
            if (headWays > 1 || tailWays > 1) {
                unordered = true;
            } else if (headUnordered || tailUnordered) {
                unordered = true;
            } else if (reversed && next == prev) {
                unordered = true;
            }
            if (unordered) {
                ArrayList<Node> highlight = new ArrayList<Node>();
                System.out.println("Unordered coastline: " + c1.toString());
                if (headWays > 1 || headUnordered || reversed) {
                    System.out.println("head: " + head.toString());
                    highlight.add(head);
                }
                if (tailWays > 1 || tailUnordered || reversed) {
                    System.out.println("tail: " + tail.toString());
                    highlight.add(tail);
                }
                this.errors.add(new TestError(this, Severity.ERROR, I18n.tr((String)"Unordered coastline"), UNORDERED_COASTLINE, primitives, highlight));
                continue;
            }
            if (!reversed) continue;
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"Reversed coastline"), REVERSED_COASTLINE, primitives));
        }
        this.coastlines = null;
        this.downloadedArea = null;
        super.endTest();
    }

    public void visit(Way way) {
        if (!way.isUsable()) {
            return;
        }
        String natural = way.get("natural");
        if (natural == null || !natural.equals("coastline")) {
            return;
        }
        this.coastlines.add(way);
    }

    public Command fixError(TestError testError) {
        if (this.isFixable(testError)) {
            Way way = (Way)testError.getPrimitives().iterator().next();
            Way newWay = new Way(way);
            List nodesCopy = newWay.getNodes();
            Collections.reverse(nodesCopy);
            newWay.setNodes(nodesCopy);
            return new ChangeCommand((OsmPrimitive)way, (OsmPrimitive)newWay);
        }
        return null;
    }

    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof Coastlines) {
            return testError.getCode() == REVERSED_COASTLINE;
        }
        return false;
    }
}

