/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.util;

import javax.swing.Icon;
import javax.swing.JLabel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class NameVisitor
extends AbstractVisitor {
    public String className;
    public String classNamePlural;
    public String name;
    public Icon icon;

    public void visit(Node n) {
        this.name = n.getName();
        this.addId((OsmPrimitive)n);
        this.icon = ImageProvider.get((String)"data", (String)"node");
        this.className = "node";
        this.classNamePlural = I18n.trn((String)"node", (String)"nodes", (long)2L);
    }

    public void visit(Way w) {
        this.name = w.getName();
        this.addId((OsmPrimitive)w);
        this.icon = ImageProvider.get((String)"data", (String)"way");
        this.className = "way";
        this.classNamePlural = I18n.trn((String)"way", (String)"ways", (long)2L);
    }

    public void visit(Relation e) {
        this.name = e.getName();
        this.addId((OsmPrimitive)e);
        this.icon = ImageProvider.get((String)"data", (String)"relation");
        this.className = "relation";
        this.classNamePlural = I18n.trn((String)"relation", (String)"relations", (long)2L);
    }

    public JLabel toLabel() {
        return new JLabel(this.name, this.icon, 0);
    }

    private void addId(OsmPrimitive osm) {
        if (Main.pref.getBoolean("osm-primitives.showid")) {
            this.name = this.name + I18n.tr((String)" [id: {0}]", (Object[])new Object[]{osm.getId()});
        }
    }
}

