/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UntaggedNode
extends Test {
    protected static int UNTAGGED_NODE = 201;
    Set<Node> emptyNodes;

    public UntaggedNode() {
        super(I18n.tr((String)"Untagged and unconnected nodes") + ".", I18n.tr((String)"This test checks for untagged nodes that are not part of any way."));
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.emptyNodes = new HashSet<Node>(100);
    }

    @Override
    public void visit(Collection<OsmPrimitive> selection) {
        if (this.partialSelection) {
            for (OsmPrimitive p : selection) {
                if (!p.isUsable() || !(p instanceof Node)) continue;
                p.visit((Visitor)this);
            }
            for (Way w : Main.main.getCurrentDataSet().getWays()) {
                this.visit(w);
            }
        } else {
            for (OsmPrimitive p : selection) {
                if (!p.isUsable()) continue;
                p.visit((Visitor)this);
            }
        }
    }

    @Override
    public void visit(Node n) {
        if (n.isUsable() && !n.isTagged()) {
            this.emptyNodes.add(n);
        }
    }

    @Override
    public void visit(Way w) {
        for (Node n : w.getNodes()) {
            this.emptyNodes.remove(n);
        }
    }

    @Override
    public void endTest() {
        for (Node node : this.emptyNodes) {
            this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Untagged and unconnected nodes"), UNTAGGED_NODE, (OsmPrimitive)node));
        }
        this.emptyNodes = null;
        super.endTest();
    }

    @Override
    public Command fixError(TestError testError) {
        return DeleteCommand.delete((OsmDataLayer)Main.map.mapView.getEditLayer(), testError.getPrimitives());
    }

    @Override
    public boolean isFixable(TestError testError) {
        return testError.getTester() instanceof UntaggedNode;
    }
}

