/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui.action;

import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.osb.gui.action.OsbActionObserver;
import org.openstreetmap.josm.tools.I18n;

public abstract class OsbAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static List<OsbActionObserver> observers = new ArrayList<OsbActionObserver>();
    private static Node selectedNode;

    public OsbAction(String name) {
        super(name);
    }

    public static Node getSelectedNode() {
        return selectedNode;
    }

    public static void setSelectedNode(Node selectedNode) {
        OsbAction.selectedNode = selectedNode;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            this.doActionPerformed(e);
            for (OsbActionObserver obs : observers) {
                obs.actionPerformed(this);
            }
        }
        catch (Exception e1) {
            System.err.println("Couldn't execute action " + this.getClass().getSimpleName());
            e1.printStackTrace();
        }
    }

    protected abstract void doActionPerformed(ActionEvent var1) throws Exception;

    public static void addActionObserver(OsbActionObserver obs) {
        observers.add(obs);
    }

    public static void removeActionObserver(OsbActionObserver obs) {
        observers.remove(obs);
    }

    protected String addMesgInfo(String msg) {
        String nickname = Main.pref.get("osb.nickname");
        if (nickname == null || nickname.length() == 0) {
            nickname = JOptionPane.showInputDialog(Main.parent, (Object)I18n.tr((String)"Please enter a user name"));
            if (nickname == null) {
                nickname = "NoName";
            } else {
                Main.pref.put("osb.nickname", nickname);
            }
        }
        String info = nickname;
        if (Main.pref.getBoolean("osb.include_date")) {
            DateFormat df = DateFormat.getDateTimeInstance(3, 1, Locale.getDefault());
            String date = df.format(new Date());
            info = info.concat(", ").concat(date);
        }
        msg = msg.concat(" [").concat(info).concat("]");
        return msg;
    }
}

