/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.api;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.osb.api.util.HttpUtils;
import org.openstreetmap.josm.tools.OsmUrlToBounds;

public class DownloadAction {
    private final String CHARSET = "UTF-8";

    public void execute(DataSet dataset, Bounds bounds) throws IOException {
        String uri = Main.pref.get("osb.uri.download");
        int zoom = OsmUrlToBounds.getZoom((Bounds)Main.map.mapView.getRealBounds());
        if (zoom > 15 || zoom < 9) {
            return;
        }
        StringBuilder sb = new StringBuilder(uri).append("?b=").append(bounds.getMin().lat()).append("&t=").append(bounds.getMax().lat()).append("&l=").append(bounds.getMin().lon()).append("&r=").append(bounds.getMax().lon());
        uri = sb.toString();
        String content = HttpUtils.get(uri, null, "UTF-8");
        dataset.clear();
        this.parseData(dataset, content);
    }

    private void parseData(DataSet dataSet, String content) {
        String idPattern = "\\d+";
        String floatPattern = "-?\\d+\\.\\d+";
        String pattern = "putAJAXMarker\\s*\\(\\s*(" + idPattern + ")\\s*,\\s*(" + floatPattern + ")\\s*,\\s*(" + floatPattern + ")\\s*,\\s*(?:\"|')(.*)(?:\"|')\\s*,\\s*([01])\\s*\\)";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(content);
        while (m.find()) {
            double lat = Double.parseDouble(m.group(3));
            double lon = Double.parseDouble(m.group(2));
            LatLon latlon = new LatLon(lat, lon);
            Node osmNode = new Node(Long.parseLong(m.group(1)));
            osmNode.setCoor(latlon);
            osmNode.incomplete = false;
            osmNode.put("id", m.group(1));
            osmNode.put("note", m.group(4));
            osmNode.put("openstreetbug", "FIXME");
            osmNode.put("state", m.group(5));
            dataSet.addPrimitive((OsmPrimitive)osmNode);
        }
    }
}

