/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.util;

import java.io.IOException;
import java.io.Writer;

public class IndentWriter {
    private Writer writer;
    private int level = 0;

    public IndentWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = Math.max(0, level);
    }

    public void incLevel() {
        ++this.level;
    }

    public void decLevel() {
        this.level = Math.max(0, this.level - 1);
    }

    public void indent() throws IOException {
        for (int i = 1; i <= this.level; ++i) {
            this.writer.write("  ");
        }
    }

    public void write(String s) throws IOException {
        this.writer.write(s);
    }

    public void writeLine(String s) throws IOException {
        this.indent();
        this.write(s);
        this.write("\n");
    }
}

