/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.plugin.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.graphview.core.data.DataSource;
import org.openstreetmap.josm.plugins.graphview.core.data.DataSourceObserver;
import org.openstreetmap.josm.plugins.graphview.core.data.MapBasedTagGroup;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOSMDataSource
implements DataSource<Node, Way, Relation> {
    private static final TagGroup EMPTY_TAG_GROUP;
    private final Set<DataSourceObserver> observers = new HashSet<DataSourceObserver>();

    @Override
    public double getLat(Node node) {
        return node.getCoor().lat();
    }

    @Override
    public double getLon(Node node) {
        return node.getCoor().lon();
    }

    @Override
    public Iterable<DataSource.RelationMember> getMembers(Relation relation) {
        ArrayList<DataSource.RelationMember> members = new ArrayList<DataSource.RelationMember>(relation.getMembersCount());
        for (RelationMember member : relation.getMembers()) {
            if (member.getMember().isDeleted() || member.getMember().incomplete) continue;
            members.add(new RelationMemberImpl(member));
        }
        return members;
    }

    @Override
    public Iterable<Node> getNodes(Way way) {
        return new FilteredOsmPrimitiveIterable<Node>(way.getNodes());
    }

    @Override
    public Iterable<Node> getNodes() {
        return new FilteredOsmPrimitiveIterable<Node>(Main.main.getCurrentDataSet().getNodes());
    }

    @Override
    public Iterable<Relation> getRelations() {
        return new FilteredRelationIterable(Main.main.getCurrentDataSet().getRelations());
    }

    @Override
    public Iterable<Way> getWays() {
        return new FilteredOsmPrimitiveIterable<Way>(Main.main.getCurrentDataSet().getWays());
    }

    @Override
    public TagGroup getTagsN(Node node) {
        return this.getTags((OsmPrimitive)node);
    }

    @Override
    public TagGroup getTagsW(Way way) {
        return this.getTags((OsmPrimitive)way);
    }

    @Override
    public TagGroup getTagsR(Relation relation) {
        return this.getTags((OsmPrimitive)relation);
    }

    private TagGroup getTags(OsmPrimitive primitive) {
        if (primitive.getKeys() == null) {
            return EMPTY_TAG_GROUP;
        }
        return new MapBasedTagGroup(primitive.getKeys());
    }

    @Override
    public void addObserver(DataSourceObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void deleteObserver(DataSourceObserver observer) {
        this.observers.remove(observer);
    }

    static {
        HashMap<String, String> emptyMap = new HashMap<String, String>(0);
        EMPTY_TAG_GROUP = new MapBasedTagGroup(emptyMap);
    }

    public static class RelationMemberImpl
    implements DataSource.RelationMember {
        private final String role;
        private final Object member;

        public RelationMemberImpl(RelationMember originalMember) {
            this.role = originalMember.getRole();
            this.member = originalMember.getMember();
        }

        public String getRole() {
            return this.role;
        }

        public Object getMember() {
            return this.member;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FilteredRelationIterable
    extends FilteredOsmPrimitiveIterable<Relation> {
        public FilteredRelationIterable(Iterable<Relation> originalIterable) {
            super(originalIterable);
        }

        @Override
        protected boolean accept(Relation relation) {
            boolean complete = true;
            for (RelationMember member : relation.getMembers()) {
                if (member.getMember() != null && !member.getMember().isDeleted() && !member.getMember().incomplete) continue;
                complete = false;
            }
            return complete && super.accept(relation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FilteredOsmPrimitiveIterable<P extends OsmPrimitive>
    implements Iterable<P> {
        private final Iterable<P> originalIterable;

        public FilteredOsmPrimitiveIterable(Iterable<P> originalIterable) {
            this.originalIterable = originalIterable;
        }

        @Override
        public Iterator<P> iterator() {
            return new FilteredIterator(this.originalIterable.iterator());
        }

        protected boolean accept(P primitive) {
            return !primitive.isDeleted() && !((OsmPrimitive)primitive).incomplete;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FilteredIterator
        implements Iterator<P> {
            private final Iterator<P> originalIterator;
            private P next;

            public FilteredIterator(Iterator<P> originalIterator) {
                this.originalIterator = originalIterator;
                this.updateNext();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public P next() {
                if (this.next != null) {
                    Object result = this.next;
                    this.updateNext();
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void updateNext() {
                if (this.originalIterator.hasNext()) {
                    this.next = (OsmPrimitive)this.originalIterator.next();
                    if (!FilteredOsmPrimitiveIterable.this.accept(this.next)) {
                        this.updateNext();
                    }
                } else {
                    this.next = null;
                }
            }
        }
    }
}

