/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.walkingpapers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.walkingpapers.WalkingPapersKey;
import org.openstreetmap.josm.plugins.walkingpapers.WalkingPapersTile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class WalkingPapersLayer
extends Layer
implements ImageObserver {
    private int currentZoomLevel;
    private HashMap<WalkingPapersKey, WalkingPapersTile> tileStorage = null;
    private Point[][] pixelpos = new Point[21][21];
    private LatLon lastTopLeft;
    private LatLon lastBotRight;
    private int viewportMinX;
    private int viewportMaxX;
    private int viewportMinY;
    private int viewportMaxY;
    private Image bufferImage;
    private boolean needRedraw;
    private int minzoom;
    private int maxzoom;
    private Bounds printBounds;
    private String tileUrlTemplate;
    private String walkingPapersId;
    long lastCheck = 0L;

    public WalkingPapersLayer(String id, String tile, Bounds b, int minz, int maxz) {
        super(I18n.tr((String)"Walking Papers: {0}", (Object[])new Object[]{id}));
        this.setBackgroundLayer(true);
        this.walkingPapersId = id;
        this.tileUrlTemplate = tile;
        this.printBounds = b;
        this.minzoom = minz;
        this.maxzoom = maxz;
        this.currentZoomLevel = minz;
        this.clearTileStorage();
        Layer.listeners.add(new Layer.LayerChangeListener(){

            public void activeLayerChange(Layer oldLayer, Layer newLayer) {
                this.layerAdded(newLayer);
            }

            public void layerAdded(Layer newLayer) {
                if (newLayer != WalkingPapersLayer.this) {
                    return;
                }
                BoundingXYVisitor bbox = new BoundingXYVisitor();
                bbox.visit(WalkingPapersLayer.this.printBounds);
                Main.map.mapView.recalculateCenterScale(bbox);
                WalkingPapersLayer.this.needRedraw = true;
            }

            public void layerRemoved(Layer oldLayer) {
            }
        });
    }

    public void increaseZoomLevel() {
        if (this.currentZoomLevel < this.maxzoom) {
            ++this.currentZoomLevel;
            this.needRedraw = true;
        }
    }

    public void decreaseZoomLevel() {
        if (this.currentZoomLevel > this.minzoom) {
            --this.currentZoomLevel;
            this.needRedraw = true;
        }
    }

    public void clearTileStorage() {
        this.tileStorage = new HashMap();
        this.checkTileStorage();
    }

    public void checkTileStorage() {
        long now = System.currentTimeMillis();
        if (now - this.lastCheck < 1000L) {
            return;
        }
        this.lastCheck = now;
        TreeSet<WalkingPapersTile> tiles = new TreeSet<WalkingPapersTile>(new TileTimeComp());
        tiles.addAll(this.tileStorage.values());
        int max_nr_tiles = 100;
        if (tiles.size() < max_nr_tiles) {
            return;
        }
        int dropCount = tiles.size() - max_nr_tiles;
        for (WalkingPapersTile t : tiles) {
            if (dropCount <= 0) break;
            t.dropImage();
            --dropCount;
        }
    }

    void loadSingleTile(WalkingPapersTile tile) {
        tile.loadImage();
        this.checkTileStorage();
    }

    Double getImageScaling(Image img, Point p0, Point p1) {
        int realWidth = img.getWidth(this);
        int realHeight = img.getHeight(this);
        if (realWidth == -1 || realHeight == -1) {
            return null;
        }
        int drawWidth = p1.x - p0.x;
        int drawHeight = p1.x - p0.x;
        double drawArea = drawWidth * drawHeight;
        double realArea = realWidth * realHeight;
        return drawArea / realArea;
    }

    public void paint(Graphics g, MapView mv) {
        int y;
        int tmp;
        LatLon topLeft = mv.getLatLon(0, 0);
        LatLon botRight = mv.getLatLon(mv.getWidth(), mv.getHeight());
        Graphics oldg = g;
        if (botRight.lon() == 0.0 || botRight.lat() == 0.0) {
            return;
        }
        if (this.lastTopLeft != null && this.lastBotRight != null && topLeft.equalsEpsilon(this.lastTopLeft) && botRight.equalsEpsilon(this.lastBotRight) && this.bufferImage != null && mv.getWidth() == this.bufferImage.getWidth(null) && mv.getHeight() == this.bufferImage.getHeight(null) && !this.needRedraw) {
            g.drawImage(this.bufferImage, 0, 0, null);
            return;
        }
        this.needRedraw = false;
        this.lastTopLeft = topLeft;
        this.lastBotRight = botRight;
        this.bufferImage = mv.createImage(mv.getWidth(), mv.getHeight());
        g = this.bufferImage.getGraphics();
        if (!(LatLon.isValidLat((double)topLeft.lat()) && LatLon.isValidLat((double)botRight.lat()) && LatLon.isValidLon((double)topLeft.lon()) && LatLon.isValidLon((double)botRight.lon()))) {
            return;
        }
        this.viewportMinX = this.lonToTileX(topLeft.lon());
        this.viewportMaxX = this.lonToTileX(botRight.lon());
        this.viewportMinY = this.latToTileY(topLeft.lat());
        this.viewportMaxY = this.latToTileY(botRight.lat());
        if (this.viewportMinX > this.viewportMaxX) {
            tmp = this.viewportMinX;
            this.viewportMinX = this.viewportMaxX;
            this.viewportMaxX = tmp;
        }
        if (this.viewportMinY > this.viewportMaxY) {
            tmp = this.viewportMinY;
            this.viewportMinY = this.viewportMaxY;
            this.viewportMaxY = tmp;
        }
        if (this.viewportMaxX - this.viewportMinX > 18) {
            return;
        }
        if (this.viewportMaxY - this.viewportMinY > 18) {
            return;
        }
        for (int x = this.viewportMinX - 1; x <= this.viewportMaxX + 1; ++x) {
            double lon = this.tileXToLon(x);
            for (y = this.viewportMinY - 1; y <= this.viewportMaxY + 1; ++y) {
                LatLon tmpLL = new LatLon(this.tileYToLat(y), lon);
                this.pixelpos[x - this.viewportMinX + 1][y - this.viewportMinY + 1] = mv.getPoint(Main.proj.latlon2eastNorth(tmpLL));
            }
        }
        g.setColor(Color.DARK_GRAY);
        Double imageScale = null;
        int count = 0;
        for (int x = this.viewportMinX - 1; x <= this.viewportMaxX; ++x) {
            for (y = this.viewportMinY - 1; y <= this.viewportMaxY; ++y) {
                Image img;
                WalkingPapersKey key = new WalkingPapersKey(this.currentZoomLevel, x, y);
                WalkingPapersTile tile = this.tileStorage.get(key);
                if (!key.valid) continue;
                if (tile == null) {
                    Bounds tileBounds = new Bounds(new LatLon(this.tileYToLat(y + 1), this.tileXToLon(x)), new LatLon(this.tileYToLat(y), this.tileXToLon(x + 1)));
                    if (!tileBounds.asRect().intersects(this.printBounds.asRect())) continue;
                    tile = new WalkingPapersTile(x, y, this.currentZoomLevel, this);
                    this.tileStorage.put(key, tile);
                    this.loadSingleTile(tile);
                    this.checkTileStorage();
                }
                if ((img = tile.getImage()) == null) continue;
                Point p = this.pixelpos[x - this.viewportMinX + 1][y - this.viewportMinY + 1];
                Point p2 = this.pixelpos[x - this.viewportMinX + 2][y - this.viewportMinY + 2];
                g.drawImage(img, p.x, p.y, p2.x - p.x, p2.y - p.y, this);
                if (imageScale == null) {
                    imageScale = this.getImageScaling(img, p, p2);
                }
                ++count;
            }
        }
        if (count == 0) {
            return;
        }
        oldg.drawImage(this.bufferImage, 0, 0, null);
        if (imageScale != null) {
            if (imageScale > 3.0) {
                this.increaseZoomLevel();
                this.paint(oldg, mv);
            } else if (imageScale < 0.32) {
                this.decreaseZoomLevel();
                this.paint(oldg, mv);
            }
        }
    }

    WalkingPapersTile getTileForPixelpos(int px, int py) {
        int tilex = this.viewportMaxX;
        int tiley = this.viewportMaxY;
        for (int x = this.viewportMinX; x <= this.viewportMaxX; ++x) {
            if (this.pixelpos[x - this.viewportMinX + 1][0].x <= px) continue;
            tilex = x - 1;
            break;
        }
        if (tilex == -1) {
            return null;
        }
        for (int y = this.viewportMinY; y <= this.viewportMaxY; ++y) {
            if (this.pixelpos[0][y - this.viewportMinY + 1].y <= py) continue;
            tiley = y - 1;
            break;
        }
        if (tiley == -1) {
            return null;
        }
        WalkingPapersKey key = new WalkingPapersKey(this.currentZoomLevel, tilex, tiley);
        if (!key.valid) {
            System.err.println("getTileForPixelpos(" + px + "," + py + ") made invalid key");
            return null;
        }
        WalkingPapersTile tile = this.tileStorage.get(key);
        if (tile == null) {
            tile = new WalkingPapersTile(tilex, tiley, this.currentZoomLevel, this);
            this.tileStorage.put(key, tile);
        }
        this.checkTileStorage();
        return tile;
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"walkingpapers");
    }

    public Object getInfoComponent() {
        return null;
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)LayerListDialog.getInstance().createShowHideLayerAction((Layer)this)), new JMenuItem((Action)LayerListDialog.getInstance().createDeleteLayerAction((Layer)this)), new JSeparator(), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public String getToolTipText() {
        return null;
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
        if (this.printBounds != null) {
            v.visit(this.printBounds);
        }
    }

    private int latToTileY(double lat) {
        double l = lat / 180.0 * Math.PI;
        double pf = Math.log(Math.tan(l) + 1.0 / Math.cos(l));
        return (int)(Math.pow(2.0, this.currentZoomLevel - 1) * (Math.PI - pf) / Math.PI);
    }

    private int lonToTileX(double lon) {
        return (int)(Math.pow(2.0, this.currentZoomLevel - 3) * (lon + 180.0) / 45.0);
    }

    private double tileYToLat(int y) {
        return Math.atan(Math.sinh(Math.PI - Math.PI * (double)y / Math.pow(2.0, this.currentZoomLevel - 1))) * 180.0 / Math.PI;
    }

    private double tileXToLon(int x) {
        return (double)x * 45.0 / Math.pow(2.0, this.currentZoomLevel - 3) - 180.0;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        boolean done;
        boolean bl = done = (infoflags & 0x70) != 0;
        if ((infoflags & 0x40) != 0) {
            return false;
        }
        this.needRedraw = true;
        Main.map.repaint(done ? 0L : 100L);
        return !done;
    }

    public void destroy() {
        Main.pref.listener.remove(this);
    }

    public String getWalkingPapersId() {
        return this.walkingPapersId;
    }

    public URL formatImageUrl(int x, int y, int z) {
        String urlstr = this.tileUrlTemplate.replace("{x}", String.valueOf(x)).replace("{y}", String.valueOf(y)).replace("{z}", String.valueOf(z));
        try {
            return new URL(urlstr);
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TileTimeComp
    implements Comparator<WalkingPapersTile> {
        TileTimeComp() {
        }

        @Override
        public int compare(WalkingPapersTile s1, WalkingPapersTile s2) {
            long t1 = s1.access_time();
            long t2 = s2.access_time();
            if (s1 == s2) {
                return 0;
            }
            if (t1 == t2) {
                t1 = s1.hashCode();
                t2 = s2.hashCode();
            }
            if (t1 < t2) {
                return -1;
            }
            return 1;
        }
    }
}

