/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.util;

import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.plugins.validator.util.NameVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleNameVisitor
extends NameVisitor {
    String multipleClassname;
    String displayName;
    int size;

    public void visit(Collection<? extends OsmPrimitive> data) {
        String multipleName = null;
        String multiplePluralClassname = null;
        String firstName = null;
        boolean initializedname = false;
        this.size = data.size();
        this.multipleClassname = null;
        for (OsmPrimitive osmPrimitive : data) {
            String name = osmPrimitive.get("name");
            if (name == null) {
                name = osmPrimitive.get("ref");
            }
            if (!initializedname) {
                multipleName = name;
                initializedname = true;
            } else if (!(multipleName == null || name != null && name.equals(multipleName))) {
                multipleName = null;
            }
            if (firstName == null && name != null) {
                firstName = name;
            }
            osmPrimitive.visit((Visitor)this);
            if (this.multipleClassname == null) {
                this.multipleClassname = this.className;
                multiplePluralClassname = this.classNamePlural;
                continue;
            }
            if (this.multipleClassname.equals(this.className)) continue;
            this.multipleClassname = "object";
            multiplePluralClassname = I18n.trn((String)"object", (String)"objects", (long)2L);
        }
        this.displayName = this.size == 1 ? this.name : (multipleName != null ? String.valueOf(this.size) + " " + I18n.trn((String)this.multipleClassname, multiplePluralClassname, (long)this.size) + ": " + multipleName : (firstName != null ? String.valueOf(this.size) + " " + I18n.trn((String)this.multipleClassname, multiplePluralClassname, (long)this.size) + ": " + I18n.tr((String)"{0}, ...", (Object[])new Object[]{firstName}) : String.valueOf(this.size) + " " + I18n.trn((String)this.multipleClassname, multiplePluralClassname, (long)this.size)));
    }

    @Override
    public JLabel toLabel() {
        return new JLabel(this.getText(), this.getIcon(), 0);
    }

    public String getText() {
        return this.displayName;
    }

    public Icon getIcon() {
        if (this.size == 1) {
            return this.icon;
        }
        return ImageProvider.get((String)"data", (String)this.multipleClassname);
    }
}

