/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

public class Coastlines
extends Test {
    protected static int UNORDERED_COASTLINE = 901;
    protected static int REVERSED_COASTLINE = 902;
    protected static int UNCONNECTED_COASTLINE = 903;
    private boolean fixable = false;

    public Coastlines() {
        super(I18n.tr((String)"Coastlines."), I18n.tr((String)"This test checks that coastlines are correct."));
    }

    public void visit(Way way) {
        boolean lastNodeUnordered;
        if (!way.isUsable() || way.isClosed()) {
            return;
        }
        String natural = way.get("natural");
        if (natural == null || !natural.equals("coastline")) {
            return;
        }
        Node firstNode = way.firstNode();
        Node lastNode = way.lastNode();
        Way previousWay = null;
        Way nextWay = null;
        for (OsmPrimitive parent : this.backreferenceDataSet.getParents((OsmPrimitive)firstNode)) {
            natural = parent.get("natural");
            if (!(parent instanceof Way) || way.equals((Object)parent) || natural == null || !"coastline".equals(natural)) continue;
            previousWay = (Way)parent;
            break;
        }
        for (OsmPrimitive parent : this.backreferenceDataSet.getParents((OsmPrimitive)lastNode)) {
            natural = parent.get("natural");
            if (!(parent instanceof Way) || way.equals((Object)parent) || natural == null || !"coastline".equals(natural)) continue;
            nextWay = (Way)parent;
            break;
        }
        ArrayList<Way> primitives = new ArrayList<Way>();
        ArrayList<Node> highlight = new ArrayList<Node>();
        primitives.add(way);
        OsmDataLayer layer = Main.map.mapView.getEditLayer();
        Area downloadedArea = null;
        if (layer != null) {
            downloadedArea = layer.data.getDataSourceArea();
        }
        if (previousWay == null || nextWay == null) {
            boolean firstNodeUnconnected = false;
            boolean lastNodeUnconnected = false;
            if (previousWay == null && (downloadedArea == null || downloadedArea.contains((Point2D)firstNode.getCoor()))) {
                firstNodeUnconnected = true;
                highlight.add(firstNode);
            }
            if (nextWay == null && (downloadedArea == null || downloadedArea.contains((Point2D)lastNode.getCoor()))) {
                lastNodeUnconnected = true;
                highlight.add(lastNode);
            }
            if (firstNodeUnconnected || lastNodeUnconnected) {
                this.errors.add(new TestError(this, Severity.ERROR, I18n.tr((String)"Unconnected coastline"), UNCONNECTED_COASTLINE, primitives, highlight));
            }
        }
        boolean firstNodeUnordered = previousWay != null && !firstNode.equals((Object)previousWay.lastNode());
        boolean bl = lastNodeUnordered = nextWay != null && !lastNode.equals((Object)nextWay.firstNode());
        if (firstNodeUnordered || lastNodeUnordered) {
            if (firstNodeUnordered && lastNodeUnordered && !previousWay.equals((Object)nextWay)) {
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"Reversed coastline"), REVERSED_COASTLINE, primitives));
            } else {
                if (firstNodeUnordered) {
                    highlight.add(firstNode);
                }
                if (lastNodeUnordered) {
                    highlight.add(lastNode);
                }
                this.errors.add(new TestError(this, Severity.ERROR, I18n.tr((String)"Unordered coastline"), UNORDERED_COASTLINE, primitives, highlight));
            }
        }
    }

    public Command fixError(TestError testError) {
        if (this.isFixable(testError)) {
            Way way = (Way)testError.getPrimitives().iterator().next();
            Way newWay = new Way(way);
            List nodesCopy = newWay.getNodes();
            Collections.reverse(nodesCopy);
            newWay.setNodes(nodesCopy);
            return new ChangeCommand((OsmPrimitive)way, (OsmPrimitive)newWay);
        }
        return null;
    }

    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof Coastlines) {
            return testError.getCode() == REVERSED_COASTLINE;
        }
        return false;
    }
}

