/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.editgpx;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

class GPXLayerImportAction
extends AbstractAction {
    private static final long serialVersionUID = 5794897888911798168L;
    private DataSet dataSet;
    public Object importing = new Object();

    public GPXLayerImportAction(DataSet ds) {
        super(I18n.tr((String)"Import path from GPX layer"), ImageProvider.get((String)"dialogs", (String)"edit"));
        this.dataSet = ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateImport() {
        Box panel = Box.createVerticalBox();
        DefaultListModel<Layer> dModel = new DefaultListModel<Layer>();
        final JList<Object> layerList = new JList<Object>(dModel);
        Collection data = Main.map.mapView.getAllLayers();
        Layer lastLayer = null;
        int layerCnt = 0;
        for (Layer l : data) {
            if (!(l instanceof GpxLayer)) continue;
            dModel.addElement(l);
            lastLayer = l;
            ++layerCnt;
        }
        if (layerCnt == 1) {
            layerList.setSelectedValue(lastLayer, true);
        }
        if (layerCnt > 0) {
            layerList.setCellRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Layer layer = (Layer)value;
                    JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, layer.getName(), index, isSelected, cellHasFocus);
                    Icon icon = layer.getIcon();
                    label.setIcon(icon);
                    label.setToolTipText(layer.getToolTipText());
                    return label;
                }
            });
            JCheckBox dropFirst = new JCheckBox(I18n.tr((String)"Drop existing path"));
            panel.add(layerList);
            panel.add(dropFirst);
            JOptionPane optionPane = new JOptionPane(panel, 3, 2){

                public void selectInitialValue() {
                    layerList.requestFocusInWindow();
                }
            };
            JDialog dlg = optionPane.createDialog(Main.parent, I18n.tr((String)"Import path from GPX layer"));
            dlg.setVisible(true);
            Object answer = optionPane.getValue();
            if (answer == null || answer == JOptionPane.UNINITIALIZED_VALUE || answer instanceof Integer && (Integer)answer != 0) {
                return;
            }
            GpxLayer gpx = (GpxLayer)layerList.getSelectedValue();
            Object object = this.importing;
            synchronized (object) {
                for (GpxTrack trk : gpx.data.tracks) {
                    for (Collection segment : trk.trackSegs) {
                        Way w = new Way();
                        for (WayPoint p : segment) {
                            Node n = new Node(p.getCoor());
                            String timestr = p.getString("time");
                            if (timestr != null) {
                                n.setTimestamp(DateUtils.fromString((String)timestr));
                            }
                            this.dataSet.addPrimitive((OsmPrimitive)n);
                            w.addNode(n);
                        }
                        this.dataSet.addPrimitive((OsmPrimitive)w);
                    }
                }
            }
            Main.map.mapView.repaint();
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No GPX data layer found."));
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        this.activateImport();
    }
}

