/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.editor;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.logging.Logger;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.openstreetmap.josm.plugins.tageditor.ac.AutoCompletionList;

public class TagFieldEditor
extends JTextField {
    private static Logger logger = Logger.getLogger(TagFieldEditor.class.getName());
    protected AutoCompletionList autoCompletionList = null;

    protected Document createDefaultModel() {
        return new AutoCompletionDocument();
    }

    public TagFieldEditor() {
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                TagFieldEditor.this.selectAll();
                TagFieldEditor.this.applyFilter(TagFieldEditor.this.getText());
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (TagFieldEditor.this.getText().equals("")) {
                    TagFieldEditor.this.applyFilter("");
                }
            }
        });
    }

    protected void applyFilter(String filter) {
        if (this.autoCompletionList != null) {
            this.autoCompletionList.applyFilter(filter);
        }
    }

    public AutoCompletionList getAutoCompletionList() {
        return this.autoCompletionList;
    }

    public void setAutoCompletionList(AutoCompletionList autoCompletionList) {
        this.autoCompletionList = autoCompletionList;
    }

    class AutoCompletionDocument
    extends PlainDocument {
        AutoCompletionDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (TagFieldEditor.this.autoCompletionList == null) {
                super.insertString(offs, str, a);
                return;
            }
            if (offs < this.getLength()) {
                super.insertString(offs, str, a);
                return;
            }
            String currentText = this.getText(0, this.getLength());
            String prefix = currentText.substring(0, offs);
            TagFieldEditor.this.autoCompletionList.applyFilter(prefix + str);
            if (TagFieldEditor.this.autoCompletionList.getFilteredSize() > 0) {
                String matchingString = TagFieldEditor.this.autoCompletionList.getFilteredItem(0).getValue();
                this.remove(0, this.getLength());
                super.insertString(0, matchingString, a);
                TagFieldEditor.this.setCaretPosition(this.getLength());
                TagFieldEditor.this.moveCaretPosition(offs + str.length());
            } else {
                String newText = prefix + str;
                this.remove(0, this.getLength());
                super.insertString(0, newText, a);
                TagFieldEditor.this.setCaretPosition(this.getLength());
            }
        }
    }
}

