/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.plugins.tageditor.ac.AutoCompletionCache;
import org.openstreetmap.josm.plugins.tageditor.ac.AutoCompletionList;
import org.openstreetmap.josm.plugins.tageditor.ac.AutoCompletionListViewer;
import org.openstreetmap.josm.plugins.tageditor.editor.TagEditor;
import org.openstreetmap.josm.plugins.tageditor.editor.TagEditorModel;
import org.openstreetmap.josm.plugins.tageditor.preset.Item;
import org.openstreetmap.josm.plugins.tageditor.preset.ui.IPresetSelectorListener;
import org.openstreetmap.josm.plugins.tageditor.preset.ui.TabularPresetSelector;
import org.openstreetmap.josm.plugins.tageditor.tagspec.KeyValuePair;
import org.openstreetmap.josm.plugins.tageditor.tagspec.ui.ITagSelectorListener;
import org.openstreetmap.josm.plugins.tageditor.tagspec.ui.TabularTagSelector;
import org.openstreetmap.josm.tools.I18n;

public class TagEditorDialog
extends JDialog {
    private static Logger logger = Logger.getLogger(TagEditorDialog.class.getName());
    protected static TagEditorDialog instance = null;
    public static final Dimension PREFERRED_SIZE = new Dimension(700, 500);
    private TagEditor tagEditor = null;
    private TagEditorModel model = null;
    private AutoCompletionListViewer aclViewer = null;
    private AutoCompletionCache acCache = new AutoCompletionCache();
    private JButton btnOK = null;
    private JButton btnCancel = null;
    private JButton btnAdd = null;
    private JButton btnDelete = null;
    private OKAction okAction = null;
    private CancelAction cancelAction = null;

    public static TagEditorDialog getInstance() {
        if (instance == null) {
            instance = new TagEditorDialog();
        }
        return instance;
    }

    public OKAction getOKAction() {
        return this.okAction;
    }

    public TagEditorModel getModel() {
        return this.model;
    }

    protected JPanel buildButtonRow() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(2));
        this.okAction = new OKAction();
        this.btnOK = new JButton(this.okAction);
        this.getModel().addPropertyChangeListener(this.okAction);
        this.cancelAction = new CancelAction();
        this.btnCancel = new JButton(this.cancelAction);
        pnl.add(this.btnOK);
        pnl.add(this.btnCancel);
        JPanel pnl1 = new JPanel();
        pnl.setLayout(new FlowLayout(0));
        this.btnAdd = new JButton(this.tagEditor.getAddAction());
        this.btnDelete = new JButton(this.tagEditor.getDeleteAction());
        pnl1.add(this.btnAdd);
        pnl1.add(this.btnDelete);
        JPanel pnl2 = new JPanel();
        pnl2.setLayout(new BorderLayout());
        pnl2.add((Component)pnl1, "West");
        pnl2.add((Component)pnl, "East");
        return pnl2;
    }

    protected void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setModal(true);
        this.setSize(PREFERRED_SIZE);
        this.setTitle(I18n.tr((String)"JOSM Tag Editor Plugin"));
        this.tagEditor = new TagEditor();
        this.tagEditor.setTagEditorModel(this.model);
        AutoCompletionList autoCompletionList = new AutoCompletionList();
        this.aclViewer = new AutoCompletionListViewer(autoCompletionList);
        this.tagEditor.setAutoCompletionList(autoCompletionList);
        this.tagEditor.setAutoCompletionCache(this.acCache);
        this.aclViewer.addAutoCompletionListListener(this.tagEditor);
        JPanel pnlTagGrid = new JPanel();
        pnlTagGrid.setLayout(new BorderLayout());
        pnlTagGrid.add((Component)this.tagEditor, "Center");
        pnlTagGrid.add((Component)this.aclViewer, "East");
        pnlTagGrid.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        TabularPresetSelector presetSelector = new TabularPresetSelector();
        presetSelector.addPresetSelectorListener(new IPresetSelectorListener(){

            public void itemSelected(Item item) {
                TagEditorDialog.this.tagEditor.stopEditing();
                TagEditorDialog.this.model.applyPreset(item);
                TagEditorDialog.this.tagEditor.requestFocusInTopLeftCell();
            }
        });
        JPanel pnlPresetSelector = new JPanel();
        pnlPresetSelector.setLayout(new BorderLayout());
        pnlPresetSelector.add((Component)presetSelector, "Center");
        pnlPresetSelector.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        TabularTagSelector tagSelector = new TabularTagSelector();
        tagSelector.addTagSelectorListener(new ITagSelectorListener(){

            public void itemSelected(KeyValuePair pair) {
                TagEditorDialog.this.tagEditor.stopEditing();
                TagEditorDialog.this.model.applyKeyValuePair(pair);
                TagEditorDialog.this.tagEditor.requestFocusInTopLeftCell();
            }
        });
        JPanel pnlTagSelector = new JPanel();
        pnlTagSelector.setLayout(new BorderLayout());
        pnlTagSelector.add((Component)tagSelector, "Center");
        pnlTagSelector.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add((Component)pnlPresetSelector, I18n.tr((String)"Presets"));
        tabbedPane.add((Component)pnlTagSelector, I18n.tr((String)"Tags"));
        JSplitPane splitPane = new JSplitPane(0, tabbedPane, pnlTagGrid);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(200);
        Dimension minimumSize = new Dimension(100, 50);
        presetSelector.setMinimumSize(minimumSize);
        pnlTagGrid.setMinimumSize(minimumSize);
        this.getContentPane().add((Component)splitPane, "Center");
        this.getContentPane().add((Component)this.buildButtonRow(), "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TagEditorDialog.this.getModel().ensureOneTag();
                        TagEditorDialog.this.tagEditor.clearSelection();
                        TagEditorDialog.this.tagEditor.requestFocusInTopLeftCell();
                    }
                });
            }
        });
        this.getRootPane().getInputMap(2).put((KeyStroke)this.cancelAction.getValue("AcceleratorKey"), this.okAction.getValue("Name"));
        this.getRootPane().getActionMap().put(this.cancelAction.getValue("Name"), this.cancelAction);
        this.getRootPane().getInputMap(2).put((KeyStroke)this.okAction.getValue("AcceleratorKey"), this.okAction.getValue("Name"));
        this.getRootPane().getActionMap().put(this.okAction.getValue("Name"), this.okAction);
        this.aclViewer.installKeyAction(this.okAction);
        this.aclViewer.installKeyAction(this.cancelAction);
        presetSelector.installKeyAction(this.okAction);
        presetSelector.installKeyAction(this.cancelAction);
    }

    protected TagEditorDialog() {
        this.model = new TagEditorModel();
        this.build();
    }

    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    public void startEditSession() {
        this.model.clearAppliedPresets();
        this.model.initFromJOSMSelection();
        this.acCache.initFromJOSMDataset();
        this.getModel().ensureOneTag();
    }

    class OKAction
    extends AbstractAction
    implements PropertyChangeListener {
        public OKAction() {
            this.putValue("Name", I18n.tr((String)"OK"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl ENTER"));
        }

        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        public void run() {
            TagEditorDialog.this.tagEditor.stopEditing();
            TagEditorDialog.this.setVisible(false);
            TagEditorDialog.this.model.updateJOSMSelection();
            DataSet ds = Main.main.getCurrentDataSet();
            ds.fireSelectionChanged();
            Main.parent.repaint();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals(TagEditorModel.PROP_DIRTY)) {
                return;
            }
            if (!evt.getNewValue().getClass().equals(Boolean.class)) {
                return;
            }
            boolean dirty = (Boolean)evt.getNewValue();
            this.setEnabled(dirty);
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr((String)"Cancel"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
        }

        public void actionPerformed(ActionEvent arg0) {
            TagEditorDialog.this.setVisible(false);
        }
    }
}

