/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CacheFileFilter;
import cadastre_fr.CadastrePlugin;
import cadastre_fr.WMSLayer;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.projection.Lambert;
import org.openstreetmap.josm.data.projection.LambertCC9Zones;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;

public class MenuActionLoadFromCache
extends JosmAction {
    private static final long serialVersionUID = 1L;
    public static String name = "Load layer from cache";

    public MenuActionLoadFromCache() {
        super(I18n.tr((String)name), "cadastre_small", I18n.tr((String)"Load location from cache (only if cache is enabled)"), null, false);
    }

    public void actionPerformed(ActionEvent e) {
        File[] files;
        JFileChooser fc = MenuActionLoadFromCache.createAndOpenFileChooser();
        if (fc == null) {
            return;
        }
        block2: for (File file : files = fc.getSelectedFiles()) {
            WMSLayer wmsLayer;
            String location;
            String ext;
            String filename;
            block11: {
                if (!file.exists()) continue;
                filename = file.getName();
                String string = ext = filename.lastIndexOf(".") == -1 ? "" : filename.substring(filename.lastIndexOf(".") + 1, filename.length());
                if (ext.length() > 2 && ext.substring(0, "CC".length()).equals("CC") && !(Main.proj instanceof LambertCC9Zones) || ext.length() == 1 && !(Main.proj instanceof Lambert)) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"{0} not allowed with the current projection", (Object[])new Object[]{filename}), I18n.tr((String)"Error"), 0);
                    continue;
                }
                location = filename.substring(0, filename.lastIndexOf("."));
                if (ext.length() > 2 && ext.substring(0, "CC".length()).equals("CC")) {
                    ext = ext.substring(2);
                }
                try {
                    int cacheZone = Integer.parseInt(ext) - 1;
                    if (cacheZone < 0 || cacheZone > 3) break block11;
                    if (Lambert.layoutZone == -1) {
                        Lambert.layoutZone = cacheZone;
                        System.out.println("Load cache \"" + filename + "\" in Lambert Zone " + (Lambert.layoutZone + 1));
                    } else {
                        if (cacheZone != Lambert.layoutZone) {
                            System.out.println("Cannot load cache \"" + filename + "\" which is not in current Lambert Zone " + Lambert.layoutZone);
                            continue;
                        }
                        System.out.println("Load cache " + filename);
                    }
                }
                catch (NumberFormatException ex) {
                    System.out.println("Selected file \"" + filename + "\" is not a WMS cache file (invalid extension)");
                    continue;
                }
            }
            if (Main.map != null) {
                for (Layer l : Main.map.mapView.getAllLayers()) {
                    if (!(l instanceof WMSLayer) || !l.getName().equals(location)) continue;
                    System.out.println("The location " + filename + " is already on screen. Cache not loaded.");
                    continue block2;
                }
            }
            if (!(wmsLayer = new WMSLayer("", "", Integer.parseInt(ext) - 1)).getCacheControl().loadCache(file, Lambert.layoutZone)) continue;
            Main.main.addLayer((Layer)wmsLayer);
        }
    }

    protected static JFileChooser createAndOpenFileChooser() {
        JFileChooser fc = new JFileChooser(new File(CadastrePlugin.cacheDir));
        fc.setMultiSelectionEnabled(true);
        if (Lambert.layoutZone != -1) {
            fc.addChoosableFileFilter(CacheFileFilter.filters[Lambert.layoutZone]);
        }
        fc.setAcceptAllFileFilterUsed(false);
        int answer = fc.showOpenDialog(Main.parent);
        if (answer != 0) {
            return null;
        }
        return fc;
    }
}

