/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.remotecontrol;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestProcessor
extends Thread {
    private Socket request;

    public RequestProcessor(Socket request) {
        super("RemoteControl request processor");
        this.setDaemon(true);
        this.request = request;
    }

    public static void processRequest(Socket request) {
        RequestProcessor processor = new RequestProcessor(request);
        processor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        OutputStreamWriter out = null;
        try {
            block81: {
                DownloadOsmTask osmTask;
                HashMap<String, String> args;
                String command;
                String url;
                block80: {
                    int c;
                    BufferedOutputStream raw = new BufferedOutputStream(this.request.getOutputStream());
                    out = new OutputStreamWriter(raw);
                    InputStreamReader in = new InputStreamReader((InputStream)new BufferedInputStream(this.request.getInputStream()), "ASCII");
                    StringBuffer requestLine = new StringBuffer();
                    while (requestLine.length() < 1024 && (c = ((Reader)in).read()) != 13 && c != 10) {
                        requestLine.append((char)c);
                    }
                    System.out.println("RemoteControl received: " + requestLine);
                    String get = requestLine.toString();
                    StringTokenizer st = new StringTokenizer(get);
                    if (!st.hasMoreTokens()) {
                        this.sendError(out);
                        return;
                    }
                    String method = st.nextToken();
                    if (!st.hasMoreTokens()) {
                        this.sendError(out);
                        return;
                    }
                    url = st.nextToken();
                    if (!method.equals("GET")) {
                        this.sendNotImplemented(out);
                        return;
                    }
                    st = new StringTokenizer(url, "&?");
                    command = null;
                    args = new HashMap<String, String>();
                    while (st.hasMoreTokens()) {
                        String param = st.nextToken();
                        if (command == null) {
                            command = param;
                            continue;
                        }
                        int eq = param.indexOf("=");
                        if (eq <= -1) continue;
                        args.put(param.substring(0, eq), param.substring(eq + 1));
                    }
                    if (!command.equals("/load_and_zoom")) break block80;
                    if (Main.pref.getBoolean("remotecontrol.always-confirm", false) && JOptionPane.showConfirmDialog(Main.parent, "<html>" + I18n.tr((String)"Remote Control has been asked to load data from the API.") + "<br>" + I18n.tr((String)"Request details: {0}", (Object[])new Object[]{url}) + "<br>" + I18n.tr((String)"Do you want to allow this?"), I18n.tr((String)"Confirm Remote Control action"), 0) != 0) {
                        this.sendForbidden(out);
                        return;
                    }
                    osmTask = new DownloadOsmTask();
                    if (!(args.containsKey("bottom") && args.containsKey("top") && args.containsKey("left") && args.containsKey("right"))) {
                        this.sendBadRequest(out);
                        System.out.println("load_and_zoom remote control request must have bottom,top,left,right parameters");
                        return;
                    }
                    double minlat = 0.0;
                    double maxlat = 0.0;
                    double minlon = 0.0;
                    double maxlon = 0.0;
                    try {
                        minlat = Double.parseDouble(args.get("bottom"));
                        maxlat = Double.parseDouble(args.get("top"));
                        minlon = Double.parseDouble(args.get("left"));
                        maxlon = Double.parseDouble(args.get("right"));
                        if (!Main.pref.getBoolean("remotecontrol.permission.load-data", true)) {
                            throw new LoadDeniedException();
                        }
                        Area present = null;
                        DataSet ds = Main.main.getCurrentDataSet();
                        if (ds != null) {
                            present = ds.getDataSourceArea();
                        }
                        if (present != null && !present.isEmpty()) {
                            Area toDownload = new Area(new Rectangle2D.Double(minlon, minlat, maxlon - minlon, maxlat - minlat));
                            toDownload.subtract(present);
                            if (toDownload.isEmpty()) {
                                throw new AlreadyLoadedException();
                            }
                            Rectangle2D downloadBounds = toDownload.getBounds2D();
                            minlat = downloadBounds.getMinY();
                            minlon = downloadBounds.getMinX();
                            maxlat = downloadBounds.getMaxY();
                            maxlon = downloadBounds.getMaxX();
                        }
                        Future future = osmTask.download(false, new Bounds(minlat, minlon, maxlat, maxlon), null);
                        Main.worker.submit((Runnable)new PostDownloadHandler((DownloadTask)osmTask, future));
                    }
                    catch (AlreadyLoadedException ex) {
                        System.out.println("RemoteControl: no download necessary");
                    }
                    catch (LoadDeniedException ex) {
                        System.out.println("RemoteControl: download forbidden by preferences");
                    }
                    catch (Exception ex) {
                        this.sendError(out);
                        System.out.println("RemoteControl: Error parsing load_and_zoom remote control request:");
                        ex.printStackTrace();
                        try {
                            this.request.close();
                            return;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        return;
                    }
                    if (args.containsKey("select") && Main.pref.getBoolean("remotecontrol.permission.change-selection", true)) {
                        final String selection = args.get("select");
                        Main.worker.execute(new Runnable(){

                            public void run() {
                                HashSet<Long> ways = new HashSet<Long>();
                                HashSet<Long> nodes = new HashSet<Long>();
                                HashSet<Long> relations = new HashSet<Long>();
                                HashSet<Object> newSel = new HashSet<Object>();
                                for (String item : selection.split(",")) {
                                    if (item.startsWith("way")) {
                                        ways.add(Long.parseLong(item.substring(3)));
                                        continue;
                                    }
                                    if (item.startsWith("node")) {
                                        nodes.add(Long.parseLong(item.substring(4)));
                                        continue;
                                    }
                                    if (item.startsWith("relation")) {
                                        relations.add(Long.parseLong(item.substring(8)));
                                        continue;
                                    }
                                    System.out.println("RemoteControl: invalid selection '" + item + "' ignored");
                                }
                                for (Way w : Main.main.getCurrentDataSet().ways) {
                                    if (!ways.contains(w.getId())) continue;
                                    newSel.add(w);
                                }
                                for (Node n : Main.main.getCurrentDataSet().nodes) {
                                    if (!nodes.contains(n.getId())) continue;
                                    newSel.add(n);
                                }
                                for (Relation r : Main.main.getCurrentDataSet().relations) {
                                    if (!relations.contains(r.getId())) continue;
                                    newSel.add(r);
                                }
                                Main.main.getCurrentDataSet().setSelected(newSel);
                                if (Main.pref.getBoolean("remotecontrol.permission.change-viewport", true)) {
                                    new AutoScaleAction("selection").actionPerformed(null);
                                }
                            }
                        });
                        break block81;
                    } else if (Main.pref.getBoolean("remotecontrol.permission.change-viewport", true)) {
                        final Bounds bounds = new Bounds(new LatLon(minlat, minlon), new LatLon(maxlat, maxlon));
                        Main.worker.execute(new Runnable(){

                            public void run() {
                                BoundingXYVisitor bbox = new BoundingXYVisitor();
                                bbox.visit(bounds);
                                Main.map.mapView.recalculateCenterScale(bbox);
                            }
                        });
                    }
                    break block81;
                }
                if (command.equals("/add_node")) {
                    if (!Main.pref.getBoolean("remotecontrol.permission.create-objects", true)) {
                        this.sendForbidden(out);
                        return;
                    }
                    if (Main.pref.getBoolean("remotecontrol.always-confirm", false) && JOptionPane.showConfirmDialog(Main.parent, "<html>" + I18n.tr((String)"Remote Control has been asked to create a new node.") + "<br>" + I18n.tr((String)"Do you want to allow this?"), I18n.tr((String)"Confirm Remote Control action"), 0) != 0) {
                        this.sendForbidden(out);
                        return;
                    }
                    this.addNode(args, out);
                } else if (command.equals("/import")) {
                    if (Main.pref.getBoolean("remotecontrol.always-confirm", false) && JOptionPane.showConfirmDialog(Main.parent, "<html>" + I18n.tr((String)"Remote Control has been asked to import data from the following URL:") + "<br>" + url + "<br>" + I18n.tr((String)"Do you want to allow this?"), I18n.tr((String)"Confirm Remote Control action"), 0) != 0) {
                        this.sendForbidden(out);
                        return;
                    }
                    if (!args.containsKey("url")) {
                        this.sendBadRequest(out);
                        System.out.println("'import' remote control request must have url parameter");
                        return;
                    }
                    try {
                        if (!Main.pref.getBoolean("remotecontrol.permission.import", true)) {
                            throw new LoadDeniedException();
                        }
                        osmTask = new DownloadOsmTask();
                        osmTask.loadUrl(false, URLDecoder.decode(args.get("url"), "UTF-8"), null);
                    }
                    catch (LoadDeniedException ex) {
                        System.out.println("RemoteControl: import forbidden by preferences");
                    }
                    catch (Exception ex) {
                        this.sendError(out);
                        System.out.println("RemoteControl: Error parsing import remote control request:");
                        ex.printStackTrace();
                        try {
                            this.request.close();
                            return;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        return;
                    }
                }
            }
            this.sendHeader(out, "200 OK", "text/plain", false);
            out.write("Content-length: 4\r\n");
            out.write("\r\n");
            out.write("OK\r\n");
            ((Writer)out).flush();
            return;
        }
        catch (IOException ioe) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.sendError(out);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
                return;
            }
        }
        finally {
            try {
                this.request.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void addNode(HashMap<String, String> args, Writer out) throws IOException {
        if (!args.containsKey("lat") || !args.containsKey("lon")) {
            this.sendBadRequest(out);
            return;
        }
        double lat = Double.parseDouble(args.get("lat"));
        double lon = Double.parseDouble(args.get("lon"));
        System.out.println("Adding node at (" + lat + ", " + lon + ")");
        LatLon ll = new LatLon(lat, lon);
        Node nnew = new Node(ll);
        Main.main.undoRedo.add((Command)new AddCommand((OsmPrimitive)nnew));
        Main.main.getCurrentDataSet().setSelected(new OsmPrimitive[]{nnew});
        Main.map.mapView.repaint();
    }

    private void sendError(Writer out) throws IOException {
        this.sendHeader(out, "500 Internal Server Error", "text/html", true);
        out.write("<HTML>\r\n");
        out.write("<HEAD><TITLE>Internal Error</TITLE>\r\n");
        out.write("</HEAD>\r\n");
        out.write("<BODY>");
        out.write("<H1>HTTP Error 500: Internal Server Error</h2>\r\n");
        out.write("</BODY></HTML>\r\n");
        out.flush();
    }

    private void sendNotImplemented(Writer out) throws IOException {
        this.sendHeader(out, "501 Not Implemented", "text/html", true);
        out.write("<HTML>\r\n");
        out.write("<HEAD><TITLE>Not Implemented</TITLE>\r\n");
        out.write("</HEAD>\r\n");
        out.write("<BODY>");
        out.write("<H1>HTTP Error 501: Not Implemented</h2>\r\n");
        out.write("</BODY></HTML>\r\n");
        out.flush();
    }

    private void sendForbidden(Writer out) throws IOException {
        this.sendHeader(out, "403 Forbidden", "text/html", true);
        out.write("<HTML>\r\n");
        out.write("<HEAD><TITLE>Forbidden</TITLE>\r\n");
        out.write("</HEAD>\r\n");
        out.write("<BODY>");
        out.write("<H1>HTTP Error 403: Forbidden</h2>\r\n");
        out.write("</BODY></HTML>\r\n");
        out.flush();
    }

    private void sendBadRequest(Writer out) throws IOException {
        this.sendHeader(out, "400 Bad Request", "text/html", true);
        out.write("<HTML>\r\n");
        out.write("<HEAD><TITLE>Bad Request</TITLE>\r\n");
        out.write("</HEAD>\r\n");
        out.write("<BODY>");
        out.write("<H1>HTTP Error 400: Bad Request</h2>\r\n");
        out.write("</BODY></HTML>\r\n");
        out.flush();
    }

    private void sendHeader(Writer out, String status, String contentType, boolean endHeaders) throws IOException {
        out.write("HTTP/1.1 " + status + "\r\n");
        Date now = new Date();
        out.write("Date: " + now + "\r\n");
        out.write("Server: JOSM RemoteControl\r\n");
        out.write("Content-type: " + contentType + "\r\n");
        if (endHeaders) {
            out.write("\r\n");
        }
    }

    private class LoadDeniedException
    extends Exception {
        private LoadDeniedException() {
        }
    }

    private class AlreadyLoadedException
    extends Exception {
        private AlreadyLoadedException() {
        }
    }
}

