/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.ImageModifier;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import org.openstreetmap.josm.Main;

public class RasterImageModifier
extends ImageModifier {
    private int cadastreBackground = -1;
    public static int cadastreBackgroundTransp = 0xFFFFFF;
    private boolean transparencyEnabled = false;

    public RasterImageModifier(BufferedImage bi) {
        this.bufferedImage = bi;
        this.transparencyEnabled = Main.pref.getBoolean("cadastrewms.backgroundTransparent");
        if (this.transparencyEnabled) {
            this.makeTransparent();
        }
        if (Main.pref.getBoolean("cadastrewms.invertGrey")) {
            this.invertGrey();
        }
    }

    private void invertGrey() {
        int w = this.bufferedImage.getWidth();
        int h = this.bufferedImage.getHeight();
        int x = 0;
        while (x < w) {
            int y = 0;
            while (y < h) {
                int pixel = this.bufferedImage.getRGB(x, y);
                if (!this.transparencyEnabled && pixel != this.cadastreBackground || this.transparencyEnabled && pixel != cadastreBackgroundTransp) {
                    this.bufferedImage.setRGB(x, y, this.reverseIfGrey(pixel));
                }
                ++y;
            }
            ++x;
        }
    }

    private int reverseIfGrey(int pixel) {
        Color col = new Color(pixel);
        int r = col.getRed();
        int g = col.getGreen();
        int b = col.getBlue();
        if (b == r && b == g) {
            pixel = 0 + ((byte)(255 - r) << 16) + ((byte)(255 - r) << 8) + (byte)(255 - r);
        }
        return pixel;
    }

    private void makeTransparent() {
        if (this.bufferedImage.getColorModel() instanceof ComponentColorModel) {
            int width = this.bufferedImage.getWidth();
            int height = this.bufferedImage.getHeight();
            BufferedImage bi = new BufferedImage(width, height, 2);
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    int rgb = this.bufferedImage.getRGB(x, y);
                    Color c = new Color(rgb);
                    int r = c.getRed();
                    int g = c.getGreen();
                    int b = c.getBlue();
                    Color maskedColor = rgb == this.cadastreBackground ? new Color(r, g, b, 0) : new Color(r, g, b, 255);
                    bi.setRGB(x, y, maskedColor.getRGB());
                    ++x;
                }
                ++y;
            }
            this.bufferedImage = bi;
        }
    }

    public static BufferedImage fixRasterImage(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        BufferedImage bi = new BufferedImage(width, height, 2);
        int[] rgbArray = new int[width * height];
        img.getRGB(0, 0, width, height, rgbArray, 0, width);
        bi.setRGB(0, 0, width, height, rgbArray, 0, width);
        return bi;
    }
}

