/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

public class Coastlines
extends Test {
    protected static int UNORDERED_COASTLINE = 901;
    protected static int REVERSED_COASTLINE = 902;
    protected static int UNCONNECTED_COASTLINE = 903;
    private boolean fixable = false;

    public Coastlines() {
        super(I18n.tr((String)"Coastlines."), I18n.tr((String)"This test checks that coastlines are correct."));
    }

    public void visit(Way w) {
        boolean luo;
        if (!w.isUsable() || w.isClosed()) {
            return;
        }
        String natural = w.get("natural");
        if (natural == null || !natural.equals("coastline")) {
            return;
        }
        Node f = w.firstNode();
        Node l = w.lastNode();
        Way prev = null;
        Way next = null;
        for (OsmPrimitive parent : this.backreferenceDataSet.getParents((OsmPrimitive)f)) {
            natural = parent.get("natural");
            if (!(parent instanceof Way) || w.equals((Object)parent) || natural == null || !"coastline".equals(natural)) continue;
            prev = (Way)parent;
            break;
        }
        for (OsmPrimitive parent : this.backreferenceDataSet.getParents((OsmPrimitive)l)) {
            natural = parent.get("natural");
            if (!(parent instanceof Way) || w.equals((Object)parent) || natural == null || !"coastline".equals(natural)) continue;
            next = (Way)parent;
            break;
        }
        ArrayList<Way> primitives = new ArrayList<Way>();
        ArrayList<Node> highlight = new ArrayList<Node>();
        primitives.add(w);
        if (prev == null || next == null) {
            if (prev == null) {
                highlight.add(f);
            }
            if (next == null) {
                highlight.add(l);
            }
            this.errors.add(new TestError(this, Severity.ERROR, I18n.tr((String)"Unconnected coastline"), UNCONNECTED_COASTLINE, primitives, highlight));
        }
        boolean fuo = prev != null && !f.equals((Object)prev.lastNode());
        boolean bl = luo = next != null && !l.equals((Object)next.firstNode());
        if (fuo || luo) {
            if (fuo && luo) {
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"Reversed coastline"), REVERSED_COASTLINE, primitives));
            } else {
                if (fuo) {
                    highlight.add(f);
                }
                if (luo) {
                    highlight.add(l);
                }
                this.errors.add(new TestError(this, Severity.ERROR, I18n.tr((String)"Unordered coastline"), UNORDERED_COASTLINE, primitives, highlight));
            }
        }
    }

    public Command fixError(TestError testError) {
        if (this.isFixable(testError)) {
            Way w = (Way)testError.getPrimitives().iterator().next();
            Way wnew = new Way(w);
            List nodesCopy = wnew.getNodes();
            Collections.reverse(nodesCopy);
            wnew.setNodes(nodesCopy);
            return new ChangeCommand((OsmPrimitive)w, (OsmPrimitive)wnew);
        }
        return null;
    }

    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof Coastlines) {
            return testError.getCode() == REVERSED_COASTLINE;
        }
        return false;
    }
}

